/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client.gui.survival;

import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiKeybindElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.metamorph.ClientProxy;
import mchorse.metamorph.Metamorph;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.capabilities.morphing.Morphing;
import mchorse.metamorph.client.gui.survival.GuiSurvivalMorphs;
import mchorse.metamorph.network.Dispatcher;
import mchorse.metamorph.network.common.creative.PacketMorph;
import mchorse.metamorph.network.common.survival.PacketFavorite;
import mchorse.metamorph.network.common.survival.PacketKeybind;
import mchorse.metamorph.network.common.survival.PacketRemoveMorph;
import mchorse.metamorph.network.common.survival.PacketSelectMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;

public class GuiSurvivalScreen
extends GuiBase {
    public GuiSurvivalMorphs morphs;
    public GuiElement sidebar;
    public GuiToggleElement onlyFavorite;
    public GuiButtonElement morph;
    public GuiButtonElement remove;
    public GuiKeybindElement keybind;
    public GuiToggleElement favorite;
    private boolean creative;
    private boolean allowed;

    public GuiSurvivalScreen() {
        Minecraft mc = this.context.mc;
        this.morph = new GuiButtonElement(mc, IKey.lang((String)"metamorph.gui.morph"), this::morph);
        this.remove = new GuiButtonElement(mc, IKey.lang((String)"metamorph.gui.remove"), this::remove);
        this.keybind = new GuiKeybindElement(mc, this::setKeybind);
        this.keybind.tooltip(IKey.lang((String)"metamorph.gui.survival.keybind_tooltip"));
        this.favorite = new GuiToggleElement(mc, IKey.lang((String)"metamorph.gui.survival.favorite"), this::favorite);
        this.sidebar = new GuiScrollElement(mc);
        this.sidebar.flex().relative(this.root).y(20).w(140).hTo(this.root.resizer(), 1.0f).column(5).stretch().height(20).padding(10);
        this.sidebar.add(new IGuiElement[]{Elements.row((Minecraft)mc, (int)5, (int)0, (int)20, (GuiElement[])new GuiElement[]{this.morph, this.remove}), this.keybind, this.favorite});
        this.onlyFavorite = new GuiToggleElement(mc, IKey.lang((String)"metamorph.gui.survival.only_favorites"), button -> this.morphs.setFavorite(button.isToggled()));
        this.onlyFavorite.flex().relative(this.root).x(1.0f).w(120).h(20).anchor(1.0f, 0.0f);
        this.morphs = new GuiSurvivalMorphs(mc);
        this.morphs.flex().relative(this.root).x(140).y(20).wTo(this.root.resizer(), 1.0f).hTo(this.root.resizer(), 1.0f).column(0).vertical().stretch().scroll();
        this.root.flex().xy(0.5f, 0.5f).wh(1.0f, 1.0f).anchor(0.5f, 0.5f).maxW(500).maxH(300);
        this.root.add(new IGuiElement[]{this.morphs, this.sidebar, this.onlyFavorite});
        IKey category = IKey.lang((String)"metamorph.gui.survival.keys.category");
        this.root.keys().register(this.morph.label, 28, () -> this.morph.clickItself(GuiBase.getCurrent())).category(category);
        this.root.keys().register(this.remove.label, 14, () -> this.remove.clickItself(GuiBase.getCurrent())).category(category);
        this.root.keys().register(this.favorite.label, 33, () -> this.favorite.clickItself(GuiBase.getCurrent())).category(category);
        this.root.keys().register(IKey.lang((String)"metamorph.gui.survival.keys.toggle_favorites"), 24, () -> this.onlyFavorite.clickItself(GuiBase.getCurrent())).category(category);
        this.root.keys().register(IKey.lang((String)"metamorph.gui.survival.keys.focus_keybind"), 37, () -> this.keybind.clickItself(GuiBase.getCurrent())).category(category);
    }

    public boolean func_73868_f() {
        return (Boolean)Metamorph.pauseGUIInSP.get();
    }

    public GuiSurvivalScreen open() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        IMorphing cap = Morphing.get((EntityPlayer)player);
        boolean creative = player.func_184812_l_();
        boolean allowed = (Boolean)Metamorph.allowMorphingIntoCategoryMorphs.get();
        if (this.creative != creative || this.allowed != allowed || creative || this.morphs.sections.isEmpty()) {
            this.creative = creative;
            this.allowed = allowed;
            this.morphs.setupSections(creative, section -> this.fill(section.morph));
        }
        this.setSelected(cap.getCurrentMorph());
        return this;
    }

    public void setSelected(AbstractMorph morph) {
        this.morphs.setSelected(morph);
        this.fill(this.morphs.getSelected());
    }

    public void fill(AbstractMorph morph) {
        this.morph.setEnabled(morph != null);
        this.remove.setEnabled(morph != null);
        this.keybind.setEnabled(morph != null);
        this.keybind.setKeybind(0);
        this.favorite.setEnabled(morph != null);
        if (morph != null) {
            this.favorite.toggled(morph.favorite);
            this.keybind.setKeybind(morph.keybind);
        }
    }

    private void morph(GuiButtonElement button) {
        AbstractMorph morph = this.morphs.getSelected();
        if (morph != null) {
            if (this.morphs.isAcquiredSelected()) {
                Dispatcher.sendToServer(new PacketSelectMorph(this.indexOf(morph)));
            } else {
                Dispatcher.sendToServer(new PacketMorph(morph));
            }
            this.closeScreen();
        }
    }

    private void remove(GuiButtonElement button) {
        AbstractMorph morph = this.morphs.getSelected();
        if (morph != null) {
            if (this.morphs.isAcquiredSelected()) {
                Dispatcher.sendToServer(new PacketRemoveMorph(this.indexOf(morph)));
            } else {
                this.morphs.selected.category.remove(morph);
            }
            this.setSelected(null);
        }
    }

    private void setKeybind(int keybind) {
        AbstractMorph morph = this.morphs.getSelected();
        if (morph != null) {
            if (keybind == ClientProxy.keys.keyDemorph.func_151463_i()) {
                this.keybind.setKeybind(morph.keybind);
                return;
            }
            morph.keybind = keybind = keybind == 1 ? -1 : keybind;
            if (keybind == -1) {
                this.keybind.setKeybind(0);
            }
            if (this.morphs.isAcquiredSelected()) {
                Dispatcher.sendToServer(new PacketKeybind(this.indexOf(morph), keybind));
            } else {
                this.morphs.selected.category.edit(morph);
            }
        }
    }

    private void favorite(GuiToggleElement button) {
        AbstractMorph morph = this.morphs.getSelected();
        if (morph != null) {
            if (this.morphs.isAcquiredSelected()) {
                Dispatcher.sendToServer(new PacketFavorite(this.indexOf(morph)));
            } else {
                morph.favorite = button.isToggled();
                this.morphs.selected.category.edit(morph);
            }
        }
    }

    private int indexOf(AbstractMorph morph) {
        return this.morphs.acquired.getMorphs().indexOf(morph);
    }

    public void keyPressed(char typedChar, int keyCode) {
        if (keyCode == ClientProxy.keys.keyDemorph.func_151463_i()) {
            Dispatcher.sendToServer(new PacketSelectMorph(-1));
        } else if (MorphManager.INSTANCE.list.keyTyped((EntityPlayer)this.field_146297_k.field_71439_g, keyCode)) {
            this.closeScreen();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GuiDraw.drawCustomBackground((int)this.root.area.x, (int)this.root.area.y, (int)this.root.area.w, (int)this.root.area.h);
        this.sidebar.area.draw(-2013265920);
        Gui.func_73734_a((int)this.root.area.x, (int)this.root.area.y, (int)this.root.area.ex(), (int)(this.root.area.y + 20), (int)-872415232);
        this.context.font.func_175063_a(I18n.func_135052_a((String)"metamorph.gui.survival.title", (Object[])new Object[0]), (float)(this.root.area.x + 6), (float)(this.root.area.y + 10 - this.context.font.field_78288_b / 2), 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }
}

