/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client.gui.editor;

import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiInterpolationList;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.framework.tooltips.ITooltip;
import mchorse.mclib.client.gui.framework.tooltips.InterpolationTooltip;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.Interpolation;
import mchorse.metamorph.api.morphs.utils.Animation;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiAnimation
extends GuiElement {
    public GuiToggleElement animates;
    public GuiToggleElement ignored;
    public GuiTrackpadElement animationDuration;
    public GuiButtonElement pickInterpolation;
    public GuiListElement<Interpolation> interpolations;
    public Animation animation;
    private InterpolationTooltip interpolationTooltip = new InterpolationTooltip(0.0f, 0.0f, () -> this.animation.interp, () -> this.animation.duration);

    public GuiAnimation(Minecraft mc) {
        this(mc, false);
    }

    public GuiAnimation(Minecraft mc, boolean addIgnore) {
        super(mc);
        this.animates = new GuiToggleElement(mc, IKey.lang((String)"metamorph.gui.animation.animates"), false, b -> {
            this.animation.animates = this.animates.isToggled();
            this.animation.reset();
        });
        this.ignored = new GuiToggleElement(mc, IKey.lang((String)"metamorph.gui.animation.ignored"), false, b -> {
            this.animation.ignored = this.ignored.isToggled();
        });
        this.animationDuration = new GuiTrackpadElement(mc, value -> {
            this.animation.duration = value.intValue();
            this.animation.reset();
        });
        this.animationDuration.tooltip(IKey.lang((String)"metamorph.gui.animation.animation_duration"));
        this.animationDuration.limit(0.0).integer();
        this.animationDuration.values(2.0, 1.0, 5.0);
        this.pickInterpolation = new GuiButtonElement(mc, IKey.lang((String)"metamorph.gui.animation.pick_interpolation"), b -> this.interpolations.toggleVisible());
        this.pickInterpolation.tooltip((ITooltip)this.interpolationTooltip);
        this.interpolations = new GuiInterpolationList(mc, interp -> {
            this.animation.interp = (Interpolation)interp.get(0);
        });
        this.interpolations.tooltip((ITooltip)this.interpolationTooltip).markIgnored().flex().relative((GuiElement)this.pickInterpolation).y(1.0f).w(1.0f).h(96);
        this.flex().column(5).vertical().stretch().height(20).padding(10);
        this.add(new IGuiElement[]{this.animates, this.animationDuration, this.pickInterpolation});
        if (addIgnore) {
            this.addAfter((IGuiElement)this.animationDuration, (IGuiElement)this.ignored);
        }
        this.add((IGuiElement)this.interpolations);
    }

    public void fill(Animation animation) {
        this.animation = animation;
        this.animation.reset();
        this.animates.toggled(animation.animates);
        this.ignored.toggled(animation.ignored);
        this.animationDuration.setValue((double)animation.duration);
        this.interpolations.setCurrent((Object)animation.interp);
        this.interpolations.setVisible(false);
    }
}

