/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client.gui.creative;

import java.util.List;
import java.util.function.Consumer;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.Timer;
import mchorse.metamorph.ClientProxy;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.capabilities.render.EntitySelector;
import mchorse.metamorph.capabilities.render.ModelRenderer;
import mchorse.metamorph.client.EntityModelHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.JsonToNBT;

public class GuiSelectorEditor
extends GuiElement {
    public GuiListElement<EntitySelector> selectors;
    public GuiElement form;
    public GuiTextElement name;
    public GuiTextElement type;
    public GuiTextElement match;
    public GuiToggleElement active;
    public GuiButtonElement pick;
    private EntitySelector selector;
    private Timer timer = new Timer(200L);
    private boolean selecting;
    private boolean menu;

    public GuiSelectorEditor(Minecraft mc) {
        this(mc, false);
    }

    public GuiSelectorEditor(Minecraft mc, boolean menu) {
        super(mc);
        this.menu = menu;
        this.selectors = new GuiSelectorListElement(mc, this::fillData);
        this.selectors.sorting().background().setList(EntityModelHandler.selectors);
        this.selectors.context(() -> {
            GuiSimpleContextMenu contextMenu = new GuiSimpleContextMenu(mc).action(Icons.ADD, IKey.lang((String)"metamorph.gui.selectors.add"), this::addSelector);
            if (!this.selectors.getCurrent().isEmpty()) {
                contextMenu.action(Icons.REMOVE, IKey.lang((String)"metamorph.gui.selectors.remove"), this::removeSelector);
            }
            return contextMenu;
        });
        this.form = new GuiElement(mc);
        this.name = new GuiTextElement(mc, 1000, name -> {
            this.selector.name = name;
            this.updateTime();
            this.timer.mark();
        });
        this.type = new GuiTextElement(mc, 1000, name -> {
            this.selector.type = name;
            this.updateTime();
            this.timer.mark();
        });
        this.match = new GuiTextElement(mc, 10000, value -> {
            try {
                this.selector.match = JsonToNBT.func_180713_a((String)value);
                this.updateTime();
                this.timer.mark();
            }
            catch (Exception e) {
                this.selector.match = null;
                this.updateTime();
                this.timer.mark();
            }
        });
        this.match.tooltip(IKey.lang((String)"metamorph.gui.selectors.match_tooltip"));
        this.active = new GuiToggleElement(mc, IKey.lang((String)"metamorph.gui.selectors.enabled"), toggle -> {
            this.selector.enabled = toggle.isToggled();
            this.updateTime();
            this.timer.mark();
        });
        this.pick = new GuiButtonElement(mc, IKey.lang((String)"metamorph.gui.body_parts.pick"), button -> {
            this.selecting = true;
            button.setEnabled(false);
        });
        this.form.flex().relative((GuiElement)this).w(1.0f).column(5).vertical().stretch().height(20).padding(10);
        this.selectors.flex().relative(this.form).y(1.0f).w(1.0f).hTo((IResizer)this.flex(), 1.0f);
        GuiLabel title = Elements.label((IKey)IKey.lang((String)"metamorph.gui.selectors.title"));
        GuiLabel name2 = Elements.label((IKey)IKey.lang((String)"metamorph.gui.selectors.name"));
        GuiLabel type = Elements.label((IKey)IKey.lang((String)"metamorph.gui.selectors.type"));
        GuiLabel match = Elements.label((IKey)IKey.lang((String)"metamorph.gui.selectors.match"));
        name2.marginTop(8);
        type.marginTop(8);
        match.marginTop(8);
        this.form.add(new IGuiElement[]{title.tooltip(IKey.lang((String)"metamorph.gui.selectors.tooltip")), name2, this.name, type, this.type, match, this.match, this.active});
        if (!this.menu) {
            this.form.add((IGuiElement)this.pick);
        }
        this.markContainer().add(new IGuiElement[]{this.form, this.selectors});
        this.selectors.setIndex(0);
        this.fillData(this.selectors.getCurrent());
    }

    private void updateTime() {
        ModelRenderer.selectorsUpdate = System.currentTimeMillis();
    }

    public EntitySelector getSelector() {
        return this.selector;
    }

    private void addSelector() {
        EntityModelHandler.selectors.add(new EntitySelector());
        this.selectors.update();
        this.timer.mark();
        this.selectors.setIndex(this.selectors.getList().size() - 1);
        this.fillData(this.selectors.getCurrent());
    }

    private void removeSelector() {
        if (!this.selectors.current.isEmpty()) {
            EntitySelector selector = (EntitySelector)this.selectors.getCurrent().get(0);
            selector.name = "";
            selector.type = "";
            selector.morph = null;
            this.updateTime();
            int current = (Integer)this.selectors.current.get(0);
            EntityModelHandler.selectors.remove(current);
            this.selectors.setIndex(current - 1);
            this.fillData(this.selectors.getCurrent());
            this.selectors.update();
            this.timer.mark();
        }
    }

    private void fillData(List<EntitySelector> selectors) {
        EntitySelector selector;
        this.selector = null;
        this.selecting = false;
        this.form.setVisible(!selectors.isEmpty());
        this.pick.setEnabled(true);
        if (selectors.isEmpty()) {
            return;
        }
        this.selector = selector = selectors.get(0);
        this.name.setText(selector.name);
        this.type.setText(selector.type);
        this.match.setText(selector.match == null ? "" : selector.match.toString());
        this.active.toggled(selector.enabled);
    }

    public void setMorph(AbstractMorph morph) {
        if (!this.isVisible() || this.selector == null) {
            return;
        }
        if (this.selecting || this.menu) {
            this.selector.morph = morph == null ? null : morph.toNBT();
        }
        this.pick.setEnabled(true);
        this.selecting = false;
        this.updateTime();
        this.timer.mark();
    }

    public void draw(GuiContext context) {
        if (this.timer.checkReset()) {
            ClientProxy.models.saveSelectors();
        }
        this.area.draw(-1442840576);
        super.draw(context);
        if (this.selectors.getList().isEmpty()) {
            this.func_73732_a(this.font, "Right click here...", this.selectors.area.mx(), this.selectors.area.my(), 0x888888);
        }
    }

    public static class GuiSelectorListElement
    extends GuiListElement<EntitySelector> {
        public GuiSelectorListElement(Minecraft mc, Consumer<List<EntitySelector>> callback) {
            super(mc, callback);
            this.scroll.scrollItemSize = 16;
        }

        protected String elementToString(EntitySelector element) {
            return element.name + " (" + element.type + ") - " + (element.morph == null ? "null" : element.morph.func_74779_i("Name"));
        }
    }
}

