/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client.gui.creative;

import java.util.List;
import java.util.Objects;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiLabelSearchListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Label;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.creative.GuiCreativeMorphsList;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;

public class GuiQuickEditor
extends GuiElement {
    public GuiCreativeMorphsList parent;
    public GuiButtonElement presetsButton;
    public GuiButtonElement randomPreset;
    public GuiButtonElement quickAccessButton;
    public GuiLabelSearchListElement<NBTTagCompound> presets;
    public GuiScrollElement quickAccess;
    private AbstractMorph last;

    public GuiQuickEditor(Minecraft mc, GuiCreativeMorphsList parent) {
        super(mc);
        this.parent = parent;
        this.presetsButton = new GuiButtonElement(mc, IKey.lang((String)"metamorph.gui.creative.presets"), this::toggleVisibility);
        this.quickAccessButton = new GuiButtonElement(mc, IKey.lang((String)"metamorph.gui.creative.quick"), this::toggleVisibility);
        this.presets = new GuiLabelSearchListElement(mc, this::setPreset);
        this.presets.flex().relative((GuiElement)this).set(10.0f, 30.0f, 0.0f, 0.0f).w(1.0f, -20).h(1.0f, -60);
        this.randomPreset = new GuiButtonElement(mc, IKey.lang((String)"metamorph.gui.creative.random"), this::pickRandomPreset);
        this.randomPreset.flex().relative(this.presets).y(1.0f).w(1.0f);
        this.quickAccess = new GuiScrollElement(mc);
        this.quickAccess.setVisible(false);
        this.quickAccess.flex().relative((GuiElement)this).y(20).w(1.0f).h(1.0f, -20).column(5).vertical().stretch().scroll().padding(10).height(20);
        GuiElement row = Elements.row((Minecraft)mc, (int)0, (GuiElement[])new GuiElement[]{this.presetsButton, this.quickAccessButton});
        row.flex().relative((GuiElement)this).w(1.0f).h(20);
        this.presets.add((IGuiElement)this.randomPreset);
        this.add(new IGuiElement[]{row, this.presets, this.quickAccess});
    }

    private void toggleVisibility(GuiButtonElement button) {
        if (button == this.presetsButton) {
            this.presetsButton.setEnabled(false);
            this.quickAccessButton.setEnabled(true);
            this.presets.setVisible(true);
            this.quickAccess.setVisible(false);
        } else {
            this.presetsButton.setEnabled(true);
            this.quickAccessButton.setEnabled(false);
            this.presets.setVisible(false);
            this.quickAccess.setVisible(true);
        }
    }

    private void pickRandomPreset(GuiButtonElement button) {
        int i = (int)(Math.random() * (double)this.presets.list.getList().size());
        this.presets.list.setIndex(i);
        this.setPreset(this.presets.list.getCurrent());
    }

    public void setMorph(AbstractMorph morph, GuiAbstractMorph<AbstractMorph> editor) {
        if (Objects.equals(this.last, morph)) {
            return;
        }
        this.quickAccess.removeAll();
        for (GuiElement element : editor.getFields(this.mc, this.parent, morph)) {
            this.quickAccess.add((IGuiElement)element);
        }
        List<Label<NBTTagCompound>> presets = editor.getPresets(morph);
        this.presets.list.clear();
        this.presets.list.add(presets);
        this.presets.list.sort();
        this.presets.filter("", true);
        this.toggleVisibility(this.presets.isVisible() ? this.presetsButton : this.quickAccessButton);
        this.resize();
        this.last = morph;
    }

    protected void setPreset(List<Label<NBTTagCompound>> label) {
        if (!label.isEmpty()) {
            this.parent.getSelected().fromNBT((NBTTagCompound)label.get((int)0).value);
        }
    }

    public void draw(GuiContext context) {
        this.area.draw(-1442840576);
        if (this.presets.isVisible() && this.presets.list.getList().isEmpty()) {
            this.func_73732_a(this.font, "No factory presets found...", this.presets.area.mx(), this.presets.area.my() - this.font.field_78288_b / 2, 0xFFFFFF);
        }
        super.draw(context);
    }
}

