/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client.gui.creative;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.function.Consumer;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiDelegateElement;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiModelRenderer;
import mchorse.mclib.client.gui.framework.elements.IFocusedGuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiContextMenu;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDrawable;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.Keybind;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.DummyEntity;
import mchorse.mclib.utils.Timer;
import mchorse.mclib.utils.shaders.Shader;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.creative.categories.MorphCategory;
import mchorse.metamorph.api.creative.categories.UserCategory;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.creative.GuiCreativeMorphs;
import mchorse.metamorph.client.gui.creative.GuiMorphSection;
import mchorse.metamorph.client.gui.creative.GuiQuickEditor;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL20;

public class GuiCreativeMorphsList
extends GuiElement {
    public static Shader shader;
    public static int skinColor;
    public Consumer<AbstractMorph> callback;
    private List<GuiAbstractMorph> editors;
    public GuiDelegateElement<GuiAbstractMorph> editor;
    public GuiElement bar;
    public GuiTextElement search;
    public GuiButtonElement edit;
    public GuiElement screen;
    public GuiQuickEditor quickEditor;
    public GuiCreativeMorphs morphs;
    public List<OnionSkin> onionSkins = new ArrayList<OnionSkin>();
    public List<OnionSkin> lastOnionSkins;
    private Timer timer = new Timer(100L);
    private Stack<NestedEdit> nestedEdits = new Stack();
    protected Keybind exitKey;
    protected boolean keepViewport;
    protected Vector3f lastPos = new Vector3f();
    protected float lastYaw;
    protected float lastPitch;
    protected float lastScale;
    protected boolean doRenderOnionSkin;
    private DummyEntity entity;

    public GuiCreativeMorphsList(Minecraft mc, Consumer<AbstractMorph> callback) {
        super(mc);
        this.callback = callback;
        this.editor = new GuiDelegateElement(mc, null);
        this.editor.flex().relative((GuiElement)this).wh(1.0f, 1.0f);
        this.screen = new GuiElement(mc);
        this.screen.flex().relative((GuiElement)this).wh(1.0f, 1.0f);
        this.quickEditor = new GuiQuickEditor(mc, this);
        this.quickEditor.flex().relative((GuiElement)this).x(1.0f, -200).wTo((IResizer)this.flex(), 1.0f).h(1.0f);
        this.quickEditor.setVisible(false);
        this.morphs = new GuiCreativeMorphs(mc, this);
        this.morphs.flex().relative((GuiElement)this).wh(1.0f, 1.0f).column(0).vertical().stretch().scroll();
        this.bar = new GuiElement(mc);
        this.search = new GuiTextElement(mc, this.morphs::setFilter);
        this.edit = new GuiButtonElement(mc, IKey.lang((String)"metamorph.gui.edit"), b -> this.enterEditMorph());
        this.edit.setEnabled(false);
        this.edit.flex().w(60);
        this.bar.flex().relative((GuiElement)this.morphs).set(10.0f, 0.0f, 0.0f, 20.0f).y(1.0f, -30).w(1.0f, -20).row(5).preferred(0).height(20);
        this.bar.add(new IGuiElement[]{this.search, this.edit});
        this.screen.add(new IGuiElement[]{this.morphs, this.bar, this.quickEditor});
        this.add(new IGuiElement[]{this.screen, new GuiDrawable(this::drawOverlay), this.editor});
        this.doRenderOnionSkin = true;
        this.entity = new DummyEntity((World)mc.field_71441_e);
        if (shader == null) {
            try {
                String vert = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/assets/metamorph/shaders/onionskin.vert"), (Charset)StandardCharsets.UTF_8);
                String frag = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/assets/metamorph/shaders/onionskin.frag"), (Charset)StandardCharsets.UTF_8);
                shader = new Shader();
                shader.compile(vert, frag, true);
                GL20.glUniform1i((int)GL20.glGetUniformLocation((int)GuiCreativeMorphsList.shader.programId, (CharSequence)"texture"), (int)0);
                skinColor = GL20.glGetUniformLocation((int)GuiCreativeMorphsList.shader.programId, (CharSequence)"onionskin");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        IKey category = IKey.lang((String)"metamorph.gui.creative.keys.category");
        this.exitKey = this.keys().register(IKey.lang((String)"metamorph.gui.creative.keys.exit"), 1, this::exit).category(category).active(this::updateExitKey);
        this.reload();
        this.morphs.keys().register(IKey.lang((String)"metamorph.gui.creative.keys.edit"), 18, this::enterEditMorph).category(category);
        this.morphs.keys().register(IKey.lang((String)"metamorph.gui.creative.keys.quick"), 16, this::toggleQuickEdit).category(category);
        this.morphs.keys().register(IKey.lang((String)"metamorph.gui.creative.keys.focus"), 33, () -> GuiBase.getCurrent().focus((IFocusedGuiElement)this.search, true)).held(new int[]{29}).category(category);
        this.keys().register(IKey.lang((String)"metamorph.gui.creative.keys.onionskin"), 16, () -> {
            this.doRenderOnionSkin = !this.doRenderOnionSkin;
        }).active(() -> this.isEditMode() && this.haveOnionSkin()).category(category);
    }

    public void reload() {
        this.morphs.setupSections(this, this::pickMorph);
        this.search.setText("");
    }

    public void exit() {
        if (this.isEditMode()) {
            this.exitEditMorph(this.nestedEdits.isEmpty(), false);
        } else {
            this.restoreEdit();
        }
        GuiBase.getCurrent().setContextMenu(null);
    }

    protected boolean updateExitKey() {
        return this.editor.delegate != null || !this.nestedEdits.isEmpty();
    }

    public Runnable showGlobalMorphs(AbstractMorph morph) {
        if (this.morphs.user.global.isEmpty() || morph == null) {
            return null;
        }
        return () -> {
            GuiSimpleContextMenu contextMenu = new GuiSimpleContextMenu(this.mc);
            for (UserCategory category : this.morphs.user.global) {
                contextMenu.action(IKey.str((String)category.getTitle()), () -> {
                    AbstractMorph added = morph.copy();
                    category.add(added);
                    this.setSelected(added);
                });
            }
            GuiBase.getCurrent().replaceContextMenu((GuiContextMenu)contextMenu);
        };
    }

    public void markDirty() {
        this.timer.mark();
    }

    public void disableDirty() {
        if (this.timer.enabled) {
            this.timer.enabled = false;
            this.morphs.syncSelected();
        }
    }

    public void toggleQuickEdit() {
        if (this.isEditMode() || !this.quickEditor.isVisible() && this.getSelected() == null) {
            return;
        }
        this.quickEditor.toggleVisible();
        if (this.quickEditor.isVisible()) {
            AbstractMorph morph = this.getSelected();
            if (!this.isSelectedMorphIsEditable()) {
                morph = this.morphs.copyToRecent(morph);
            }
            this.quickEditor.setMorph(morph, this.getMorphEditor(morph));
            this.morphs.flex().wTo((IResizer)this.quickEditor.flex());
        } else {
            this.morphs.flex().w(1.0f);
        }
        this.resize();
    }

    public boolean isNested() {
        return !this.nestedEdits.isEmpty();
    }

    public void nestEdit(AbstractMorph selected, boolean editing, Consumer<AbstractMorph> callback) {
        this.nestEdit(selected, editing, false, callback);
    }

    public void nestEdit(AbstractMorph selected, boolean editing, boolean keepViewport, Consumer<AbstractMorph> callback) {
        NestedEdit edit = new NestedEdit(this.morphs.filter, (AbstractMorph)((GuiAbstractMorph)this.editor.delegate).morph, ((GuiAbstractMorph)this.editor.delegate).toNBT(), this.callback, this.morphs.selected, editing, this.keepViewport, this.lastOnionSkins);
        this.callback = callback;
        this.keepViewport = keepViewport;
        if (keepViewport) {
            this.saveViewport();
            this.lastOnionSkins = this.lastOnionSkins == null ? new ArrayList<OnionSkin>() : new ArrayList<OnionSkin>(this.lastOnionSkins);
            this.lastOnionSkins.addAll(this.onionSkins);
        } else {
            this.lastOnionSkins = null;
        }
        this.nestedEdits.add(edit);
        this.updateExitKey();
        if (editing) {
            this.enterEditMorph(selected);
        } else {
            this.exitEditMorph(false, true);
            this.morphs.setFilter("");
            this.setSelected(selected);
        }
    }

    public void restoreEdit() {
        if (this.nestedEdits.isEmpty()) {
            return;
        }
        NestedEdit edit = this.nestedEdits.pop();
        if (!edit.editing) {
            this.pickMorph(this.getSelected());
        }
        this.morphs.setFilter("");
        this.morphs.setSelectedDirect(edit.selected, edit.selectedMorph, edit.selectedCategory);
        this.callback = edit.callback;
        this.morphs.scrollTo();
        this.enterEditMorph(edit.editMorph);
        ((GuiAbstractMorph)this.editor.delegate).fromNBT(edit.data);
        if (this.keepViewport) {
            this.loadViewport();
        }
        this.keepViewport = edit.keepViewport;
        this.lastOnionSkins = edit.lastOnionSkins;
    }

    public boolean isEditMode() {
        return this.editor.delegate != null;
    }

    public void enterEditMorph() {
        AbstractMorph morph = this.getSelected();
        if (morph == null) {
            return;
        }
        if (!this.isSelectedMorphIsEditable() || !this.nestedEdits.isEmpty()) {
            morph = morph.copy();
            this.pickMorph(morph);
        }
        this.enterEditMorph(morph);
    }

    public void enterEditMorph(AbstractMorph morph) {
        if (morph == null) {
            return;
        }
        this.disableDirty();
        this.onionSkins.clear();
        GuiAbstractMorph editor = this.getMorphEditor(morph);
        if (editor != null) {
            this.setEditor(editor);
            if (this.keepViewport) {
                this.loadViewport();
            }
            editor.renderer.beforeRender = this::beforeRenderModel;
            editor.renderer.afterRender = this::afterRenderModel;
        }
    }

    public void exitEditMorph(boolean add, boolean ignore) {
        if (!this.isEditMode()) {
            return;
        }
        ((GuiAbstractMorph)this.editor.delegate).renderer.beforeRender = null;
        ((GuiAbstractMorph)this.editor.delegate).renderer.afterRender = null;
        if (this.keepViewport) {
            this.saveViewport();
        }
        ((GuiAbstractMorph)this.editor.delegate).finishEdit();
        Object edited = ((GuiAbstractMorph)this.editor.delegate).morph;
        if (!this.nestedEdits.isEmpty() && !ignore) {
            this.pickMorph((AbstractMorph)edited);
            this.restoreEdit();
            return;
        }
        this.morphs.syncSelected();
        if (add && edited != null && !this.isSelectedMorphIsEditable()) {
            this.setSelected((AbstractMorph)edited);
        }
        this.setEditor(null);
    }

    protected void setEditor(GuiAbstractMorph editor) {
        this.editor.setDelegate((GuiElement)editor);
        this.screen.setVisible(editor == null);
        this.updateExitKey();
    }

    public void finish() {
        int i = 0;
        while (this.isNested() || this.isEditMode()) {
            this.exit();
            ++i;
        }
        if (i > 0) {
            this.pickMorph(MorphUtils.copy(this.getSelected()));
        }
        this.keepViewport = false;
        this.lastOnionSkins = null;
    }

    private GuiAbstractMorph getMorphEditor(AbstractMorph morph) {
        if (this.editors == null) {
            this.editors = new ArrayList<GuiAbstractMorph>();
            MorphManager.INSTANCE.registerMorphEditors(this.mc, this.editors);
        }
        for (GuiAbstractMorph editor : this.editors) {
            if (!editor.canEdit(morph)) continue;
            editor.setMorphs(this);
            editor.startEdit(morph);
            return editor;
        }
        return null;
    }

    private void saveViewport() {
        GuiModelRenderer renderer = ((GuiAbstractMorph)this.editor.delegate).renderer;
        this.lastPos.set((Tuple3f)renderer.pos);
        this.lastPitch = renderer.pitch;
        this.lastYaw = renderer.yaw;
        this.lastScale = renderer.scale;
    }

    private void loadViewport() {
        GuiModelRenderer renderer = ((GuiAbstractMorph)this.editor.delegate).renderer;
        renderer.setPosition(this.lastPos.x, this.lastPos.y, this.lastPos.z);
        renderer.setRotation(this.lastYaw, this.lastPitch);
        renderer.setScale(this.lastScale);
    }

    protected void beforeRenderModel(GuiContext context) {
    }

    protected void afterRenderModel(GuiContext context) {
        this.renderOnionSkin(context);
    }

    public boolean haveOnionSkin() {
        return !this.onionSkins.isEmpty() || this.lastOnionSkins != null && !this.lastOnionSkins.isEmpty();
    }

    private void renderOnionSkin(GuiContext context) {
        if (!this.doRenderOnionSkin) {
            return;
        }
        this.entity.field_70173_aa = ((GuiAbstractMorph)this.editor.delegate).renderer.getEntity().field_70173_aa;
        shader.bind();
        GuiModelRenderer.disableRenderingFlag();
        if (this.lastOnionSkins != null) {
            for (OnionSkin skin : this.lastOnionSkins) {
                this.renderSingleOnionSkin(skin, context.partialTicks);
            }
        }
        for (OnionSkin skin : this.onionSkins) {
            this.renderSingleOnionSkin(skin, context.partialTicks);
        }
        shader.unbind();
    }

    private void renderSingleOnionSkin(OnionSkin skin, float partialTicks) {
        if (skin.morph == null) {
            return;
        }
        GL20.glUniform4f((int)skinColor, (float)skin.color.r, (float)skin.color.g, (float)skin.color.b, (float)skin.color.a);
        this.entity.field_70127_C = this.entity.field_70125_A = skin.pitch;
        this.entity.field_70760_ar = this.entity.field_70761_aq = skin.yawBody;
        this.entity.field_70758_at = this.entity.field_70759_as = skin.yawHead;
        GlStateManager.func_179094_E();
        MorphUtils.render(skin.morph, (EntityLivingBase)this.entity, skin.offset.x, skin.offset.y, skin.offset.z, 0.0f, partialTicks);
        GlStateManager.func_179121_F();
    }

    public AbstractMorph getSelected() {
        Object morph;
        if (this.isEditMode() && (morph = ((GuiAbstractMorph)this.editor.delegate).morph) != null) {
            return morph;
        }
        return this.morphs.getSelected();
    }

    public void pickMorph(GuiMorphSection selected) {
        this.disableDirty();
        this.morphs.setSelectedDirect(selected);
        this.pickMorph(selected.morph);
        this.syncQuickEditor();
    }

    public void pickMorph(AbstractMorph morph) {
        this.edit.setEnabled(morph != null);
        if (this.callback != null) {
            this.callback.accept(morph);
        }
    }

    public AbstractMorph setSelected(AbstractMorph morph) {
        this.disableDirty();
        this.morphs.setSelected(morph);
        this.syncQuickEditor();
        morph = this.getSelected();
        this.edit.setEnabled(morph != null);
        return morph;
    }

    protected void syncQuickEditor() {
        if (this.quickEditor.isVisible()) {
            AbstractMorph morph = this.getSelected();
            if (morph != null && this.isSelectedMorphIsEditable()) {
                this.quickEditor.setMorph(morph, this.getMorphEditor(morph));
            } else {
                this.toggleQuickEdit();
            }
        }
    }

    protected boolean isSelectedMorphIsEditable() {
        return this.morphs.isSelectedMorphIsEditable();
    }

    public void draw(GuiContext context) {
        if (this.timer.checkReset()) {
            this.morphs.syncSelected();
        }
        super.draw(context);
    }

    private void drawOverlay(GuiContext context) {
        if (!this.isEditMode()) {
            boolean error;
            AbstractMorph morph = this.getSelected();
            String selected = morph != null ? morph.getDisplayName() : I18n.func_135052_a((String)"metamorph.gui.no_morph", (Object[])new Object[0]);
            boolean bl = error = morph != null && morph.errorRendering;
            if (error) {
                selected = I18n.func_135052_a((String)"metamorph.gui.morph_render_error", (Object[])new Object[0]);
            }
            Area area = this.search.area;
            int w = Math.max(this.font.func_78256_a(selected), morph != null ? this.font.func_78256_a(morph.name) : 0);
            if (morph != null && !morph.errorRendering) {
                Gui.func_73734_a((int)area.x, (int)(area.y - 27), (int)(area.x + w + 8), (int)area.y, (int)-587202560);
                this.font.func_175063_a(selected, (float)(area.x + 4), (float)(area.y - 23), -1);
                this.font.func_175063_a(morph.name, (float)(area.x + 4), (float)(area.y - 12), 0x888888);
            } else {
                Gui.func_73734_a((int)area.x, (int)(area.y - 16), (int)(area.x + w + 8), (int)area.y, (int)-587202560);
                this.font.func_175063_a(selected, (float)(area.x + 4), (float)(area.y - 12), error ? 16717875 : 0xFFFFFF);
            }
        }
        if (!this.isEditMode() && !this.search.field.func_146206_l() && this.search.field.func_146179_b().isEmpty()) {
            this.font.func_175063_a(I18n.func_135052_a((String)"metamorph.gui.search", (Object[])new Object[0]), (float)(this.search.area.x + 5), (float)(this.search.area.y + 6), 0x888888);
        }
    }

    static {
        skinColor = -1;
    }

    public static class OnionSkin {
        public Color color = new Color();
        public AbstractMorph morph;
        public Vector3d offset = new Vector3d(0.0, 0.0, 0.0);
        public float pitch = 0.0f;
        public float yawHead = 0.0f;
        public float yawBody = 0.0f;

        public OnionSkin color(float r, float g, float b, float a) {
            this.color.set(r, g, b, a);
            return this;
        }

        public OnionSkin morph(AbstractMorph morph) {
            this.morph = morph;
            return this;
        }

        public OnionSkin offset(double x, double y, double z, float pitch, float yawHead, float yawBody) {
            this.offset.set(x, y, z);
            this.pitch = pitch;
            this.yawHead = yawHead;
            this.yawBody = yawBody;
            return this;
        }
    }

    public static class NestedEdit {
        public String filter;
        public NBTTagCompound data;
        public Consumer<AbstractMorph> callback;
        public GuiMorphSection selected;
        public MorphCategory selectedCategory;
        public AbstractMorph selectedMorph;
        public AbstractMorph editMorph;
        public boolean editing;
        public boolean keepViewport;
        public List<OnionSkin> lastOnionSkins;

        public NestedEdit(String filter, AbstractMorph editMorph, NBTTagCompound data, Consumer<AbstractMorph> callback, GuiMorphSection selected, boolean editing, boolean keepViewport, List<OnionSkin> lastOnionSkins) {
            this.filter = filter;
            this.data = data;
            this.editMorph = editMorph;
            this.callback = callback;
            this.editing = editing;
            this.keepViewport = keepViewport;
            this.lastOnionSkins = lastOnionSkins;
            this.selected = selected;
            this.selectedCategory = selected == null ? null : selected.category;
            this.selectedMorph = selected == null ? null : selected.morph;
        }
    }
}

