/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client;

import java.nio.charset.Charset;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphSettings;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.capabilities.morphing.Morphing;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class NetworkHandler {
    @SubscribeEvent
    public void onCustomMessage(FMLNetworkEvent.ClientCustomPacketEvent event) {
        try {
            PacketBuffer buffer = (PacketBuffer)event.getPacket().payload();
            byte[] array = new byte[buffer.capacity()];
            int c = array.length;
            for (int i = 0; i < c; ++i) {
                array[i] = buffer.readByte();
            }
            String data = new String(array, Charset.forName("UTF-8")).trim();
            String[] args = data.split(" ");
            if (args.length >= 1) {
                Minecraft.func_71410_x().func_152344_a((Runnable)new MorphRunnable(args));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class MorphRunnable
    implements Runnable {
        public String[] args;

        public MorphRunnable(String[] args) {
            this.args = args;
        }

        @Override
        public void run() {
            EntityPlayer player = Minecraft.func_71410_x().field_71441_e.func_72924_a(this.args[0]);
            if (player == null) {
                return;
            }
            if (this.args.length >= 3) {
                String data = this.args[2];
                for (int i = 3; i < this.args.length; ++i) {
                    data = data + " " + this.args[i];
                }
                try {
                    NBTTagCompound tag = JsonToNBT.func_180713_a((String)data);
                    tag.func_74778_a("Name", this.args[1]);
                    this.morph(tag, player);
                }
                catch (Exception exception) {}
            } else if (this.args.length == 2) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("Name", this.args[1]);
                this.morph(tag, player);
            } else if (this.args.length == 1) {
                Morphing.get(player).setCurrentMorph(null, player, true);
            }
        }

        private void morph(NBTTagCompound tag, EntityPlayer player) {
            AbstractMorph morph = MorphManager.INSTANCE.morphFromNBT(tag);
            if (morph != null) {
                morph.forceSettings(MorphSettings.DEFAULT);
                Morphing.get(player).setCurrentMorph(morph, player, true);
            }
        }
    }
}

