/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.capabilities.render;

import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.capabilities.render.EntitySelector;
import mchorse.metamorph.capabilities.render.IModelRenderer;
import mchorse.metamorph.capabilities.render.ModelProvider;
import mchorse.metamorph.client.EntityModelHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModelRenderer
implements IModelRenderer {
    public static long selectorsUpdate = System.currentTimeMillis();
    public EntitySelector selector;
    public AbstractMorph morph;
    public long lastUpdate = -1L;
    private int timer;
    private float lastW = -1.0f;
    private float lastH = -1.0f;

    public static IModelRenderer get(Entity entity) {
        return (IModelRenderer)entity.getCapability(ModelProvider.MODEL, null);
    }

    @Override
    public void update(EntityLivingBase target) {
        if (this.lastUpdate < selectorsUpdate || this.IsNotMatchedAnymore(target)) {
            this.lastUpdate = selectorsUpdate;
            this.updateSelector(target);
        }
        if (this.selector != null && this.morph != null) {
            this.morph.update(target);
        }
    }

    private boolean IsNotMatchedAnymore(EntityLivingBase target) {
        ++this.timer;
        if (this.timer > 10) {
            this.timer = 0;
            if (this.selector == null) {
                return true;
            }
            return !this.selector.matches(target);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateSelector(EntityLivingBase target) {
        this.selector = null;
        this.morph = null;
        for (EntitySelector selector : EntityModelHandler.selectors) {
            if (!selector.matches(target)) continue;
            this.selector = selector;
            this.morph = MorphManager.INSTANCE.morphFromNBT(this.selector.morph);
            if (this.lastW < 0.0f) {
                this.lastW = target.field_70130_N;
                this.lastH = target.field_70131_O;
            }
            return;
        }
        if (this.selector == null && this.lastW > 0.0f && this.lastH > 0.0f) {
            target.field_70130_N = this.lastW;
            target.field_70131_O = this.lastH;
            this.lastW = -1.0f;
            this.lastH = -1.0f;
        }
    }

    @Override
    public boolean canRender() {
        return this.selector != null;
    }

    @Override
    public boolean render(EntityLivingBase entity, double x, double y, double z, float partialTicks) {
        return this.selector != null && MorphUtils.render(this.morph, entity, x, y, z, 0.0f, partialTicks);
    }
}

