/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.bodypart;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiSlotElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiContextMenu;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.input.GuiTransformations;
import mchorse.mclib.client.gui.framework.elements.list.GuiStringListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.Direction;
import mchorse.mclib.utils.MathUtils;
import mchorse.mclib.utils.MatrixUtils;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.utils.IAnimationProvider;
import mchorse.metamorph.bodypart.BodyPart;
import mchorse.metamorph.bodypart.BodyPartManager;
import mchorse.metamorph.bodypart.GuiBodyPartListElement;
import mchorse.metamorph.bodypart.IBodyPartProvider;
import mchorse.metamorph.client.gui.creative.GuiCreativeMorphsList;
import mchorse.metamorph.client.gui.creative.GuiNestedEdit;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiMorphPanel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiBodyPartEditor
extends GuiMorphPanel<AbstractMorph, GuiAbstractMorph> {
    public static List<BodyPart> buffer = new ArrayList<BodyPart>();
    protected GuiBodyPartListElement bodyParts;
    protected GuiNestedEdit pickMorph;
    protected GuiToggleElement useTarget;
    protected GuiToggleElement enabled;
    protected GuiToggleElement animate;
    protected GuiIconElement add;
    protected GuiIconElement dupe;
    protected GuiIconElement remove;
    protected GuiIconElement copy;
    protected GuiIconElement paste;
    protected GuiBodyPartTransformations transformations;
    protected GuiStringListElement limbs;
    protected GuiElement elements;
    protected GuiElement bottomEditor;
    protected BodyPartManager parts;
    protected BodyPart part;
    protected GuiElement stacks;
    protected GuiSlotElement[] slots = new GuiSlotElement[6];

    public GuiBodyPartEditor(Minecraft mc, GuiAbstractMorph editor) {
        super(mc, editor);
        this.limbs = new GuiStringListElement(mc, str -> this.pickLimb((String)str.get(0)));
        this.limbs.background();
        this.bodyParts = new GuiBodyPartListElement(mc, part -> this.setPart(part.isEmpty() ? null : (BodyPart)part.get(0)));
        this.bodyParts.background().sorting();
        this.bodyParts.context(this::bodyPartContextMenu);
        this.pickMorph = new GuiNestedEdit(mc, editing -> {
            BodyPart part = this.part;
            GuiCreativeMorphsList morphs = this.editor.morphs;
            GuiCreativeMorphsList.OnionSkin skin = this.generateOnionSkin(part);
            morphs.nestEdit(part.morph.get(), (boolean)editing, morph -> {
                if (part != null) {
                    AbstractMorph copy = MorphUtils.copy(morph);
                    part.morph.setDirect(copy);
                    this.applyUseTarget(part, copy);
                }
            });
            if (skin != null) {
                morphs.lastOnionSkins = ImmutableList.of((Object)skin);
            }
        });
        this.add = new GuiIconElement(mc, Icons.ADD, this::addPart);
        this.add.tooltip(IKey.lang((String)"metamorph.gui.body_parts.add_tooltip"));
        this.add.flex().w(20);
        this.dupe = new GuiIconElement(mc, Icons.DUPE, this::dupePart);
        this.dupe.tooltip(IKey.lang((String)"metamorph.gui.body_parts.dupe_tooltip"));
        this.remove = new GuiIconElement(mc, Icons.REMOVE, this::removePart);
        this.remove.tooltip(IKey.lang((String)"metamorph.gui.body_parts.remove_tooltip"));
        this.copy = new GuiIconElement(mc, Icons.COPY, this::copyParts);
        this.copy.tooltip(IKey.lang((String)"metamorph.gui.body_parts.copy_tooltip"));
        this.paste = new GuiIconElement(mc, Icons.PASTE, this::pasteParts);
        this.paste.tooltip(IKey.lang((String)"metamorph.gui.body_parts.paste_tooltip"));
        this.paste.flex().w(20);
        this.useTarget = new GuiToggleElement(mc, IKey.lang((String)"metamorph.gui.body_parts.use_target"), false, this::toggleTarget);
        this.enabled = new GuiToggleElement(mc, IKey.lang((String)"metamorph.gui.body_parts.enabled"), false, this::toggleEnabled);
        this.animate = new GuiToggleElement(mc, IKey.lang((String)"metamorph.gui.body_parts.animate"), false, this::toggleAnimate);
        this.animate.tooltip(IKey.lang((String)"metamorph.gui.body_parts.animate_tooltip"), Direction.LEFT);
        this.transformations = new GuiBodyPartTransformations(mc);
        int width = 110;
        GuiElement sidebar = new GuiElement(mc);
        sidebar.flex().relative((GuiElement)this).x(10).y(1.0f, -30).wh(width, 20).row(0).height(20);
        sidebar.add(new IGuiElement[]{this.add, this.dupe, this.remove, this.copy, this.paste});
        this.bottomEditor = new GuiElement(mc);
        this.bottomEditor.flex().relative((GuiElement)this).x(1.0f, -115).y(1.0f, -10).w(width).anchorY(1.0f);
        this.bottomEditor.flex().column(5).vertical().stretch();
        this.bottomEditor.add(new IGuiElement[]{this.enabled, this.animate, this.useTarget});
        this.transformations.flex().relative((IResizer)this.area).x(0.5f, -128).y(1.0f, -10).wh(256, 70).anchorY(1.0f);
        this.limbs.flex().relative((GuiElement)this).set(0.0f, 50.0f, (float)width, 90.0f).x(1.0f, -115).hTo((IResizer)this.bottomEditor.area, -5);
        this.pickMorph.flex().relative((GuiElement)this).set(0.0f, 10.0f, (float)width, 20.0f).x(1.0f, -115);
        this.bodyParts.flex().relative((GuiElement)this).set(10.0f, 22.0f, (float)width, 0.0f).hTo((IResizer)this.transformations.flex(), 1.0f, -20);
        this.elements = new GuiElement(mc).noCulling();
        this.elements.add(new IGuiElement[]{this.bottomEditor, this.limbs, this.pickMorph, this.transformations});
        this.add(new IGuiElement[]{sidebar, this.bodyParts, this.elements});
        this.stacks = new GuiElement(mc);
        this.stacks.flex().relative((GuiElement)this).x(0.5f).y(10).anchor(0.5f, 0.0f).row(5).resize();
        for (int i = 0; i < this.slots.length; ++i) {
            int slot = i;
            this.slots[i] = new GuiSlotElement(mc, i, stack -> this.pickItem((ItemStack)stack, slot));
            this.stacks.add((IGuiElement)this.slots[i]);
        }
        this.elements.add((IGuiElement)this.stacks);
        this.bodyParts.keys().register(IKey.lang((String)"metamorph.gui.body_parts.keys.select_prev"), 200, () -> this.moveIndex(-1)).category(GuiAbstractMorph.KEY_CATEGORY);
        this.bodyParts.keys().register(IKey.lang((String)"metamorph.gui.body_parts.keys.select_next"), 208, () -> this.moveIndex(1)).category(GuiAbstractMorph.KEY_CATEGORY);
    }

    public boolean isSelected(BodyPart part) {
        return part == this.part;
    }

    private void applyUseTarget(BodyPart part, AbstractMorph copy) {
        if (copy == null) {
            return;
        }
        if (copy.useTargetDefault()) {
            part.useTarget = true;
            this.useTarget.toggled(part.useTarget);
        }
    }

    private GuiContextMenu bodyPartContextMenu() {
        GuiSimpleContextMenu menu = new GuiSimpleContextMenu(this.mc);
        String text = GuiScreen.func_146277_j();
        BodyPart part = null;
        try {
            NBTTagCompound tag = JsonToNBT.func_180713_a((String)text);
            part = new BodyPart();
            part.fromNBT(tag);
        }
        catch (Exception tag) {
            // empty catch block
        }
        if (!this.bodyParts.isDeselected()) {
            menu.action(Icons.COPY, IKey.lang((String)"metamorph.gui.body_parts.context.copy"), () -> {
                NBTTagCompound tag = new NBTTagCompound();
                ((BodyPart)this.bodyParts.getCurrentFirst()).toNBT(tag);
                GuiScreen.func_146275_d((String)tag.toString());
            });
        }
        if (part != null) {
            BodyPart destination = part;
            menu.action(Icons.PASTE, IKey.lang((String)"metamorph.gui.body_parts.context.paste"), () -> this.addPart(destination.copy()));
        }
        return menu.actions.getList().isEmpty() ? null : menu;
    }

    private GuiCreativeMorphsList.OnionSkin generateOnionSkin(BodyPart part) {
        EntityLivingBase entity = this.editor.renderer.getEntity();
        entity.field_70125_A = 0.0f;
        entity.field_70127_C = 0.0f;
        entity.field_70759_as = 0.0f;
        entity.field_70758_at = 0.0f;
        entity.field_70761_aq = 0.0f;
        entity.field_70760_ar = 0.0f;
        part.lastMatrix = null;
        BodyPart.recordMatrix(this.morph, entity, 0.0f);
        Matrix4f last = part.lastMatrix;
        if (last != null) {
            Vector3f rotate;
            Matrix4f transform = new Matrix4f();
            transform.setIdentity();
            transform.setTranslation(part.translate);
            last.mul(transform);
            transform.rotZ((float)Math.toRadians(part.rotate.z));
            last.mul(transform);
            transform.rotY((float)Math.toRadians(part.rotate.y));
            last.mul(transform);
            transform.rotX((float)Math.toRadians(part.rotate.x));
            last.mul(transform);
            transform.setIdentity();
            transform.m00 = part.scale.x;
            transform.m11 = part.scale.y;
            transform.m22 = part.scale.z;
            last.mul(transform);
            transform.setIdentity();
            MatrixUtils.Transformation extract = MatrixUtils.extractTransformations((Matrix4f)last, (Matrix4f)transform);
            if (extract.getCreationException() == null && (rotate = extract.getRotation(MatrixUtils.RotationOrder.XYZ)) != null) {
                TransformedOnionSkinMorph morph = new TransformedOnionSkinMorph();
                Vector3f vec = extract.getTranslation3f();
                morph.translate[0] = vec.x;
                morph.translate[1] = vec.y;
                morph.translate[2] = vec.z;
                vec = rotate;
                morph.rotate[0] = vec.x;
                morph.rotate[1] = vec.y;
                morph.rotate[2] = vec.z;
                vec = extract.getScale();
                morph.scale[0] = vec.x;
                morph.scale[1] = vec.y;
                morph.scale[2] = vec.z;
                boolean enabled = part.enabled;
                part.enabled = false;
                AbstractMorph copy = this.morph.copy();
                if (copy instanceof IAnimationProvider) {
                    ((IAnimationProvider)((Object)copy)).getAnimation().animates = false;
                }
                morph.morph = copy;
                part.enabled = enabled;
                return new GuiCreativeMorphsList.OnionSkin().morph(morph).color(0.5f, 0.5f, 0.5f, 0.5f);
            }
        }
        return null;
    }

    protected void addPart(GuiIconElement b) {
        BodyPart part = new BodyPart();
        this.setupNewBodyPart(part);
        this.addPart(part);
    }

    protected void addPart(BodyPart part) {
        part.init();
        this.parts.parts.add(part);
        this.setPart(part);
        this.bodyParts.setCurrentDirect(part);
        this.bodyParts.update();
    }

    protected void setupNewBodyPart(BodyPart part) {
    }

    protected void dupePart(GuiIconElement b) {
        if (this.bodyParts.isDeselected()) {
            return;
        }
        BodyPart part = ((BodyPart)this.bodyParts.getCurrentFirst()).copy();
        part.init();
        this.parts.parts.add(part);
        this.setPart(part);
        this.bodyParts.setCurrentDirect(part);
        this.bodyParts.update();
    }

    protected void removePart(GuiIconElement b) {
        if (this.bodyParts.isDeselected()) {
            return;
        }
        List<BodyPart> parts = this.parts.parts;
        int index = -1;
        for (int i = 0; i < parts.size(); ++i) {
            if (parts.get(i) != this.part) continue;
            index = i;
            break;
        }
        if (index != -1) {
            parts.remove(this.part);
            this.bodyParts.update();
            --index;
            if (parts.size() >= 1) {
                this.setPart(parts.get(MathUtils.clamp((int)index, (int)0, (int)(parts.size() - 1))));
            } else {
                this.setPart(null);
            }
        }
        this.bodyParts.update();
    }

    protected void copyParts(GuiIconElement b) {
        buffer.clear();
        for (BodyPart part : this.parts.parts) {
            buffer.add(part.copy());
        }
    }

    protected void pasteParts(GuiIconElement b) {
        for (BodyPart part : buffer) {
            BodyPart clone = part.copy();
            this.parts.parts.add(clone);
            clone.init();
        }
        if (!this.parts.parts.isEmpty()) {
            this.setPart(this.parts.parts.get(this.parts.parts.size() - 1));
        }
        this.bodyParts.update();
    }

    protected void toggleTarget(GuiToggleElement b) {
        if (this.part != null) {
            this.part.useTarget = b.isToggled();
        }
    }

    protected void toggleEnabled(GuiToggleElement b) {
        if (this.part != null) {
            this.part.enabled = b.isToggled();
        }
    }

    protected void toggleAnimate(GuiToggleElement b) {
        if (this.part != null) {
            this.part.animate = b.isToggled();
        }
    }

    protected void pickItem(ItemStack stack, int slot) {
        if (this.part == null) {
            return;
        }
        this.part.slots[slot] = stack;
        this.part.updateEntity();
    }

    @Override
    public void fillData(AbstractMorph morph) {
        super.fillData(morph);
        if (morph instanceof IBodyPartProvider) {
            BodyPartManager manager;
            this.parts = manager = ((IBodyPartProvider)((Object)morph)).getBodyPart();
            this.bodyParts.setList(manager.parts);
            this.bodyParts.update();
        }
    }

    @Override
    public void startEditing() {
        super.startEditing();
        if (this.parts != null) {
            this.setPart(this.parts.parts.isEmpty() ? null : this.parts.parts.get(0));
        }
    }

    public void setLimbs(Collection<String> limbs) {
        this.limbs.clear();
        this.limbs.add(limbs);
        this.limbs.sort();
    }

    protected void setPart(BodyPart part) {
        this.part = part;
        this.elements.setVisible(part != null);
        if (this.part != null) {
            this.fillBodyPart(part);
            this.limbs.setCurrent((Object)part.limb);
            this.bodyParts.setCurrentDirect(part);
            this.pickMorph.setMorph(part.morph.get());
        }
    }

    protected void pickLimb(String str) {
        Vector3f rotate;
        BodyPart part = this.part;
        boolean convert = GuiScreen.func_175283_s();
        if (part.limb.equals(str)) {
            return;
        }
        if (part.limb.isEmpty() || !convert) {
            part.limb = str;
            return;
        }
        part.lastMatrix = null;
        BodyPart.recordMatrix(this.morph, this.editor.renderer.getEntity(), GuiBase.getCurrent().partialTicks);
        Matrix4f last = part.lastMatrix;
        if (last == null) {
            part.limb = str;
            return;
        }
        Matrix4f transform = new Matrix4f();
        transform.setIdentity();
        transform.setTranslation(part.translate);
        last.mul(transform);
        transform.rotZ((float)Math.toRadians(part.rotate.z));
        last.mul(transform);
        transform.rotY((float)Math.toRadians(part.rotate.y));
        last.mul(transform);
        transform.rotX((float)Math.toRadians(part.rotate.x));
        last.mul(transform);
        transform.setIdentity();
        transform.m00 = part.scale.x;
        transform.m11 = part.scale.y;
        transform.m22 = part.scale.z;
        last.mul(transform);
        part.limb = str;
        part.lastMatrix = null;
        BodyPart.recordMatrix(this.morph, this.editor.renderer.getEntity(), GuiBase.getCurrent().partialTicks);
        Matrix4f current = part.lastMatrix;
        if (current == null) {
            return;
        }
        MatrixUtils.Transformation extract = MatrixUtils.extractTransformations((Matrix4f)current, (Matrix4f)last);
        if (extract.getCreationException() == null && (rotate = extract.getRotation(MatrixUtils.RotationOrder.XYZ)) != null) {
            part.translate.set((Tuple3f)extract.getTranslation3f());
            part.rotate.set((Tuple3f)rotate);
            part.scale.set((Tuple3f)extract.getScale());
        }
        this.fillBodyPart(part);
    }

    public void fillBodyPart(BodyPart part) {
        if (part != null) {
            this.bottomEditor.removeAll();
            if (this.morph instanceof IAnimationProvider) {
                this.bottomEditor.add(new IGuiElement[]{this.enabled, this.animate, this.useTarget});
            } else {
                this.bottomEditor.add(new IGuiElement[]{this.enabled, this.useTarget});
            }
            this.elements.resize();
            this.transformations.setBodyPart(part);
            this.enabled.toggled(part.enabled);
            this.useTarget.toggled(part.useTarget);
            this.animate.toggled(part.animate);
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i].setStack(part.slots[i]);
            }
        }
    }

    private void moveIndex(int index) {
        if (index != 0) {
            index = MathUtils.cycler((int)(this.bodyParts.getIndex() + index), (int)0, (int)(this.bodyParts.getList().size() - 1));
            this.bodyParts.setIndex(index);
            this.fillBodyPart((BodyPart)this.bodyParts.getCurrentFirst());
        }
    }

    public void draw(GuiContext context) {
        this.font.func_175063_a(I18n.func_135052_a((String)"metamorph.gui.body_parts.parts", (Object[])new Object[0]), (float)this.bodyParts.area.x, (float)(this.bodyParts.area.y - 12), 0xFFFFFF);
        if (this.elements.isVisible()) {
            this.font.func_175063_a(I18n.func_135052_a((String)"metamorph.gui.body_parts.limbs", (Object[])new Object[0]), (float)this.limbs.area.x, (float)(this.limbs.area.y - 12), 0xFFFFFF);
        }
        super.draw(context);
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        super.fromNBT(tag);
        this.bodyParts.setIndex(tag.func_74762_e("Index"));
        BodyPart part = (BodyPart)this.bodyParts.getCurrentFirst();
        if (part != null) {
            this.setPart(part);
        }
    }

    @Override
    public NBTTagCompound toNBT() {
        NBTTagCompound tag = super.toNBT();
        tag.func_74768_a("Index", this.bodyParts.getIndex());
        return tag;
    }

    public static class TransformedOnionSkinMorph
    extends AbstractMorph {
        public float[] translate = new float[3];
        public float[] rotate = new float[3];
        public float[] scale = new float[3];
        public AbstractMorph morph = null;

        @Override
        public void renderOnScreen(EntityPlayer player, int x, int y, float scale, float alpha) {
        }

        @Override
        public void render(EntityLivingBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
            if (this.morph == null) {
                return;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.translate[0], (float)this.translate[1], (float)this.translate[2]);
            GlStateManager.func_179114_b((float)this.rotate[2], (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)this.rotate[1], (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.rotate[0], (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)this.scale[0], (float)this.scale[1], (float)this.scale[2]);
            MorphUtils.renderDirect(this.morph, entity, x, y, z, entityYaw, partialTicks);
            GlStateManager.func_179121_F();
        }

        @Override
        public AbstractMorph create() {
            return null;
        }

        @Override
        public float getWidth(EntityLivingBase target) {
            return 0.0f;
        }

        @Override
        public float getHeight(EntityLivingBase target) {
            return 0.0f;
        }
    }

    public static class GuiBodyPartTransformations
    extends GuiTransformations {
        public BodyPart part;

        public GuiBodyPartTransformations(Minecraft mc) {
            super(mc);
        }

        public void localTranslate(double x, double y, double z) {
            this.part.addTranslation(x, y, z, GuiTransformations.GuiStaticTransformOrientation.getOrientation());
            this.fillT(this.part.translate.x, this.part.translate.y, this.part.translate.z);
        }

        public void setBodyPart(BodyPart part) {
            this.part = part;
            if (part != null) {
                this.fillT(part.translate.x, part.translate.y, part.translate.z);
                this.fillS(part.scale.x, part.scale.y, part.scale.z);
                this.fillR(part.rotate.x, part.rotate.y, part.rotate.z);
            }
        }

        public void setT(double x, double y, double z) {
            this.part.translate.x = (float)x;
            this.part.translate.y = (float)y;
            this.part.translate.z = (float)z;
        }

        public void setS(double x, double y, double z) {
            this.part.scale.x = (float)x;
            this.part.scale.y = (float)y;
            this.part.scale.z = (float)z;
        }

        public void setR(double x, double y, double z) {
            this.part.rotate.x = (float)x;
            this.part.rotate.y = (float)y;
            this.part.rotate.z = (float)z;
        }
    }
}

