/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api.morphs;

import java.util.Objects;
import javax.vecmath.Vector3f;
import mchorse.metamorph.Metamorph;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphSettings;
import mchorse.metamorph.api.abilities.IAbility;
import mchorse.metamorph.api.morphs.utils.Hitbox;
import mchorse.metamorph.entity.SoundHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.classloading.FMLForgePlugin;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractMorph {
    public Vector3f cachedTranslation = new Vector3f();
    public Vector3f angularVelocity = new Vector3f();
    public int age = 0;
    public String name = "";
    public String displayName = "";
    public boolean favorite = false;
    public int keybind = -1;
    @Deprecated
    public MorphSettings settings = MorphSettings.DEFAULT.copy();
    protected boolean forcedSettings = false;
    protected boolean needSettingsUpdate = false;
    protected MorphSettings activeSettings = null;
    public Hitbox hitbox = new Hitbox();
    public boolean errorRendering;

    public void initializeSettings() {
        if (!this.needSettingsUpdate) {
            if (this.settings == null) {
                if (!FMLForgePlugin.RUNTIME_DEOBF) {
                    Metamorph.LOGGER.error("needSettingsUpdate was not set to true when changing morph settings, or the settings was set to null directly when it shouldn't be");
                }
                this.settings = MorphSettings.DEFAULT_MORPHED.copy();
            }
            return;
        }
        this.settings = MorphSettings.DEFAULT_MORPHED.copy();
        if (this.activeSettings != null) {
            this.settings.applyOverrides(this.activeSettings);
        }
        this.finishInitializingSettings();
    }

    protected void finishInitializingSettings() {
        this.needSettingsUpdate = false;
        this.forcedSettings = false;
    }

    public void setActiveSettings(MorphSettings activeSettings) {
        this.activeSettings = activeSettings;
        this.needSettingsUpdate = true;
    }

    public void forceSettings(MorphSettings settingsToForce) {
        if (settingsToForce == null) {
            if (FMLForgePlugin.RUNTIME_DEOBF) {
                settingsToForce = MorphSettings.DEFAULT_MORPHED.copy();
            } else {
                throw new NullPointerException("Forced settings should never be null (are you trying to call clearForcedSettings()?)");
            }
        }
        this.settings = settingsToForce;
        this.forcedSettings = true;
    }

    public void forceEditSettings(MorphSettings.Edit edit) {
        MorphSettings settingsCopy = this.getSettings().copy();
        edit.apply(settingsCopy);
        this.forceSettings(settingsCopy);
    }

    public void clearForcedSettings() {
        this.settings = null;
        this.forcedSettings = false;
        this.needSettingsUpdate = true;
    }

    public MorphSettings getSettings() {
        if (!this.forcedSettings) {
            this.initializeSettings();
        }
        return this.settings;
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayName() {
        if (this.displayName != null && !this.displayName.isEmpty()) {
            return this.displayName;
        }
        return this.getSubclassDisplayName();
    }

    @SideOnly(value=Side.CLIENT)
    protected String getSubclassDisplayName() {
        return this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasCustomName() {
        return this.displayName != null && !this.displayName.isEmpty();
    }

    @Deprecated
    public boolean hasCustomSettings() {
        if (this.settings != MorphSettings.DEFAULT) {
            return true;
        }
        if (this.settings != MorphManager.INSTANCE.activeSettings.get(this.name)) {
            return true;
        }
        return this.forcedSettings;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void renderOnScreen(EntityPlayer var1, int var2, int var3, float var4, float var5);

    @SideOnly(value=Side.CLIENT)
    public abstract void render(EntityLivingBase var1, double var2, double var4, double var6, float var8, float var9);

    @SideOnly(value=Side.CLIENT)
    public boolean renderHand(EntityPlayer player, EnumHand hand) {
        return !this.getSettings().hands;
    }

    public void update(EntityLivingBase target) {
        this.updateHitbox(target);
        MorphSettings settings = this.getSettings();
        if (settings.speed != 0.1f) {
            target.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)settings.speed);
        }
        for (IAbility ability : settings.abilities) {
            ability.update(target);
        }
        ++this.age;
    }

    public void morph(EntityLivingBase target) {
        for (IAbility ability : this.getSettings().abilities) {
            ability.onMorph(target);
        }
    }

    public void demorph(EntityLivingBase target) {
        for (IAbility ability : this.getSettings().abilities) {
            ability.onDemorph(target);
        }
    }

    protected void updateHitbox(EntityLivingBase target) {
        if (this.hitbox.enabled) {
            float height = target.func_70093_af() ? this.hitbox.sneakingHeight : this.hitbox.height;
            this.updateSize(target, this.hitbox.width, height, this.hitbox.eye);
        } else {
            this.updateUserHitbox(target);
        }
    }

    protected void updateUserHitbox(EntityLivingBase target) {
    }

    public void updateSize(EntityLivingBase target, float width, float height) {
        AbstractMorph.updateSizeDefault(target, width, height);
    }

    public void updateSize(EntityLivingBase target, float width, float height, float eyeFactor) {
        AbstractMorph.updateSizeDefault(target, width, height, eyeFactor);
    }

    public static void updateSizeDefault(EntityLivingBase target, float width, float height) {
        AbstractMorph.updateSizeDefault(target, width, height, 0.9f);
    }

    public static void updateSizeDefault(EntityLivingBase target, float width, float height, float eyeFactor) {
        float minEyeToHeadDifference = 0.1f;
        height = Math.max(height, minEyeToHeadDifference * 2.0f);
        if (target instanceof EntityPlayer && !((Boolean)Metamorph.disablePov.get()).booleanValue()) {
            float eyeHeight = height * eyeFactor;
            if (eyeHeight + minEyeToHeadDifference > height) {
                eyeHeight = height - minEyeToHeadDifference;
            }
            ((EntityPlayer)target).eyeHeight = eyeHeight;
        }
        if (width != target.field_70130_N || height != target.field_70131_O) {
            AxisAlignedBB aabb = target.func_174813_aQ();
            target.field_70130_N = width;
            target.field_70131_O = height;
            target.func_174826_a(new AxisAlignedBB(target.field_70165_t - (double)(width / 2.0f), aabb.field_72338_b, target.field_70161_v - (double)(width / 2.0f), target.field_70165_t + (double)(width / 2.0f), aabb.field_72338_b + (double)height, target.field_70161_v + (double)(width / 2.0f)));
        }
    }

    public void action(EntityLivingBase target) {
        if (this.getSettings().action != null) {
            this.getSettings().action.execute(target, this);
        }
    }

    public void attack(Entity target, EntityLivingBase source) {
        if (this.getSettings().attack != null) {
            this.getSettings().attack.attack(target, source);
        }
    }

    public abstract AbstractMorph create();

    public final AbstractMorph copy() {
        AbstractMorph morph = this.create();
        assert (this.getClass().isInstance(morph));
        morph.copy(this);
        return morph;
    }

    public void copy(AbstractMorph from) {
        this.name = from.name;
        this.displayName = from.displayName;
        this.favorite = from.favorite;
        this.settings = from.settings != null ? from.settings.copy() : null;
        this.activeSettings = from.activeSettings != null ? from.activeSettings.copy() : null;
        this.forcedSettings = from.forcedSettings;
        this.needSettingsUpdate = from.needSettingsUpdate;
        this.keybind = from.keybind;
        this.hitbox.copy(from.hitbox);
    }

    public abstract float getWidth(EntityLivingBase var1);

    public abstract float getHeight(EntityLivingBase var1);

    public float getEyeHeight(EntityLivingBase target) {
        if (!((Boolean)Metamorph.disablePov.get()).booleanValue()) {
            return this.getHeight(target) * 0.9f;
        }
        return 1.62f;
    }

    public final SoundEvent getHurtSound(EntityLivingBase target) {
        return this.getHurtSound(target, SoundHandler.GENERIC_DAMAGE);
    }

    public SoundEvent getHurtSound(EntityLivingBase target, DamageSource damageSource) {
        return null;
    }

    public SoundEvent getDeathSound(EntityLivingBase target) {
        return null;
    }

    public boolean hasCustomStepSound(EntityLivingBase target) {
        return false;
    }

    public void playStepSound(EntityLivingBase target) {
    }

    public void onChangeDimension(EntityPlayer player, int oldDim, int currentDim) {
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractMorph) {
            AbstractMorph morph = (AbstractMorph)obj;
            return Objects.equals(this.name, morph.name) && Objects.equals(this.displayName, morph.displayName) && Objects.equals(this.hitbox, morph.hitbox) && Objects.equals(this.forcedSettings ? this.settings : null, morph.forcedSettings ? morph.settings : null);
        }
        return super.equals(obj);
    }

    public boolean canMerge(AbstractMorph morph) {
        return false;
    }

    public void afterMerge(AbstractMorph morph) {
    }

    public boolean useTargetDefault() {
        return false;
    }

    protected void mergeBasic(AbstractMorph morph) {
        this.displayName = morph.displayName;
        this.settings = morph.settings;
        this.forcedSettings = morph.forcedSettings;
        this.hitbox.copy(morph.hitbox);
    }

    public void reset() {
        this.setActiveSettings(null);
        this.clearForcedSettings();
        this.hitbox.reset();
    }

    public final NBTTagCompound toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        this.toNBT(tag);
        return tag;
    }

    public void toNBT(NBTTagCompound tag) {
        tag.func_74778_a("Name", this.name);
        if (this.forcedSettings) {
            NBTTagCompound settings = new NBTTagCompound();
            this.getSettings().toNBT(settings);
            if (!settings.func_82582_d()) {
                tag.func_74782_a("Settings", (NBTBase)settings);
            }
        }
        tag.func_74757_a("ForcedSettings", this.forcedSettings);
        if (this.displayName != null && !this.displayName.isEmpty()) {
            tag.func_74778_a("DisplayName", this.displayName);
        }
        if (this.favorite) {
            tag.func_74757_a("Favorite", this.favorite);
        }
        if (this.keybind >= 0) {
            tag.func_74768_a("Keybind", this.keybind);
        }
        if (!this.hitbox.isDefault()) {
            tag.func_74782_a("Hitbox", (NBTBase)this.hitbox.toNBT());
        }
    }

    public void fromNBT(NBTTagCompound tag) {
        this.reset();
        this.name = tag.func_74779_i("Name");
        boolean hasForcedSettings = false;
        if (tag.func_74764_b("ForcedSettings")) {
            hasForcedSettings = tag.func_74767_n("ForcedSettings");
        }
        if (tag.func_74764_b("Settings")) {
            this.settings = new MorphSettings();
            this.settings.fromNBT(tag.func_74775_l("Settings"));
            if (hasForcedSettings) {
                this.forcedSettings = true;
            }
        }
        if (tag.func_74764_b("DisplayName")) {
            this.displayName = tag.func_74779_i("DisplayName");
        }
        if (tag.func_74764_b("Favorite")) {
            this.favorite = tag.func_74767_n("Favorite");
        }
        if (tag.func_74764_b("Keybind")) {
            this.keybind = tag.func_74762_e("Keybind");
        }
        if (tag.func_74764_b("Hitbox")) {
            this.hitbox.fromNBT(tag.func_74775_l("Hitbox"));
        }
    }
}

