/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphSettings;
import mchorse.metamorph.api.abilities.IAbility;

public class MorphSettingsAdapter
implements JsonDeserializer<MorphSettings> {
    public MorphSettings deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        MorphSettings morph = new MorphSettings();
        MorphManager manager = MorphManager.INSTANCE;
        boolean bl = morph.hasHealth = object.has("health") && object.get("health").isJsonPrimitive();
        if (morph.hasHealth) {
            morph.health = object.get("health").getAsInt();
        }
        boolean bl2 = morph.hasSpeed = object.has("speed") && object.get("speed").isJsonPrimitive();
        if (morph.hasSpeed) {
            morph.speed = object.get("speed").getAsFloat();
        }
        boolean bl3 = morph.hasHostile = object.has("hostile") && object.get("hostile").isJsonPrimitive();
        if (morph.hasHostile) {
            morph.hostile = object.get("hostile").getAsBoolean();
        }
        boolean bl4 = morph.hasHands = object.has("hands") && object.get("hands").isJsonPrimitive();
        if (morph.hasHands) {
            morph.hands = object.get("hands").getAsBoolean();
        }
        boolean bl5 = morph.hasAbilities = object.has("abilities") && object.get("abilities").isJsonArray();
        if (morph.hasAbilities) {
            morph.abilities.clear();
            for (JsonElement ability : object.get("abilities").getAsJsonArray()) {
                IAbility iability;
                if (!ability.isJsonPrimitive() || (iability = manager.abilities.get(ability.getAsString())) == null) continue;
                morph.abilities.add(iability);
            }
        }
        boolean bl6 = morph.hasAction = object.has("action") && object.get("action").isJsonPrimitive();
        if (morph.hasAction) {
            morph.action = manager.actions.get(object.get("action").getAsString());
        }
        boolean bl7 = morph.hasAttack = object.has("attack") && object.get("attack").isJsonPrimitive();
        if (morph.hasAttack) {
            morph.attack = manager.attacks.get(object.get("attack").getAsString());
        }
        boolean bl8 = morph.hasUpdates = object.has("updates") && object.get("updates").isJsonPrimitive();
        if (morph.hasUpdates) {
            morph.updates = object.get("updates").getAsBoolean();
        }
        boolean bl9 = morph.hasShadowOption = object.has("shadow_option") && object.get("shadow_option").isJsonPrimitive();
        if (morph.hasShadowOption) {
            morph.shadowOption = object.get("shadow_option").getAsInt();
        }
        boolean bl10 = morph.hasbetterLightsShadow = object.has("betterlights_shadow") && object.get("betterlights_shadow").isJsonPrimitive();
        if (morph.hasbetterLightsShadow) {
            morph.betterLightsShadow = object.get("betterlights_shadow").getAsBoolean();
        }
        return morph;
    }
}

