/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.abilities.IAbility;
import mchorse.metamorph.api.abilities.IAction;
import mchorse.metamorph.api.abilities.IAttackAbility;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class MorphSettings {
    public static final MorphSettings DEFAULT = new MorphSettings();
    public static final MorphSettings DEFAULT_MORPHED;
    public List<IAbility> abilities = new ArrayList<IAbility>();
    public boolean hasAbilities = true;
    public IAttackAbility attack = null;
    public boolean hasAttack = true;
    public IAction action = null;
    public boolean hasAction = true;
    public int health = 20;
    public boolean hasHealth = true;
    public float speed = 0.1f;
    public boolean hasSpeed = true;
    public boolean hostile = true;
    public boolean hasHostile = true;
    public boolean hands = false;
    public boolean hasHands = true;
    public boolean updates = true;
    public boolean hasUpdates = true;
    public int shadowOption = 0;
    public boolean hasShadowOption = true;
    public boolean betterLightsShadow = true;
    public boolean hasbetterLightsShadow = true;

    public boolean equals(Object obj) {
        if (obj instanceof MorphSettings) {
            MorphSettings settings = (MorphSettings)obj;
            return !(this.hasAbilities != settings.hasAbilities || !this.abilities.equals(settings.abilities) && this.hasAbilities || this.hasAction != settings.hasAction || !Objects.equals(this.action, settings.action) && this.hasAction || this.hasAttack != settings.hasAttack || !Objects.equals(this.attack, settings.attack) && this.hasAttack || this.hasHealth != settings.hasHealth || this.health != settings.health && this.hasHealth || this.hasSpeed != settings.hasSpeed || this.speed != settings.speed && this.hasSpeed || this.hasHostile != settings.hasHostile || this.hostile != settings.hostile && this.hasHostile || this.hasUpdates != settings.hasUpdates || this.updates != settings.updates && this.hasUpdates || this.hasShadowOption != settings.hasShadowOption || this.shadowOption != settings.shadowOption && this.hasShadowOption || this.hasbetterLightsShadow != settings.hasbetterLightsShadow || this.betterLightsShadow != settings.betterLightsShadow && this.hasbetterLightsShadow);
        }
        return super.equals(obj);
    }

    public MorphSettings copy() {
        MorphSettings settings = new MorphSettings();
        settings.copy(this);
        return settings;
    }

    public void copy(MorphSettings setting) {
        this.abilities.clear();
        this.abilities.addAll(setting.abilities);
        this.hasAbilities = setting.hasAbilities;
        this.action = setting.action;
        this.hasAction = setting.hasAction;
        this.attack = setting.attack;
        this.hasAttack = setting.hasAttack;
        this.health = setting.health;
        this.hasHealth = setting.hasHealth;
        this.speed = setting.speed;
        this.hasSpeed = setting.hasSpeed;
        this.hostile = setting.hostile;
        this.hasHostile = setting.hasHostile;
        this.hands = setting.hands;
        this.hasHands = setting.hasHands;
        this.updates = setting.updates;
        this.hasUpdates = setting.hasUpdates;
        this.shadowOption = setting.shadowOption;
        this.hasShadowOption = setting.hasShadowOption;
        this.betterLightsShadow = setting.betterLightsShadow;
        this.hasbetterLightsShadow = setting.hasbetterLightsShadow;
    }

    public void applyOverrides(MorphSettings setting) {
        if (setting.hasAbilities) {
            this.abilities.clear();
            this.abilities.addAll(setting.abilities);
            this.hasAbilities = true;
        }
        if (setting.hasAction) {
            this.action = setting.action;
            this.hasAction = true;
        }
        if (setting.hasAttack) {
            this.attack = setting.attack;
            this.hasAttack = true;
        }
        if (setting.hasHealth) {
            this.health = setting.health;
            this.hasHealth = true;
        }
        if (setting.hasSpeed) {
            this.speed = setting.speed;
            this.hasSpeed = true;
        }
        if (setting.hasHostile) {
            this.hostile = setting.hostile;
            this.hasHostile = true;
        }
        if (setting.hasHands) {
            this.hands = setting.hands;
            this.hasHands = true;
        }
        if (setting.hasUpdates) {
            this.updates = setting.updates;
            this.hasUpdates = true;
        }
        if (setting.hasShadowOption) {
            this.shadowOption = setting.shadowOption;
            this.hasShadowOption = true;
        }
        if (setting.hasbetterLightsShadow) {
            this.betterLightsShadow = setting.betterLightsShadow;
            this.hasbetterLightsShadow = true;
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.hasAbilities);
        if (this.hasAbilities) {
            buf.writeInt(this.abilities.size());
            for (IAbility ability : this.abilities) {
                String string = MorphSettings.getKey(MorphManager.INSTANCE.abilities, ability);
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(string == null ? "" : string));
            }
        }
        buf.writeBoolean(this.hasAction);
        if (this.hasAction) {
            String action = MorphSettings.getKey(MorphManager.INSTANCE.actions, this.action);
            buf.writeBoolean(action != null);
            if (action != null) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)action);
            }
        }
        buf.writeBoolean(this.hasAttack);
        if (this.hasAttack) {
            String attack = MorphSettings.getKey(MorphManager.INSTANCE.attacks, this.attack);
            buf.writeBoolean(attack != null);
            if (attack != null) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)attack);
            }
        }
        buf.writeBoolean(this.hasHealth);
        if (this.hasHealth) {
            buf.writeInt(this.health);
        }
        buf.writeBoolean(this.hasSpeed);
        if (this.hasSpeed) {
            buf.writeFloat(this.speed);
        }
        buf.writeBoolean(this.hasHostile);
        if (this.hasHostile) {
            buf.writeBoolean(this.hostile);
        }
        buf.writeBoolean(this.hasHands);
        if (this.hasHands) {
            buf.writeBoolean(this.hands);
        }
        buf.writeBoolean(this.hasUpdates);
        if (this.hasUpdates) {
            buf.writeBoolean(this.updates);
        }
        buf.writeBoolean(this.hasShadowOption);
        if (this.hasShadowOption) {
            buf.writeInt(this.shadowOption);
        }
        buf.writeBoolean(this.hasbetterLightsShadow);
        if (this.hasbetterLightsShadow) {
            buf.writeBoolean(this.betterLightsShadow);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.hasAbilities = buf.readBoolean();
        if (this.hasAbilities) {
            ArrayList<IAbility> abilities = new ArrayList<IAbility>();
            int c = buf.readInt();
            for (int i = 0; i < c; ++i) {
                IAbility ability = MorphManager.INSTANCE.abilities.get(ByteBufUtils.readUTF8String((ByteBuf)buf));
                if (ability == null) continue;
                abilities.add(ability);
            }
            this.abilities = abilities;
        }
        this.hasAction = buf.readBoolean();
        if (this.hasAction) {
            if (buf.readBoolean()) {
                String action = ByteBufUtils.readUTF8String((ByteBuf)buf);
                this.action = MorphManager.INSTANCE.actions.get(action);
            } else {
                this.action = null;
            }
        }
        this.hasAttack = buf.readBoolean();
        if (this.hasAttack) {
            if (buf.readBoolean()) {
                String attack = ByteBufUtils.readUTF8String((ByteBuf)buf);
                this.attack = MorphManager.INSTANCE.attacks.get(attack);
            } else {
                this.attack = null;
            }
        }
        this.hasHealth = buf.readBoolean();
        if (this.hasHealth) {
            this.health = buf.readInt();
        }
        this.hasSpeed = buf.readBoolean();
        if (this.hasSpeed) {
            this.speed = buf.readFloat();
        }
        this.hasHostile = buf.readBoolean();
        if (this.hasHostile) {
            this.hostile = buf.readBoolean();
        }
        this.hasHands = buf.readBoolean();
        if (this.hasHands) {
            this.hands = buf.readBoolean();
        }
        this.hasUpdates = buf.readBoolean();
        if (this.hasUpdates) {
            this.updates = buf.readBoolean();
        }
        this.hasShadowOption = buf.readBoolean();
        if (this.hasShadowOption) {
            this.shadowOption = buf.readInt();
        }
        this.hasbetterLightsShadow = buf.readBoolean();
        if (this.hasbetterLightsShadow) {
            this.betterLightsShadow = buf.readBoolean();
        }
    }

    public void toNBT(NBTTagCompound tag) {
        if (this.hasAbilities) {
            NBTTagList list = new NBTTagList();
            for (IAbility ability : this.abilities) {
                list.func_74742_a((NBTBase)new NBTTagString(MorphSettings.getKey(MorphManager.INSTANCE.abilities, ability)));
            }
            tag.func_74782_a("Abilities", (NBTBase)list);
        }
        if (this.hasAttack) {
            String attackKey = MorphSettings.getKey(MorphManager.INSTANCE.attacks, this.attack);
            if (attackKey == null) {
                attackKey = "null";
            }
            tag.func_74778_a("Attack", attackKey);
        }
        if (this.hasAction) {
            String actionKey = MorphSettings.getKey(MorphManager.INSTANCE.actions, this.action);
            if (actionKey == null) {
                actionKey = "null";
            }
            tag.func_74778_a("Action", actionKey);
        }
        if (this.hasHealth) {
            tag.func_74768_a("HP", this.health);
        }
        if (this.hasSpeed) {
            tag.func_74776_a("Speed", this.speed);
        }
        if (this.hasHostile) {
            tag.func_74757_a("Hostile", this.hostile);
        }
        if (this.hasHands) {
            tag.func_74757_a("Hands", this.hands);
        }
        if (this.hasUpdates) {
            tag.func_74757_a("Updates", this.updates);
        }
        if (this.hasShadowOption) {
            tag.func_74768_a("ShadowOption", this.shadowOption);
        }
        if (this.hasbetterLightsShadow) {
            tag.func_74757_a("BetterLightsShadow", this.betterLightsShadow);
        }
    }

    public void fromNBT(NBTTagCompound tag) {
        this.hasAbilities = tag.func_74764_b("Abilities");
        if (this.hasAbilities) {
            NBTTagList list = tag.func_150295_c("Abilities", 8);
            this.abilities.clear();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                IAbility ability = MorphManager.INSTANCE.abilities.get(list.func_150307_f(i));
                if (ability == null) continue;
                this.abilities.add(ability);
            }
        }
        this.hasAttack = tag.func_74764_b("Attack");
        if (this.hasAttack) {
            this.attack = MorphManager.INSTANCE.attacks.get(tag.func_74779_i("Attack"));
        }
        this.hasAction = tag.func_74764_b("Action");
        if (this.hasAction) {
            this.action = MorphManager.INSTANCE.actions.get(tag.func_74779_i("Action"));
        }
        this.hasHealth = tag.func_74764_b("HP");
        if (this.hasHealth) {
            this.health = tag.func_74762_e("HP");
        }
        this.hasSpeed = tag.func_74764_b("Speed");
        if (this.hasSpeed) {
            this.speed = tag.func_74760_g("Speed");
        }
        this.hasHostile = tag.func_74764_b("Hostile");
        if (this.hasHostile) {
            this.hostile = tag.func_74767_n("Hostile");
        }
        this.hasHands = tag.func_74764_b("Hands");
        if (this.hasHands) {
            this.hands = tag.func_74767_n("Hands");
        }
        this.hasUpdates = tag.func_74764_b("Updates");
        if (this.hasUpdates) {
            this.updates = tag.func_74767_n("Updates");
        }
        this.hasShadowOption = tag.func_74764_b("ShadowOption");
        if (this.hasShadowOption) {
            this.shadowOption = tag.func_74762_e("ShadowOption");
        }
        this.hasbetterLightsShadow = tag.func_74764_b("BetterLightsShadowOption");
        if (this.hasbetterLightsShadow) {
            this.betterLightsShadow = tag.func_74767_n("BetterLightsShadow");
        }
    }

    public static <T> String getKey(Map<String, T> map, T value) {
        if (value == null) {
            return null;
        }
        for (Map.Entry<String, T> entry : map.entrySet()) {
            if (entry.getValue() != value) continue;
            return entry.getKey();
        }
        return null;
    }

    static {
        MorphSettings.DEFAULT.hostile = false;
        MorphSettings.DEFAULT.hands = true;
        MorphSettings.DEFAULT.updates = false;
        DEFAULT_MORPHED = new MorphSettings();
    }

    public static interface Edit {
        public void apply(MorphSettings var1);
    }
}

