/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph;

import mchorse.mclib.McLib;
import mchorse.mclib.config.ConfigBuilder;
import mchorse.mclib.config.values.ValueBoolean;
import mchorse.mclib.config.values.ValueInt;
import mchorse.mclib.events.RegisterConfigEvent;
import mchorse.metamorph.CommonProxy;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.commands.CommandAcquireMorph;
import mchorse.metamorph.commands.CommandMetamorph;
import mchorse.metamorph.commands.CommandMorph;
import net.minecraft.command.ICommand;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="metamorph", name="Metamorph", version="1.4", updateJSON="https://raw.githubusercontent.com/mchorse/metamorph/1.12/version.json", dependencies="after:moreplayermodels;required-after:mclib@[2.4.2,)", acceptedMinecraftVersions="[1.12.2]")
public class Metamorph {
    public static final String MOD_ID = "metamorph";
    public static final String MODNAME = "Metamorph";
    public static final String VERSION = "1.4";
    public static final String CLIENT_PROXY = "mchorse.metamorph.ClientProxy";
    public static final String SERVER_PROXY = "mchorse.metamorph.CommonProxy";
    @SidedProxy(clientSide="mchorse.metamorph.ClientProxy", serverSide="mchorse.metamorph.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="metamorph")
    public static Metamorph instance;
    public static FMLEventChannel channel;
    public static ValueBoolean opEntitySelector;
    public static ValueBoolean preventGhosts;
    public static ValueBoolean preventKillAcquire;
    public static ValueBoolean acquireImmediately;
    public static ValueBoolean keepMorphs;
    public static ValueBoolean disablePov;
    public static ValueBoolean disableHealth;
    public static ValueBoolean disableMorphAnimation;
    public static ValueBoolean disableMorphDisguise;
    public static ValueBoolean disableFirstPersonHand;
    public static ValueBoolean morphInTightSpaces;
    public static ValueBoolean showMorphIdleSounds;
    public static ValueBoolean pauseGUIInSP;
    public static ValueBoolean renderBodyPartAxis;
    public static ValueInt maxRecentMorphs;
    public static ValueBoolean allowMorphingIntoCategoryMorphs;
    public static ValueBoolean loadEntityMorphs;
    public static boolean DEBUG;
    public static Logger LOGGER;

    @SubscribeEvent
    public void onConfigRegister(RegisterConfigEvent event) {
        opEntitySelector = event.opAccess.category(MOD_ID).getBoolean("entity_selectors", true);
        opEntitySelector.syncable();
        ConfigBuilder builder = event.createBuilder(MOD_ID);
        preventGhosts = builder.category("acquiring").getBoolean("prevent_ghosts", true);
        preventKillAcquire = builder.getBoolean("prevent_kill_acquire", false);
        acquireImmediately = builder.getBoolean("acquire_immediately", false);
        keepMorphs = builder.category("morphs").getBoolean("keep_morphs", true);
        disablePov = builder.getBoolean("disable_pov", false);
        disableHealth = builder.getBoolean("disable_health", false);
        disableMorphAnimation = builder.getBoolean("disable_morph_animation", false);
        disableMorphDisguise = builder.getBoolean("disable_morph_disguise", false);
        disableFirstPersonHand = builder.getBoolean("disable_first_person_hand", false);
        disableFirstPersonHand.clientSide();
        morphInTightSpaces = builder.getBoolean("morph_in_tight_spaces", false);
        showMorphIdleSounds = builder.getBoolean("show_morph_idle_sounds", true);
        pauseGUIInSP = builder.getBoolean("pause_gui_in_sp", true);
        pauseGUIInSP.clientSide();
        renderBodyPartAxis = builder.getBoolean("render_bodypart_axis", true);
        renderBodyPartAxis.clientSide();
        maxRecentMorphs = builder.getInt("max_recent_morphs", 20, 1, 200);
        maxRecentMorphs.clientSide();
        allowMorphingIntoCategoryMorphs = builder.getBoolean("allow_morphing_into_category_morphs", false);
        loadEntityMorphs = builder.getBoolean("load_entity_morphs", true);
        loadEntityMorphs.clientSide();
    }

    @Mod.EventHandler
    public void preLoad(FMLPreInitializationEvent event) {
        LOGGER = event.getModLog();
        channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(MODNAME);
        McLib.EVENT_BUS.register((Object)this);
        proxy.preLoad(event);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.load();
    }

    @Mod.EventHandler
    public void postLoad(FMLPostInitializationEvent event) {
        proxy.postLoad(event);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        MorphManager.INSTANCE.setActiveBlacklist(null, MorphUtils.reloadBlacklist());
        MorphManager.INSTANCE.setActiveSettings(MorphUtils.reloadMorphSettings());
        MorphManager.INSTANCE.setActiveMap(MorphUtils.reloadRemapper());
        event.registerServerCommand((ICommand)new CommandMorph());
        event.registerServerCommand((ICommand)new CommandAcquireMorph());
        event.registerServerCommand((ICommand)new CommandMetamorph());
    }

    public static void log(String message) {
        if (DEBUG) {
            LOGGER.log(Level.INFO, message);
        }
    }

    static {
        DEBUG = false;
    }
}

