/*
 * Decompiled with CFR 0.152.
 */
package com.mcwlights.kikoz.objects;

import com.mcwlights.kikoz.McwLights;
import com.mcwlights.kikoz.init.BlockInit;
import com.mcwlights.kikoz.init.ItemInit;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TorchObject
extends BlockDirectional {
    protected static final AxisAlignedBB AABB_UP_OFF = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.5625, 0.625);
    protected static final AxisAlignedBB AABB_DOWN_OFF = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.5625, 0.625);
    protected static final AxisAlignedBB AABB_NORTH_OFF = new AxisAlignedBB(0.375, 0.0, 0.625, 0.625, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_SOUTH_OFF = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 0.375);
    protected static final AxisAlignedBB AABB_WEST_OFF = new AxisAlignedBB(0.625, 0.0, 0.375, 1.0, 1.0, 0.625);
    protected static final AxisAlignedBB AABB_EAST_OFF = new AxisAlignedBB(0.0, 0.0, 0.375, 0.375, 1.0, 0.625);

    public TorchObject(String name, Material material) {
        super(material);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(McwLights.MACAWFENCESTAB);
        this.func_149711_c(0.1f);
        this.setHarvestLevel("axe", 1);
        this.func_149752_b(0.1f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149715_a(1.0f);
        BlockInit.BLOCKS.add((Block)this);
        ItemInit.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.NORTH));
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return TorchObject.canPlaceBlock(worldIn, pos, side);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!TorchObject.canPlaceBlock(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    protected static boolean canPlaceBlock(World worldIn, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        boolean flag = iblockstate.func_193401_d((IBlockAccess)worldIn, blockpos, direction) == BlockFaceShape.SOLID;
        Block block = iblockstate.func_177230_c();
        if (direction == EnumFacing.UP) {
            return iblockstate.func_185896_q() || !TorchObject.func_193384_b((Block)block) && flag;
        }
        return !TorchObject.func_193382_c((Block)block) && flag;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return TorchObject.canPlaceBlock(worldIn, pos, facing) ? this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)facing) : this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.UP);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)field_176387_N);
        switch (enumfacing) {
            case EAST: {
                return AABB_EAST_OFF;
            }
            case WEST: {
                return AABB_WEST_OFF;
            }
            case SOUTH: {
                return AABB_SOUTH_OFF;
            }
            default: {
                return AABB_NORTH_OFF;
            }
            case UP: {
                return AABB_UP_OFF;
            }
            case DOWN: 
        }
        return AABB_DOWN_OFF;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing;
        switch (meta & 7) {
            case 1: {
                enumfacing = EnumFacing.EAST;
                break;
            }
            case 2: {
                enumfacing = EnumFacing.WEST;
                break;
            }
            case 3: {
                enumfacing = EnumFacing.SOUTH;
                break;
            }
            case 4: {
                enumfacing = EnumFacing.NORTH;
                break;
            }
            default: {
                enumfacing = EnumFacing.UP;
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        int i;
        switch ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)) {
            case EAST: {
                i = 1;
                break;
            }
            case WEST: {
                i = 2;
                break;
            }
            case SOUTH: {
                i = 3;
                break;
            }
            case NORTH: {
                i = 4;
                break;
            }
            default: {
                i = 5;
            }
        }
        return i;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_176387_N, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176387_N});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        EnumFacing direction = (EnumFacing)stateIn.func_177229_b((IProperty)field_176387_N);
        EnumFacing direction1 = direction.func_176734_d();
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.7;
        double d2 = (double)pos.func_177952_p() + 0.5;
        switch (1.$SwitchMap$net$minecraft$util$EnumFacing[((EnumFacing)stateIn.func_177229_b((IProperty)field_176387_N)).ordinal()]) {
            case 1: {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.27 * (double)direction1.func_82601_c(), d1 + 0.22, d2 + 0.27 * (double)direction1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.27 * (double)direction1.func_82601_c(), d1 + 0.22, d2 + 0.27 * (double)direction1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case 2: {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.27 * (double)direction1.func_82601_c(), d1 + 0.22, d2 + 0.27 * (double)direction1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.27 * (double)direction1.func_82601_c(), d1 + 0.22, d2 + 0.27 * (double)direction1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case 3: {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.27 * (double)direction1.func_82601_c(), d1 + 0.22, d2 + 0.27 * (double)direction1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.27 * (double)direction1.func_82601_c(), d1 + 0.22, d2 + 0.27 * (double)direction1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case 4: {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.27 * (double)direction1.func_82601_c(), d1 + 0.22, d2 + 0.27 * (double)direction1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.27 * (double)direction1.func_82601_c(), d1 + 0.22, d2 + 0.27 * (double)direction1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case 5: {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case 6: 
        }
    }
}

