/*
 * Decompiled with CFR 0.152.
 */
package com.mcwlights.kikoz.objects;

import com.mcwlights.kikoz.McwLights;
import com.mcwlights.kikoz.init.BlockInit;
import com.mcwlights.kikoz.init.ItemInit;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TikiTorch
extends Block {
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");
    public static final PropertyEnum<LightPart> PART = PropertyEnum.func_177709_a((String)"part", LightPart.class);
    private static final AxisAlignedBB BASE = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);

    public TikiTorch(String name, Material material) {
        super(material, material.func_151565_r());
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(McwLights.MACAWFENCESTAB);
        this.func_149711_c(0.5f);
        this.setHarvestLevel("axe", 1);
        this.func_149752_b(1.0f);
        this.func_149672_a(SoundType.field_185848_a);
        BlockInit.BLOCKS.add(this);
        ItemInit.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(PART, (Comparable)((Object)LightPart.TOP)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BASE;
    }

    protected IBlockState lightState(IBlockState state, World world, BlockPos pos) {
        boolean below;
        boolean above = world.func_180495_p(pos.func_177984_a()).func_177230_c() == this;
        boolean bl = below = world.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        if (above && below) {
            return state.func_177226_a(PART, (Comparable)((Object)LightPart.MIDDLE)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false));
        }
        if (!above && below) {
            return state.func_177226_a(PART, (Comparable)((Object)LightPart.TOP)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true));
        }
        if (above && !below) {
            return state.func_177226_a(PART, (Comparable)((Object)LightPart.BOTTOM)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false));
        }
        return state.func_177226_a(PART, (Comparable)((Object)LightPart.BASE)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!world.func_180495_p(pos).equals(state)) {
            world.func_180501_a(pos, this.lightState(state, world, pos), 2);
        }
    }

    @Nullable
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.lightState(super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand), world, pos);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.lightState(state, (World)world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos neighborPos) {
        IBlockState updatedState;
        IBlockState currentState;
        super.func_189540_a(state, world, pos, block, neighborPos);
        if (!world.field_72995_K && !(currentState = world.func_180495_p(pos)).equals(updatedState = this.lightState(currentState, world, pos))) {
            world.func_180501_a(pos, updatedState, 2);
        }
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{LIT}).add(new IProperty[]{PART}).build();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PART, (Comparable)((Object)LightPart.values()[meta & 3])).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf((meta & 4) != 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        meta |= ((LightPart)((Object)state.func_177229_b(PART))).ordinal();
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            meta |= 4;
        }
        return meta;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        Boolean isLit = (Boolean)state.func_177229_b((IProperty)LIT);
        LightPart part = (LightPart)((Object)state.func_177229_b(PART));
        if (isLit.booleanValue() && part == LightPart.BASE) {
            return 15;
        }
        if (isLit.booleanValue() && part == LightPart.TOP) {
            return 15;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return BASE;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        LightPart part = (LightPart)((Object)state.func_177229_b(PART));
        Boolean lit = (Boolean)state.func_177229_b((IProperty)LIT);
        ItemStack itemstack = player.func_184614_ca();
        Item item = itemstack.func_77973_b();
        if (item instanceof ItemBlock) {
            return false;
        }
        if (part != LightPart.BOTTOM && part != LightPart.MIDDLE && (part == LightPart.TOP || part == LightPart.BASE)) {
            state = state.func_177231_a((IProperty)LIT);
            worldIn.func_180501_a(pos, state, 10);
            if (!lit.booleanValue()) {
                worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else {
                worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 1.1;
        double d2 = (double)pos.func_177952_p() + 0.5;
        Boolean i = (Boolean)stateIn.func_177229_b((IProperty)LIT);
        LightPart part = (LightPart)((Object)stateIn.func_177229_b(PART));
        if (i.booleanValue() && part == LightPart.BASE) {
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
        if (i.booleanValue() && part == LightPart.TOP) {
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
        if (!i.booleanValue()) {
            return;
        }
    }

    public static enum LightPart implements IStringSerializable
    {
        BASE("base"),
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private final String name;

        private LightPart(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

