/*
 * Decompiled with CFR 0.152.
 */
package com.mcwlights.kikoz.objects;

import com.mcwlights.kikoz.McwLights;
import com.mcwlights.kikoz.init.BlockInit;
import com.mcwlights.kikoz.init.ItemInit;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CeilingLight
extends Block {
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");
    public static final PropertyEnum<LightPart> PART = PropertyEnum.func_177709_a((String)"part", LightPart.class);
    private static final AxisAlignedBB ONE = new AxisAlignedBB(0.125, 0.375, 0.125, 0.875, 0.6875, 0.875);
    private static final AxisAlignedBB TWO = new AxisAlignedBB(0.25, 0.125, 0.25, 0.75, 0.4375, 0.75);
    private static final AxisAlignedBB THREE = new AxisAlignedBB(0.375, 0.6875, 0.375, 0.625, 1.0, 0.625);
    private static final AxisAlignedBB BASE_BOTTOM = ONE.func_111270_a(TWO).func_111270_a(THREE);
    private static final AxisAlignedBB TOP_MID = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);

    public CeilingLight(String name, Material material) {
        super(material);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(McwLights.MACAWFENCESTAB);
        this.func_149711_c(0.5f);
        this.setHarvestLevel("axe", 1);
        this.func_149752_b(1.0f);
        this.func_149672_a(SoundType.field_185851_d);
        BlockInit.BLOCKS.add(this);
        ItemInit.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(PART, (Comparable)((Object)LightPart.BASE)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
    }

    protected IBlockState lightState(IBlockState state, World world, BlockPos pos) {
        boolean below;
        boolean above = world.func_180495_p(pos.func_177984_a()).func_177230_c() == this;
        boolean bl = below = world.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        if (above && below) {
            return state.func_177226_a(PART, (Comparable)((Object)LightPart.MIDDLE)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false));
        }
        if (!above && below) {
            return state.func_177226_a(PART, (Comparable)((Object)LightPart.TOP)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false));
        }
        if (above && !below) {
            return state.func_177226_a(PART, (Comparable)((Object)LightPart.BOTTOM)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true));
        }
        return state.func_177226_a(PART, (Comparable)((Object)LightPart.BASE)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!world.func_180495_p(pos).equals(state)) {
            world.func_180501_a(pos, this.lightState(state, world, pos), 2);
        }
    }

    @Nullable
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.lightState(super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand), world, pos);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.lightState(state, (World)world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos neighborPos) {
        IBlockState updatedState;
        IBlockState currentState;
        super.func_189540_a(state, world, pos, block, neighborPos);
        if (!world.field_72995_K && !(currentState = world.func_180495_p(pos)).equals(updatedState = this.lightState(currentState, world, pos))) {
            world.func_180501_a(pos, updatedState, 2);
        }
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{LIT}).add(new IProperty[]{PART}).build();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PART, (Comparable)((Object)LightPart.values()[meta & 3])).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf((meta & 4) != 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        meta |= ((LightPart)((Object)state.func_177229_b(PART))).ordinal();
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            meta |= 4;
        }
        return meta;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        Boolean isLit = (Boolean)state.func_177229_b((IProperty)LIT);
        LightPart part = (LightPart)((Object)state.func_177229_b(PART));
        if (isLit.booleanValue() && part == LightPart.BASE) {
            return 15;
        }
        if (isLit.booleanValue() && part == LightPart.BOTTOM) {
            return 15;
        }
        return 0;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        LightPart part = (LightPart)((Object)state.func_177229_b(PART));
        Boolean lit = (Boolean)state.func_177229_b((IProperty)LIT);
        ItemStack itemstack = player.func_184614_ca();
        Item item = itemstack.func_77973_b();
        if (item instanceof ItemBlock) {
            return false;
        }
        if (part != LightPart.TOP && part != LightPart.MIDDLE && (part == LightPart.BOTTOM || part == LightPart.BASE)) {
            state = state.func_177231_a((IProperty)LIT);
            worldIn.func_180501_a(pos, state, 10);
            if (!lit.booleanValue()) {
                worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else {
                worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        switch ((LightPart)((Object)blockState.func_177229_b(PART))) {
            case BASE: {
                return BASE_BOTTOM;
            }
            case TOP: {
                return TOP_MID;
            }
            case MIDDLE: {
                return TOP_MID;
            }
            case BOTTOM: {
                return BASE_BOTTOM;
            }
        }
        return BASE_BOTTOM;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        switch ((LightPart)((Object)blockState.func_177229_b(PART))) {
            case BASE: {
                return BASE_BOTTOM;
            }
            case TOP: {
                return TOP_MID;
            }
            case MIDDLE: {
                return TOP_MID;
            }
            case BOTTOM: {
                return BASE_BOTTOM;
            }
        }
        return BASE_BOTTOM;
    }

    public static enum LightPart implements IStringSerializable
    {
        BASE("base"),
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private final String name;

        private LightPart(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

