/*
 * Decompiled with CFR 0.152.
 */
package com.mcwdoors.kikoz.objects.blocks;

import com.mcwdoors.kikoz.Mcwdoors;
import com.mcwdoors.kikoz.init.BlockInit;
import com.mcwdoors.kikoz.init.ItemInit;
import com.mcwdoors.kikoz.init.SoundInit;
import com.mcwdoors.kikoz.objects.items.ItemDoorBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class JapaneseDoors
extends BlockDoor {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool OPEN = PropertyBool.func_177716_a((String)"open");
    public static final PropertyEnum<BlockDoor.EnumHingePosition> HINGE = PropertyEnum.func_177709_a((String)"hinge", BlockDoor.EnumHingePosition.class);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyEnum<BlockDoor.EnumDoorHalf> HALF = PropertyEnum.func_177709_a((String)"half", BlockDoor.EnumDoorHalf.class);
    protected static final AxisAlignedBB EAST = new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 1.0, 0.5625);
    protected static final AxisAlignedBB NORTH = new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5625, 1.0, 1.0);
    protected static final AxisAlignedBB RIGHT = new AxisAlignedBB(-0.69125, 0.0, 0.4375, 0.3125, 1.0, 0.5625);
    protected static final AxisAlignedBB LEFT = new AxisAlignedBB(0.683125, 0.0, 0.4375, 1.6875, 1.0, 0.5625);
    protected static final AxisAlignedBB RIGHT2 = new AxisAlignedBB(0.4375, 0.0, 0.6875, 0.5625, 1.0, 1.69125);
    protected static final AxisAlignedBB LEFT2 = new AxisAlignedBB(0.4375, 0.0, -0.6875, 0.5625, 1.0, 0.31625);

    public JapaneseDoors(String name, Material materialIn) {
        super(Material.field_151575_d);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(Mcwdoors.DOORTAB);
        this.func_149711_c(1.5f);
        this.setHarvestLevel("axe", 1);
        this.func_149752_b(1.0f);
        this.func_149672_a(SoundType.field_185848_a);
        BlockInit.BLOCKS.add((Block)this);
        ItemInit.ITEMS.add((Item)new ItemDoorBlock((Block)this).setRegistryName(name));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this);
    }

    public void registerModels() {
        Mcwdoors.proxy.registerModel(Item.func_150898_a((Block)this), 0);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate;
        if (this.field_149764_J == Material.field_151573_f) {
            return false;
        }
        BlockPos blockpos = state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate = pos.equals((Object)blockpos) ? state : worldIn.func_180495_p(blockpos);
        if (iblockstate.func_177230_c() != this) {
            return false;
        }
        state = iblockstate.func_177231_a((IProperty)OPEN);
        worldIn.func_180501_a(blockpos, state, 10);
        worldIn.func_175704_b(blockpos, pos);
        worldIn.func_184133_a(null, pos, this.getOpenSound(), SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.8f);
        return true;
    }

    protected SoundEvent getOpenSound() {
        return SoundInit.SHOJI;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER ? Items.field_190931_a : Item.func_150898_a((Block)this);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos blockpos = pos.func_177977_b();
        BlockPos blockpos1 = pos.func_177984_a();
        if (player.field_71075_bZ.field_75098_d && state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER && worldIn.func_180495_p(blockpos).func_177230_c() == this) {
            worldIn.func_175698_g(blockpos);
        }
        if (state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.LOWER && worldIn.func_180495_p(blockpos1).func_177230_c() == this) {
            if (player.field_71075_bZ.field_75098_d) {
                worldIn.func_175698_g(pos);
            }
            worldIn.func_175698_g(blockpos1);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        boolean open = (Boolean)state.func_177229_b((IProperty)OPEN) == false;
        boolean right = state.func_177229_b(HINGE) == BlockDoor.EnumHingePosition.RIGHT;
        boolean left = state.func_177229_b(HINGE) == BlockDoor.EnumHingePosition.LEFT;
        switch (enumfacing) {
            default: {
                if (left && !open) {
                    return RIGHT2;
                }
                if (right && !open) {
                    return LEFT2;
                }
                return NORTH;
            }
            case SOUTH: {
                if (left && !open) {
                    return LEFT;
                }
                if (right && !open) {
                    return RIGHT;
                }
                return EAST;
            }
            case EAST: {
                if (left && !open) {
                    return LEFT2;
                }
                if (right && !open) {
                    return RIGHT2;
                }
                return NORTH;
            }
            case NORTH: 
        }
        if (left && !open) {
            return RIGHT;
        }
        if (right && !open) {
            return LEFT;
        }
        return EAST;
    }
}

