/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils.wav;

import java.nio.ByteBuffer;
import net.minecraft.client.renderer.GLAllocation;

public class Wave {
    public int audioFormat;
    public int numChannels;
    public int sampleRate;
    public int byteRate;
    public int blockAlign;
    public int bitsPerSample;
    public byte[] data;

    public Wave(int audioFormat, int numChannels, int sampleRate, int byteRate, int blockAlign, int bitsPerSample, byte[] data) {
        this.audioFormat = audioFormat;
        this.numChannels = numChannels;
        this.sampleRate = sampleRate;
        this.byteRate = byteRate;
        this.blockAlign = blockAlign;
        this.bitsPerSample = bitsPerSample;
        this.data = data;
    }

    public int getBytesPerSample() {
        return this.bitsPerSample / 8;
    }

    public float getDuration() {
        return (float)(this.data.length / this.numChannels / this.getBytesPerSample()) / (float)this.sampleRate;
    }

    public int getALFormat() {
        int bytes = this.getBytesPerSample();
        if (bytes == 1) {
            if (this.numChannels == 2) {
                return 4354;
            }
            if (this.numChannels == 1) {
                return 4352;
            }
        } else if (bytes == 2) {
            if (this.numChannels == 2) {
                return 4355;
            }
            if (this.numChannels == 1) {
                return 4353;
            }
        }
        throw new IllegalStateException("Current WAV file has unusual configuration... channels: " + this.numChannels + ", BPS: " + bytes);
    }

    public int getScanRegion(float pixelsPerSecond) {
        return (int)((float)this.sampleRate / pixelsPerSecond) * this.getBytesPerSample() * this.numChannels;
    }

    public Wave convertTo16() {
        int bytes = 2;
        int c = this.data.length / this.numChannels / this.getBytesPerSample();
        int byteRate = c * this.numChannels * 2;
        byte[] data = new byte[byteRate];
        boolean isFloat = this.getBytesPerSample() == 4;
        Wave wave = new Wave(this.audioFormat, this.numChannels, this.sampleRate, byteRate, 2 * this.numChannels, 16, data);
        ByteBuffer sample = GLAllocation.func_74524_c((int)4);
        ByteBuffer dataBuffer = GLAllocation.func_74524_c((int)data.length);
        for (int i = 0; i < c * this.numChannels; ++i) {
            sample.clear();
            for (int j = 0; j < this.getBytesPerSample(); ++j) {
                sample.put(this.data[i * this.getBytesPerSample() + j]);
            }
            if (isFloat) {
                sample.flip();
                dataBuffer.putShort((short)(sample.getFloat() * 65535.0f / 2.0f));
                continue;
            }
            sample.put((byte)0);
            sample.flip();
            dataBuffer.putShort((short)((float)sample.getInt() / 8388607.5f * 32767.5f));
        }
        dataBuffer.flip();
        dataBuffer.get(data);
        return wave;
    }
}

