/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils;

public class MathUtils {
    public static int clamp(int x, int min, int max) {
        return x < min ? min : (x > max ? max : x);
    }

    public static <T extends Comparable> T clamp(T x, T min, T max) {
        return x.compareTo(min) < 0 ? min : (x.compareTo(max) > 0 ? max : x);
    }

    public static float clamp(float x, float min, float max) {
        return x < min ? min : (x > max ? max : x);
    }

    public static double clamp(double x, double min, double max) {
        return x < min ? min : (x > max ? max : x);
    }

    public static long clamp(long x, long min, long max) {
        return x < min ? min : (x > max ? max : x);
    }

    public static int cycler(int x, int min, int max) {
        return x < min ? max : (x > max ? min : x);
    }

    public static float cycler(float x, float min, float max) {
        return x < min ? max : (x > max ? min : x);
    }

    public static double cycler(double x, double min, double max) {
        return x < min ? max : (x > max ? min : x);
    }

    public static int gridIndex(int x, int y, int size, int width) {
        return (x /= size) + (y /= size) * width / size;
    }

    public static int gridRows(int count, int size, int width) {
        double x = (double)(count * size) / (double)width;
        return count <= 0 ? 1 : (int)Math.ceil(x);
    }

    public static float filterFlips(float prev, float current) {
        float sign = prev > current ? 1.0f : -1.0f;
        float add = sign * 2.0f * (float)Math.PI;
        while ((double)Math.abs(prev - current) >= Math.PI) {
            current += add;
        }
        return current;
    }
}

