/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;

public class Keys {
    public static final String[] KEYS = new String[256];
    public static final List<Integer> MODIFIERS = ImmutableList.of((Object)29, (Object)42, (Object)56, (Object)157, (Object)54, (Object)184);
    public static final String[] MODNAME = new String[]{"Ctrl", "Shift", "Alt"};

    public static String getKeyName(int key) {
        if (key < 0 || key >= 256) {
            return null;
        }
        if (KEYS[key] == null) {
            Keys.KEYS[key] = Keys.getKey(key);
            if (KEYS[key] == null) {
                return "Unknown key";
            }
        }
        return KEYS[key];
    }

    private static String getKey(int key) {
        switch (key) {
            case 12: {
                return "-";
            }
            case 13: {
                return "=";
            }
            case 26: {
                return "[";
            }
            case 27: {
                return "]";
            }
            case 39: {
                return ";";
            }
            case 40: {
                return "'";
            }
            case 43: {
                return "\\";
            }
            case 51: {
                return ",";
            }
            case 52: {
                return ".";
            }
            case 53: {
                return "/";
            }
            case 41: {
                return "`";
            }
            case 15: {
                return "Tab";
            }
            case 58: {
                return "Caps Lock";
            }
            case 42: {
                return "L. Shift";
            }
            case 29: {
                return "L. Ctrl";
            }
            case 56: {
                return "L. Alt";
            }
            case 219: {
                return Minecraft.field_142025_a ? "L. Cmd" : "L. Win";
            }
            case 54: {
                return "R. Shift";
            }
            case 157: {
                return "R. Ctrl";
            }
            case 184: {
                return "R. Alt";
            }
            case 220: {
                return Minecraft.field_142025_a ? "R. Cmd" : "R. Win";
            }
            case 181: {
                return "Numpad /";
            }
            case 55: {
                return "Numpad *";
            }
            case 74: {
                return "Numpad -";
            }
            case 78: {
                return "Numpad +";
            }
            case 83: {
                return "Numpad .";
            }
        }
        String name = Keyboard.getKeyName((int)key);
        if (name == null) {
            return null;
        }
        if (name.length() > 1) {
            name = name.substring(0, 1) + name.substring(1).toLowerCase();
        }
        if (name.startsWith("Numpad")) {
            name = name.replace("Numpad", "Numpad ");
        }
        return name;
    }

    public static int getComboKeyCode(int[] held, int keyCode) {
        int comboKey = keyCode;
        int modifierIndex = MODIFIERS.indexOf(keyCode) % 3;
        if (held != null) {
            for (int heldKey : held) {
                int index = MODIFIERS.indexOf(heldKey) % 3;
                if (index < 0 || index == modifierIndex) continue;
                comboKey |= 1 << 31 - index;
            }
        }
        return comboKey;
    }

    public static void main(String ... args) {
        System.out.println(Keys.getComboKeyName(Keys.getComboKeyCode(new int[]{54, 56, 29, 157}, 184)));
    }

    public static int getMainKey(int comboKey) {
        int key = comboKey & 0x1FFFFFFF;
        if (key >= 256) {
            key = 0;
        }
        return key;
    }

    public static String getComboKeyName(int comboKey) {
        StringBuilder builder = new StringBuilder();
        int mainKey = Keys.getMainKey(comboKey);
        if (mainKey == 0) {
            return Keys.getKeyName(mainKey);
        }
        for (int i = 0; i < 3; ++i) {
            if ((comboKey & 1 << 31 - i) == 0) continue;
            builder.append(MODNAME[i]).append(" + ");
        }
        builder.append(Keys.getKeyName(mainKey));
        return builder.toString();
    }

    public static boolean checkModifierKeys(int comboKey) {
        int index = MODIFIERS.indexOf(Keys.getMainKey(comboKey)) % 3;
        for (int i = 0; i < 3; ++i) {
            if (i == index || (comboKey & 1 << 31 - i) != 0 == Keys.isKeyDown(MODIFIERS.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isKeyDown(int key) {
        if (key == 42 || key == 54) {
            return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        }
        if (key == 29 || key == 157) {
            return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
        }
        if (key == 56 || key == 184) {
            return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
        }
        return Keyboard.isKeyDown((int)key);
    }
}

