/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils;

import mchorse.mclib.utils.IInterpolation;
import mchorse.mclib.utils.Interpolations;
import mchorse.mclib.utils.MathUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum Interpolation implements IInterpolation
{
    LINEAR("linear"){

        @Override
        public float interpolate(float a, float b, float x) {
            return Interpolations.lerp(a, b, x);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            return Interpolations.lerp(a, b, x);
        }
    }
    ,
    QUAD_IN("quad_in"){

        @Override
        public float interpolate(float a, float b, float x) {
            return a + (b - a) * x * x;
        }

        @Override
        public double interpolate(double a, double b, double x) {
            return a + (b - a) * x * x;
        }
    }
    ,
    QUAD_OUT("quad_out"){

        @Override
        public float interpolate(float a, float b, float x) {
            return a - (b - a) * x * (x - 2.0f);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            return a - (b - a) * x * (x - 2.0);
        }
    }
    ,
    QUAD_INOUT("quad_inout"){

        @Override
        public float interpolate(float a, float b, float x) {
            if ((x *= 2.0f) < 1.0f) {
                return a + (b - a) / 2.0f * x * x;
            }
            return a - (b - a) / 2.0f * ((x -= 1.0f) * (x - 2.0f) - 1.0f);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            if ((x *= 2.0) < 1.0) {
                return a + (b - a) / 2.0 * x * x;
            }
            return a - (b - a) / 2.0 * ((x -= 1.0) * (x - 2.0) - 1.0);
        }
    }
    ,
    CUBIC_IN("cubic_in"){

        @Override
        public float interpolate(float a, float b, float x) {
            return a + (b - a) * x * x * x;
        }

        @Override
        public double interpolate(double a, double b, double x) {
            return a + (b - a) * x * x * x;
        }
    }
    ,
    CUBIC_OUT("cubic_out"){

        @Override
        public float interpolate(float a, float b, float x) {
            return a + (b - a) * ((x -= 1.0f) * x * x + 1.0f);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            return a + (b - a) * ((x -= 1.0) * x * x + 1.0);
        }
    }
    ,
    CUBIC_INOUT("cubic_inout"){

        @Override
        public float interpolate(float a, float b, float x) {
            if ((x *= 2.0f) < 1.0f) {
                return a + (b - a) / 2.0f * x * x * x;
            }
            return a + (b - a) / 2.0f * ((x -= 2.0f) * x * x + 2.0f);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            if ((x *= 2.0) < 1.0) {
                return a + (b - a) / 2.0 * x * x * x;
            }
            return a + (b - a) / 2.0 * ((x -= 2.0) * x * x + 2.0);
        }
    }
    ,
    EXP_IN("exp_in"){

        @Override
        public float interpolate(float a, float b, float x) {
            return (float)this.interpolate((double)a, (double)b, (double)x);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            if (x == 0.0) {
                return a;
            }
            double pow0 = Math.pow(2.0, -10.0);
            return a + (b - a) / (1.0 - pow0) * Math.pow(2.0, 10.0 * (x - 1.0)) - pow0;
        }
    }
    ,
    EXP_OUT("exp_out"){

        @Override
        public float interpolate(float a, float b, float x) {
            return (float)this.interpolate((double)a, (double)b, (double)x);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            if (x == 0.0) {
                return a;
            }
            double pow0 = Math.pow(2.0, -10.0);
            return a + (b - a) * (1.0 - (Math.pow(2.0, -10.0 * x) - pow0) * 1.0 / (1.0 - pow0));
        }
    }
    ,
    EXP_INOUT("exp_inout"){

        @Override
        public float interpolate(float a, float b, float x) {
            return (float)this.interpolate((double)a, (double)b, (double)x);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            if (x <= 0.5) {
                return EXP_IN.interpolate(a, a + (b - a) / 2.0, x * 2.0);
            }
            return EXP_OUT.interpolate(a + (b - a) / 2.0, b, x * 2.0 - 1.0);
        }
    }
    ,
    BACK_IN("back_in"){

        @Override
        public float interpolate(float a, float b, float x) {
            float c1 = 1.70158f;
            float c3 = 2.70158f;
            return Interpolations.lerp(a, b, 2.70158f * x * x * x - 1.70158f * x * x);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            double c1 = 1.70158;
            double c3 = 2.70158;
            return Interpolations.lerp(a, b, 2.70158 * x * x * x - 1.70158 * x * x);
        }
    }
    ,
    BACK_OUT("back_out"){

        @Override
        public float interpolate(float a, float b, float x) {
            float c1 = 1.70158f;
            float c3 = 2.70158f;
            return Interpolations.lerp(a, b, 1.0f + 2.70158f * (float)Math.pow(x - 1.0f, 3.0) + 1.70158f * (float)Math.pow(x - 1.0f, 2.0));
        }

        @Override
        public double interpolate(double a, double b, double x) {
            double c1 = 1.70158;
            double c3 = 2.70158;
            return Interpolations.lerp(a, b, 1.0 + 2.70158 * Math.pow(x - 1.0, 3.0) + 1.70158 * Math.pow(x - 1.0, 2.0));
        }
    }
    ,
    BACK_INOUT("back_inout"){

        @Override
        public float interpolate(float a, float b, float x) {
            float c1 = 1.70158f;
            float c2 = 2.5949094f;
            float factor = (double)x < 0.5 ? (float)Math.pow(2.0f * x, 2.0) * (7.189819f * x - 2.5949094f) / 2.0f : ((float)Math.pow(2.0f * x - 2.0f, 2.0) * (3.5949094f * (x * 2.0f - 2.0f) + 2.5949094f) + 2.0f) / 2.0f;
            return Interpolations.lerp(a, b, factor);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            double c1 = 1.70158;
            double c2 = 2.5949095;
            double factor = x < 0.5 ? Math.pow(2.0 * x, 2.0) * (7.189819 * x - 2.5949095) / 2.0 : (Math.pow(2.0 * x - 2.0, 2.0) * (3.5949095 * (x * 2.0 - 2.0) + 2.5949095) + 2.0) / 2.0;
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    ELASTIC_IN("elastic_in"){

        @Override
        public float interpolate(float a, float b, float x) {
            float c4 = 2.0943952f;
            float factor = x == 0.0f ? 0.0f : (x == 1.0f ? 1.0f : -((float)Math.pow(2.0, 10.0f * x - 10.0f)) * (float)Math.sin(((double)(x * 10.0f) - 10.75) * 2.094395160675049));
            return Interpolations.lerp(a, b, factor);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            double c4 = 2.094395160675049;
            double factor = x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : -Math.pow(2.0, 10.0 * x - 10.0) * Math.sin((x * 10.0 - 10.75) * 2.094395160675049));
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    ELASTIC_OUT("elastic_out"){

        @Override
        public float interpolate(float a, float b, float x) {
            float c4 = 2.0943952f;
            float factor = x == 0.0f ? 0.0f : (x == 1.0f ? 1.0f : (float)Math.pow(2.0, -10.0f * x) * (float)Math.sin(((double)(x * 10.0f) - 0.75) * 2.094395160675049) + 1.0f);
            return Interpolations.lerp(a, b, factor);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            double c4 = 2.0943951023931953;
            double factor = x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : Math.pow(2.0, -10.0 * x) * Math.sin((x * 10.0 - 0.75) * 2.0943951023931953) + 1.0);
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    ELASTIC_INOUT("elastic_inout"){

        @Override
        public float interpolate(float a, float b, float x) {
            float c5 = 1.3962635f;
            float factor = x == 0.0f ? 0.0f : (x == 1.0f ? 1.0f : ((double)x < 0.5 ? -((float)Math.pow(2.0, 20.0f * x - 10.0f) * (float)Math.sin(((double)(20.0f * x) - 11.125) * 1.3962634801864624)) / 2.0f : (float)Math.pow(2.0, -20.0f * x + 10.0f) * (float)Math.sin(((double)(20.0f * x) - 11.125) * 1.3962634801864624) / 2.0f + 1.0f));
            return Interpolations.lerp(a, b, factor);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            double c5 = 1.3962634015954636;
            double factor = x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : (x < 0.5 ? -(Math.pow(2.0, 20.0 * x - 10.0) * Math.sin((20.0 * x - 11.125) * 1.3962634015954636)) / 2.0 : Math.pow(2.0, -20.0 * x + 10.0) * Math.sin((20.0 * x - 11.125) * 1.3962634015954636) / 2.0 + 1.0));
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    BOUNCE_IN("bounce_in"){

        @Override
        public float interpolate(float a, float b, float x) {
            return Interpolations.lerp(a, b, 1.0f - BOUNCE_OUT.interpolate(0.0f, 1.0f, 1.0f - x));
        }

        @Override
        public double interpolate(double a, double b, double x) {
            return Interpolations.lerp(a, b, 1.0 - BOUNCE_OUT.interpolate(0.0, 1.0, 1.0 - x));
        }
    }
    ,
    BOUNCE_OUT("bounce_out"){

        @Override
        public float interpolate(float a, float b, float x) {
            float n1 = 7.5625f;
            float d1 = 2.75f;
            float factor = x < 0.36363637f ? 7.5625f * x * x : (x < 0.72727275f ? 7.5625f * (x -= 0.54545456f) * x + 0.75f : ((double)x < 0.9090909090909091 ? 7.5625f * (x -= 0.8181818f) * x + 0.9375f : 7.5625f * (x -= 0.95454544f) * x + 0.984375f));
            return Interpolations.lerp(a, b, factor);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            double n1 = 7.5625;
            double d1 = 2.75;
            double factor = x < 0.36363636363636365 ? 7.5625 * x * x : (x < 0.7272727272727273 ? 7.5625 * (x -= 0.5454545454545454) * x + 0.75 : (x < 0.9090909090909091 ? 7.5625 * (x -= 0.8181818181818182) * x + 0.9375 : 7.5625 * (x -= 0.9545454545454546) * x + 0.984375));
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    BOUNCE_INOUT("bounce_inout"){

        @Override
        public float interpolate(float a, float b, float x) {
            float factor = (double)x < 0.5 ? (1.0f - BOUNCE_OUT.interpolate(0.0f, 1.0f, 1.0f - 2.0f * x)) / 2.0f : (1.0f + BOUNCE_OUT.interpolate(0.0f, 1.0f, 2.0f * x - 1.0f)) / 2.0f;
            return Interpolations.lerp(a, b, factor);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            double factor = x < 0.5 ? (1.0 - BOUNCE_OUT.interpolate(0.0, 1.0, 1.0 - 2.0 * x)) / 2.0 : (1.0 + BOUNCE_OUT.interpolate(0.0, 1.0, 2.0 * x - 1.0)) / 2.0;
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    SINE_IN("sine_in"){

        @Override
        public float interpolate(float a, float b, float x) {
            float factor = 1.0f - (float)Math.cos((double)x * Math.PI / 2.0);
            return Interpolations.lerp(a, b, factor);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            double factor = 1.0f - (float)Math.cos(x * Math.PI / 2.0);
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    SINE_OUT("sine_out"){

        @Override
        public float interpolate(float a, float b, float x) {
            float factor = (float)Math.sin((double)x * Math.PI / 2.0);
            return Interpolations.lerp(a, b, factor);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            double factor = Math.sin(x * Math.PI / 2.0);
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    SINE_INOUT("sine_inout"){

        @Override
        public float interpolate(float a, float b, float x) {
            float factor = (float)(-(Math.cos(Math.PI * (double)x) - 1.0) / 2.0);
            return Interpolations.lerp(a, b, factor);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            double factor = -(Math.cos(Math.PI * x) - 1.0) / 2.0;
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    QUART_IN("quart_in"){

        @Override
        public float interpolate(float a, float b, float x) {
            float factor = x * x * x * x;
            return Interpolations.lerp(a, b, factor);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            double factor = x * x * x * x;
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    QUART_OUT("quart_out"){

        @Override
        public float interpolate(float a, float b, float x) {
            float factor = 1.0f - (float)Math.pow(1.0f - x, 4.0);
            return Interpolations.lerp(a, b, factor);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            double factor = 1.0 - Math.pow(1.0 - x, 4.0);
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    QUART_INOUT("quart_inout"){

        @Override
        public float interpolate(float a, float b, float x) {
            float factor = (double)x < 0.5 ? 8.0f * x * x * x * x : 1.0f - (float)Math.pow(-2.0f * x + 2.0f, 4.0) / 2.0f;
            return Interpolations.lerp(a, b, factor);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            double factor = x < 0.5 ? 8.0 * x * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 4.0) / 2.0;
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    QUINT_IN("quint_in"){

        @Override
        public float interpolate(float a, float b, float x) {
            float factor = x * x * x * x * x;
            return Interpolations.lerp(a, b, factor);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            double factor = x * x * x * x * x;
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    QUINT_OUT("quint_out"){

        @Override
        public float interpolate(float a, float b, float x) {
            float factor = 1.0f - (float)Math.pow(1.0f - x, 5.0);
            return Interpolations.lerp(a, b, factor);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            double factor = 1.0 - Math.pow(1.0 - x, 5.0);
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    QUINT_INOUT("quint_inout"){

        @Override
        public float interpolate(float a, float b, float x) {
            float factor = (double)x < 0.5 ? 16.0f * x * x * x * x * x : 1.0f - (float)Math.pow(-2.0f * x + 2.0f, 5.0) / 2.0f;
            return Interpolations.lerp(a, b, factor);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            double factor = x < 0.5 ? 16.0 * x * x * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 5.0) / 2.0;
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    CIRCLE_IN("circle_in"){

        @Override
        public float interpolate(float a, float b, float x) {
            x = MathUtils.clamp(x, 0.0f, 1.0f);
            float factor = 1.0f - (float)Math.sqrt(1.0 - Math.pow(x, 2.0));
            return Interpolations.lerp(a, b, factor);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            x = MathUtils.clamp(x, 0.0, 1.0);
            double factor = 1.0f - (float)Math.sqrt(1.0 - Math.pow(x, 2.0));
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    CIRCLE_OUT("circle_out"){

        @Override
        public float interpolate(float a, float b, float x) {
            x = MathUtils.clamp(x, 0.0f, 1.0f);
            float factor = (float)Math.sqrt(1.0 - Math.pow(x - 1.0f, 2.0));
            return Interpolations.lerp(a, b, factor);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            x = MathUtils.clamp(x, 0.0, 1.0);
            double factor = Math.sqrt(1.0 - Math.pow(x - 1.0, 2.0));
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    CIRCLE_INOUT("circle_inout"){

        @Override
        public float interpolate(float a, float b, float x) {
            float factor = (double)(x = MathUtils.clamp(x, 0.0f, 1.0f)) < 0.5 ? (float)(1.0 - Math.sqrt(1.0 - Math.pow(2.0f * x, 2.0))) / 2.0f : (float)(Math.sqrt(1.0 - Math.pow(-2.0f * x + 2.0f, 2.0)) + 1.0) / 2.0f;
            return Interpolations.lerp(a, b, factor);
        }

        @Override
        public double interpolate(double a, double b, double x) {
            double factor = (x = MathUtils.clamp(x, 0.0, 1.0)) < 0.5 ? (1.0 - Math.sqrt(1.0 - Math.pow(2.0 * x, 2.0))) / 2.0 : (Math.sqrt(1.0 - Math.pow(-2.0 * x + 2.0, 2.0)) + 1.0) / 2.0;
            return Interpolations.lerp(a, b, factor);
        }
    };

    public final String key;

    private Interpolation(String key) {
        this.key = key;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getKey() {
        return "mclib.interpolations." + this.key;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getTooltipKey() {
        return "mclib.interpolations.tooltips." + this.key;
    }
}

