/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils;

import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;

public class Consumers<C> {
    private final TreeMap<Integer, Consumer<C>> callbacks = new TreeMap();

    public void remove(int id) {
        this.callbacks.remove(id);
    }

    public void consume(int id, C value) {
        this.consume(id, value, true);
    }

    public void consume(int id, C value, boolean remove) {
        Consumer<C> callback = this.callbacks.get(id);
        if (callback != null) {
            callback.accept(value);
            if (remove) {
                this.callbacks.remove(id);
            }
        }
    }

    public int register(Consumer<C> callback) {
        if (!this.callbacks.containsValue(callback)) {
            Map.Entry<Integer, Consumer<C>> last = this.callbacks.lastEntry();
            int id = last != null ? last.getKey() + 1 : 0;
            this.callbacks.put(id, callback);
            return id;
        }
        for (Map.Entry<Integer, Consumer<C>> entry : this.callbacks.entrySet()) {
            if (entry.getValue() != callback) continue;
            return entry.getKey();
        }
        return -1;
    }
}

