/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.events;

import java.util.ArrayList;
import java.util.List;
import mchorse.mclib.McLib;
import mchorse.mclib.permissions.PermissionCategory;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

public class RegisterPermissionsEvent
extends Event {
    private final List<PermissionCategory> mods = new ArrayList<PermissionCategory>();
    private final List<PermissionCategory> permissions = new ArrayList<PermissionCategory>();
    private PermissionCategory currentMod;
    private PermissionCategory currentCategory;

    public void registerMod(String modid, DefaultPermissionLevel level) {
        this.currentCategory = this.currentMod = new PermissionCategory(modid, level);
        this.mods.add(this.currentMod);
    }

    public void registerCategory(PermissionCategory category) throws UnsupportedOperationException {
        if (this.currentCategory == null) {
            throw new UnsupportedOperationException("No current category to add this category to!");
        }
        this.currentCategory.addChild(category);
        this.currentCategory = category;
    }

    public void registerPermission(PermissionCategory permission) throws UnsupportedOperationException {
        if (this.currentCategory == null) {
            throw new UnsupportedOperationException("No current category present to add the permission to!");
        }
        this.currentCategory.addChild(permission);
        this.permissions.add(permission);
    }

    public void loadPermissions() {
        for (PermissionCategory permission : this.permissions) {
            if (permission.hasChildren()) continue;
            PermissionAPI.registerNode((String)permission.toString(), (DefaultPermissionLevel)permission.getDefaultPermission(), (String)"");
            McLib.permissionFactory.registerPermission(permission);
        }
    }

    public void endCategory() {
        if (this.currentCategory == this.currentMod) {
            this.currentMod = null;
            this.currentCategory = null;
        } else {
            this.currentCategory = this.currentCategory.getParent();
        }
    }

    public void endMod() {
        this.currentMod = null;
        this.currentCategory = null;
    }
}

