/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.utils;

import com.google.common.collect.ImmutableList;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.tooltips.styles.TooltipStyle;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.ColorUtils;
import mchorse.mclib.utils.IInterpolation;
import mchorse.mclib.utils.MathUtils;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class InterpolationRenderer {
    public static void drawInterpolationPreview(IInterpolation interp, GuiContext context, int x, int y, float anchorX, float anchorY, int duration) {
        if (interp == null) {
            return;
        }
        float iterations = 40.0f;
        float padding = 50.0f;
        int w = 140;
        int h = 130;
        TooltipStyle style = TooltipStyle.get();
        String tooltip = interp.getTooltip();
        ImmutableList lines = tooltip.isEmpty() ? ImmutableList.of() : context.font.func_78271_c(tooltip, w - 20);
        int ah = lines.isEmpty() ? 0 : lines.size() * (context.font.field_78288_b + 4);
        y = MathUtils.clamp(y, 0, context.screen.field_146295_m - h - ah);
        Area.SHARED.set(x -= (int)((float)w * anchorX), y -= (int)((float)h * anchorY), w, h + ah);
        style.drawBackground(Area.SHARED);
        Color fg = ColorUtils.COLOR.set(style.getForegroundColor(), false);
        int font = style.getTextColor();
        context.font.func_78276_b(interp.getName(), x + 10, y + 10, font);
        for (int i = 0; i < lines.size(); ++i) {
            context.font.func_78276_b((String)lines.get(i), x + 10, y + h - 5 + i * (context.font.field_78288_b + 4), font);
        }
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_187441_d((float)2.0f);
        builder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        builder.func_181662_b((double)(x + 10), (double)(y + 20), 0.0).func_181666_a(fg.r, fg.g, fg.b, 0.2f).func_181675_d();
        builder.func_181662_b((double)(x + 10), (double)(y + h - 10), 0.0).func_181666_a(fg.r, fg.g, fg.b, 0.2f).func_181675_d();
        builder.func_181662_b((double)(x + w / 2), (double)(y + 20), 0.0).func_181666_a(fg.r, fg.g, fg.b, 0.2f).func_181675_d();
        builder.func_181662_b((double)(x + w / 2), (double)(y + h - 10), 0.0).func_181666_a(fg.r, fg.g, fg.b, 0.2f).func_181675_d();
        builder.func_181662_b((double)(x + w - 10), (double)(y + 20), 0.0).func_181666_a(fg.r, fg.g, fg.b, 0.2f).func_181675_d();
        builder.func_181662_b((double)(x + w - 10), (double)(y + h - 10), 0.0).func_181666_a(fg.r, fg.g, fg.b, 0.2f).func_181675_d();
        builder.func_181662_b((double)(x + 10), (double)(y + 20), 0.0).func_181666_a(fg.r, fg.g, fg.b, 0.2f).func_181675_d();
        builder.func_181662_b((double)(x + w - 10), (double)(y + 20), 0.0).func_181666_a(fg.r, fg.g, fg.b, 0.2f).func_181675_d();
        builder.func_181662_b((double)(x + 10), (double)(y + 20 + (h - 30) / 2), 0.0).func_181666_a(fg.r, fg.g, fg.b, 0.2f).func_181675_d();
        builder.func_181662_b((double)(x + w - 10), (double)(y + 20 + (h - 30) / 2), 0.0).func_181666_a(fg.r, fg.g, fg.b, 0.2f).func_181675_d();
        builder.func_181662_b((double)(x + 10), (double)(y + h - 10), 0.0).func_181666_a(fg.r, fg.g, fg.b, 0.2f).func_181675_d();
        builder.func_181662_b((double)(x + w - 10), (double)(y + h - 10), 0.0).func_181666_a(fg.r, fg.g, fg.b, 0.2f).func_181675_d();
        builder.func_181662_b((double)(x + 10), (double)((float)(y + h - 10) - 25.0f), 0.0).func_181666_a(fg.r, fg.g, fg.b, 0.11f).func_181675_d();
        builder.func_181662_b((double)(x + w - 10), (double)((float)(y + h - 10) - 25.0f), 0.0).func_181666_a(fg.r, fg.g, fg.b, 0.11f).func_181675_d();
        builder.func_181662_b((double)(x + 10), (double)((float)(y + 20) + 25.0f), 0.0).func_181666_a(fg.r, fg.g, fg.b, 0.11f).func_181675_d();
        builder.func_181662_b((double)(x + w - 10), (double)((float)(y + 20) + 25.0f), 0.0).func_181666_a(fg.r, fg.g, fg.b, 0.11f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_187441_d((float)3.0f);
        builder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        int i = 1;
        while ((float)i <= 40.0f) {
            float factor0 = (float)(i - 1) / 40.0f;
            float value0 = 1.0f - interp.interpolate(0.0f, 1.0f, factor0);
            float factor1 = (float)i / 40.0f;
            float value1 = 1.0f - interp.interpolate(0.0f, 1.0f, factor1);
            float x1 = (float)(x + 10) + factor1 * (float)(w - 20);
            float x2 = (float)(x + 10) + factor0 * (float)(w - 20);
            float y1 = (float)(y + 20) + 25.0f + value1 * ((float)(h - 30) - 50.0f);
            float y2 = (float)(y + 20) + 25.0f + value0 * ((float)(h - 30) - 50.0f);
            builder.func_181662_b((double)x1, (double)y1, 0.0).func_181666_a(fg.r, fg.g, fg.b, 1.0f).func_181675_d();
            builder.func_181662_b((double)x2, (double)y2, 0.0).func_181666_a(fg.r, fg.g, fg.b, 1.0f).func_181675_d();
            ++i;
        }
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179098_w();
        context.font.func_78276_b("A", x + 14, (int)((float)(y + h - 10) - 25.0f) + 4, font);
        context.font.func_78276_b("B", x + w - 19, (int)((float)(y + 20) + 25.0f) - context.font.field_78288_b - 4, font);
        float tick = ((float)context.tick + context.partialTicks) % (float)(duration + 20) / (float)duration;
        float factor = MathUtils.clamp(tick, 0.0f, 1.0f);
        int px = x + w - 5;
        int py = y + 20 + 25 + (int)((1.0f - interp.interpolate(0.0f, 1.0f, factor)) * ((float)(h - 30) - 50.0f));
        Gui.func_73734_a((int)(px - 2), (int)(py - 2), (int)(px + 2), (int)(py + 2), (int)(-16777216 + fg.getRGBColor()));
    }
}

