/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.utils;

import java.util.Collection;
import java.util.List;
import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiSlotElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.ScrollArea;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.SearchTreeManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;

public class GuiInventoryElement
extends GuiElement {
    public static NonNullList<ItemStack> container;
    public GuiTrackpadElement count;
    public GuiIconElement toggle;
    public GuiTextElement search;
    public GuiSlotElement slot;
    protected ScrollArea inventory = new ScrollArea(20);
    protected Area hotbar = new Area();
    private ItemStack active = ItemStack.field_190927_a;
    private boolean searching;

    public static void drawItemStack(ItemStack stack, int x, int y, String altText) {
        GuiInventoryElement.drawItemStack(stack, x, y, 200, altText);
    }

    public static void drawItemStack(ItemStack stack, int x, int y, int z, String altText) {
        RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        itemRender.field_77023_b = z;
        FontRenderer font = null;
        if (!stack.func_190926_b()) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = Minecraft.func_71410_x().field_71466_p;
        }
        itemRender.func_180450_b(stack, x, y);
        itemRender.func_180453_a(font, stack, x, y, altText);
        itemRender.field_77023_b = 0.0f;
        GlStateManager.func_179121_F();
    }

    public static void drawItemTooltip(ItemStack stack, EntityPlayerSP player, FontRenderer providedFont, int x, int y) {
        if (stack.func_190926_b()) {
            return;
        }
        List list = stack.func_82840_a((EntityPlayer)player, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                list.set(i, stack.func_77953_t().field_77937_e + (String)list.get(i));
                continue;
            }
            list.set(i, TextFormatting.GRAY + (String)list.get(i));
        }
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        GuiUtils.preItemToolTip((ItemStack)stack);
        GuiUtils.drawHoveringText((List)list, (int)x, (int)y, (int)screen.field_146294_l, (int)screen.field_146295_m, (int)-1, (FontRenderer)(font == null ? providedFont : font));
        GuiUtils.postItemToolTip();
    }

    public GuiInventoryElement(Minecraft mc, GuiSlotElement slot) {
        super(mc);
        this.count = new GuiTrackpadElement(mc, v -> this.setCount(v.intValue()));
        this.count.limit(1.0).integer();
        this.toggle = new GuiIconElement(mc, Icons.SEARCH, this::toggleList);
        this.search = new GuiTextElement(mc, t -> this.updateList());
        this.search.setVisible(false);
        this.slot = slot;
        this.flex().wh(200, 140);
        this.count.flex().relative(this).x(10).y(10).w(1.0f, -40);
        this.search.flex().relative(this).x(10).y(10).w(1.0f, -40);
        this.toggle.flex().relative(this).x(1.0f, -30).y(10);
        this.add(this.count, this.toggle, this.search);
        this.inventory.scrollSpeed = 20;
    }

    private void setCount(int count) {
        ItemStack stack = this.slot.getStack().func_77946_l();
        stack.func_190920_e(count);
        this.slot.acceptStack(stack, this.slot.lastSlot);
    }

    private void toggleList(GuiIconElement element) {
        this.searching = !this.searching;
        this.updateElements();
        this.updateList();
    }

    private void updateElements() {
        this.count.setVisible(!this.searching && !this.slot.getStack().func_190926_b());
        this.search.setVisible(this.searching);
        this.inventory.h = this.searching ? 100 : 60;
    }

    private void updateList() {
        if (container == null) {
            container = NonNullList.func_191196_a();
        }
        container.clear();
        container.addAll((Collection)this.mc.func_193987_a(SearchTreeManager.field_194011_a).func_194038_a(this.search.field.func_146179_b().toLowerCase()));
        this.inventory.scroll = 0;
        this.inventory.scrollSize = (int)(Math.ceil((double)container.size() / 9.0) * (double)this.inventory.scrollItemSize);
    }

    private void setStack(ItemStack stack, int slot) {
        this.slot.acceptStack(stack, slot);
        this.updateElements();
        this.fillStack(this.slot.getStack());
    }

    public void updateInventory() {
        this.inventory.scroll = 0;
        this.searching = false;
        this.fillStack(this.slot.getStack());
        this.updateElements();
    }

    private void fillStack(ItemStack stack) {
        this.count.setVisible(!stack.func_190926_b());
        this.count.limit(1.0, stack.func_77976_d());
        this.count.setValue(stack.func_190916_E());
    }

    @Override
    public void resize() {
        super.resize();
        int tile = 20;
        int row = 9 * tile;
        int fourth = this.area.h / 4;
        this.inventory.set(this.area.mx(row), this.area.ey() - (fourth + tile) / 2 - tile * 4, row, (this.searching ? 5 : 3) * tile);
        this.hotbar.set(this.area.mx(row), this.area.ey() - (fourth + tile) / 2, row, tile);
    }

    @Override
    public boolean mouseClicked(GuiContext context) {
        if (super.mouseClicked(context)) {
            return true;
        }
        if (!this.area.isInside(context)) {
            this.removeFromParent();
            return false;
        }
        if (this.searching && this.inventory.mouseClicked(context)) {
            return true;
        }
        boolean inventory = this.inventory.isInside(context);
        boolean hotbar = this.hotbar.isInside(context);
        if ((inventory || hotbar) && context.mouseButton == 0) {
            Area area = inventory ? this.inventory : this.hotbar;
            int x = (context.mouseX - area.x - 2) / 20;
            int y = (context.mouseY - area.y - 2) / 20;
            if (inventory && !this.searching) {
                ++y;
            }
            if (x >= 9 || y >= this.inventory.h / 20 + 1 || x < 0 || y < 0 || !this.isVisible()) {
                return true;
            }
            int index = x + y * 9;
            if (this.slot != null) {
                NonNullList items;
                NonNullList nonNullList = items = this.searching ? container : this.mc.field_71439_g.field_71071_by.field_70462_a;
                if (this.searching) {
                    index += this.inventory.scroll / 20 * 9;
                }
                if (index < items.size()) {
                    this.setStack((ItemStack)items.get(index), this.searching ? -1 : index);
                    this.removeFromParent();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(GuiContext context) {
        return super.mouseScrolled(context) || this.searching && this.inventory.mouseScroll(context);
    }

    @Override
    public void mouseReleased(GuiContext context) {
        super.mouseReleased(context);
        this.inventory.mouseReleased(context);
    }

    @Override
    public void draw(GuiContext context) {
        this.active = null;
        GlStateManager.func_179086_m((int)256);
        int border = -1;
        int fourth = this.area.y(0.75f);
        if (((Boolean)McLib.enableBorders.get()).booleanValue()) {
            Gui.func_73734_a((int)(this.area.x + 1), (int)this.area.y, (int)(this.area.ex() - 1), (int)this.area.ey(), (int)-16777216);
            Gui.func_73734_a((int)this.area.x, (int)(this.area.y + 1), (int)this.area.ex(), (int)(this.area.ey() - 1), (int)-16777216);
            Gui.func_73734_a((int)(this.area.x + 1), (int)(this.area.y + 1), (int)(this.area.ex() - 1), (int)(this.area.ey() - 1), (int)border);
            Gui.func_73734_a((int)(this.area.x + 2), (int)(this.area.y + 2), (int)(this.area.ex() - 2), (int)(this.area.ey() - 2), (int)-3750202);
            if (!this.searching) {
                Gui.func_73734_a((int)(this.area.x + 1), (int)fourth, (int)(this.area.ex() - 1), (int)(this.area.ey() - 1), (int)-14540254);
            }
        } else {
            Gui.func_73734_a((int)this.area.x, (int)this.area.y, (int)this.area.ex(), (int)this.area.ey(), (int)border);
            Gui.func_73734_a((int)(this.area.x + 1), (int)(this.area.y + 1), (int)(this.area.ex() - 1), (int)(this.area.ey() - 1), (int)-3750202);
            if (!this.searching) {
                Gui.func_73734_a((int)this.area.x, (int)fourth, (int)this.area.ex(), (int)this.area.ey(), (int)-14540254);
            }
        }
        GuiDraw.drawDropCircleShadow(this.toggle.area.mx(), this.toggle.area.my(), 10, 4, 8, 0x18000000, 0);
        GlStateManager.func_179126_j();
        RenderHelper.func_74520_c();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        if (this.searching) {
            int index;
            int scroll = 0;
            if (container.size() > 45) {
                int rows = (int)Math.ceil((float)container.size() / 9.0f);
                float factor = (float)this.inventory.scroll / (float)this.inventory.scrollSize;
                scroll = (int)(factor * (float)rows);
                scroll *= 9;
            }
            if ((index = this.drawGrid(context, this.inventory, container, -1, scroll, scroll + this.inventory.h / 20 * 9)) != -1) {
                this.active = (ItemStack)container.get(index);
            }
        } else {
            NonNullList inventory = this.mc.field_71439_g.field_71071_by.field_70462_a;
            int index = this.drawGrid(context, this.inventory, (NonNullList<ItemStack>)inventory, -1, 9, inventory.size());
            if ((index = this.drawGrid(context, this.hotbar, (NonNullList<ItemStack>)inventory, index, 0, 9)) != -1) {
                this.active = (ItemStack)inventory.get(index);
            }
        }
        if (this.active != null) {
            context.tooltip.set(context, this);
        }
        GlStateManager.func_179097_i();
        RenderHelper.func_74518_a();
        GuiDraw.drawLockedArea(this, (Boolean)McLib.enableBorders.get() != false ? 1 : 0);
        if (this.searching) {
            this.inventory.drag(context);
            GuiDraw.scissor(this.inventory.x, this.inventory.y, this.inventory.w, this.inventory.h, context);
            this.inventory.drawScrollbar();
            GuiDraw.unscissor(context);
        }
        super.draw(context);
    }

    private int drawGrid(GuiContext context, Area area, NonNullList<ItemStack> inventory, int index, int i, int c) {
        for (int j = 0; j < c - i; ++j) {
            int k = i + j;
            if (k >= inventory.size()) {
                return index;
            }
            ItemStack stack = (ItemStack)inventory.get(k);
            int x = j % 9;
            int y = j / 9;
            x = area.x + 2 + 20 * x;
            y = area.y + 2 + 20 * y;
            int diffX = context.mouseX - x;
            int diffY = context.mouseY - y;
            boolean hover = diffX >= 0 && diffX < 18 && diffY >= 0 && diffY < 18;
            Gui.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + 17), (int)(y + 17), (int)(area == this.hotbar ? -1442840576 : 0x44000000));
            GuiInventoryElement.drawItemStack(stack, x, y, null);
            if (!hover) continue;
            Gui.func_73734_a((int)(x - 2), (int)(y - 2), (int)(x + 18), (int)(y + 18), (int)(-872415232 + (Integer)McLib.primaryColor.get()));
            index = k;
        }
        return index;
    }

    @Override
    public void drawTooltip(GuiContext context, Area area) {
        super.drawTooltip(context, area);
        GuiInventoryElement.drawItemTooltip(this.active, this.mc.field_71439_g, this.font, context.mouseX, context.mouseY);
    }
}

