/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.keyframes;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;
import mchorse.mclib.client.gui.framework.elements.keyframes.GuiKeyframeElement;
import mchorse.mclib.client.gui.framework.elements.keyframes.GuiSheet;
import mchorse.mclib.client.gui.framework.elements.keyframes.Selection;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.Scale;
import mchorse.mclib.client.gui.utils.ScrollDirection;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.keyframes.Keyframe;
import mchorse.mclib.utils.keyframes.KeyframeChannel;
import mchorse.mclib.utils.keyframes.KeyframeEasing;
import mchorse.mclib.utils.keyframes.KeyframeInterpolation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class GuiGraphView
extends GuiKeyframeElement {
    public GuiSheet sheet = new GuiSheet("main", IKey.str(""), 0, null);
    private Scale scaleY = new Scale(this.area, ScrollDirection.VERTICAL, true);

    public GuiGraphView(Minecraft mc, Consumer<Keyframe> callback) {
        super(mc, callback);
        this.scaleY.anchor(0.5f);
    }

    public Scale getScaleY() {
        return this.scaleY;
    }

    public void setChannel(KeyframeChannel channel, int color) {
        this.sheet.channel = channel;
        this.sheet.color = color;
        this.resetView();
    }

    public void setColor(int color) {
        this.sheet.color = color;
    }

    @Override
    public void setTick(double tick, boolean opposite) {
        if (this.isMultipleSelected()) {
            if (this.which == Selection.KEYFRAME) {
                tick = (long)tick;
            }
            this.sheet.setTick(tick - this.which.getX(this.getCurrent()), this.which, opposite);
        } else {
            this.which.setX(this.getCurrent(), tick, opposite);
        }
        this.sliding = true;
    }

    @Override
    public void setValue(double value, boolean opposite) {
        if (this.isMultipleSelected()) {
            this.sheet.setValue(value - this.which.getY(this.getCurrent()), this.which, opposite);
        } else {
            this.which.setY(this.getCurrent(), value, opposite);
        }
    }

    @Override
    public void setInterpolation(KeyframeInterpolation interp) {
        this.sheet.setInterpolation(interp);
    }

    @Override
    public void setEasing(KeyframeEasing easing) {
        this.sheet.setEasing(easing);
    }

    public int toGraphY(double value) {
        return (int)this.scaleY.to(value);
    }

    public double fromGraphY(int mouseY) {
        return this.scaleY.from(mouseY);
    }

    @Override
    public void resetView() {
        this.scaleX.set(0.0, 2.0);
        this.scaleY.set(0.0, 2.0);
        KeyframeChannel channel = this.sheet.channel;
        int c = channel.getKeyframes().size();
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        if (c > 1) {
            for (Keyframe frame : channel.getKeyframes()) {
                minX = Math.min(minX, (double)frame.tick);
                minY = Math.min(minY, frame.value);
                maxX = Math.max(maxX, (double)frame.tick);
                maxY = Math.max(maxY, frame.value);
            }
        } else {
            minX = 0.0;
            maxX = this.duration;
            minY = -10.0;
            maxY = 10.0;
            if (c == 1) {
                Keyframe first = channel.get(0);
                minX = Math.min(0L, first.tick);
                maxX = Math.max((long)this.duration, first.tick);
                minY = maxY = first.value;
            }
        }
        if (Math.abs(maxY - minY) < (double)0.01f) {
            this.scaleY.setShift(minY);
        } else {
            this.scaleY.viewOffset(minY, maxY, this.area.h, 20.0);
        }
        this.scaleX.viewOffset(minX, maxX, this.area.w, 20.0);
    }

    @Override
    public Keyframe getCurrent() {
        return this.sheet.getKeyframe();
    }

    @Override
    public List<GuiSheet> getSheets() {
        return ImmutableList.of((Object)this.sheet);
    }

    @Override
    public GuiSheet getSheet(int mouseY) {
        return this.sheet;
    }

    @Override
    public void selectAll() {
        this.sheet.selectAll();
        this.which = Selection.KEYFRAME;
        this.setKeyframe(this.getCurrent());
    }

    @Override
    public int getSelectedCount() {
        return this.sheet.getSelectedCount();
    }

    @Override
    public void clearSelection() {
        this.which = Selection.NOT_SELECTED;
        this.sheet.clearSelection();
    }

    @Override
    public void addCurrent(int mouseX, int mouseY) {
        long tick = (long)this.fromGraphX(mouseX);
        double value = this.fromGraphY(mouseY);
        KeyframeEasing easing = KeyframeEasing.IN;
        KeyframeInterpolation interp = KeyframeInterpolation.LINEAR;
        Keyframe frame = this.getCurrent();
        long oldTick = tick;
        if (frame != null) {
            easing = frame.easing;
            interp = frame.interp;
            oldTick = frame.tick;
        }
        this.sheet.selected.clear();
        this.sheet.selected.add(this.sheet.channel.insert(tick, value));
        if (oldTick != tick) {
            frame = this.getCurrent();
            frame.setEasing(easing);
            frame.setInterpolation(interp);
        }
    }

    @Override
    public void removeCurrent() {
        Keyframe frame = this.getCurrent();
        if (frame == null) {
            return;
        }
        this.sheet.channel.remove(this.sheet.selected.get(0));
        this.sheet.clearSelection();
        this.which = Selection.NOT_SELECTED;
    }

    @Override
    public void removeSelectedKeyframes() {
        this.sheet.removeSelectedKeyframes();
        this.setKeyframe(null);
        this.which = Selection.NOT_SELECTED;
    }

    @Override
    public void selectByDuration(long duration) {
        if (this.sheet.channel == null) {
            return;
        }
        int i = 0;
        this.sheet.selected.clear();
        for (Keyframe frame : this.sheet.channel.getKeyframes()) {
            if (frame.tick >= duration) {
                this.sheet.selected.add(i);
                break;
            }
            ++i;
        }
        this.setKeyframe(this.getCurrent());
    }

    @Override
    protected void duplicateKeyframe(GuiContext context, int mouseX, int mouseY) {
        this.sheet.duplicate((long)this.fromGraphX(mouseX));
        this.setKeyframe(this.getCurrent());
    }

    @Override
    protected boolean pickKeyframe(GuiContext context, int mouseX, int mouseY, boolean shift) {
        int index = 0;
        int count = this.sheet.channel.getKeyframes().size();
        Keyframe prev = null;
        for (Keyframe frame : this.sheet.channel.getKeyframes()) {
            boolean left = prev != null && prev.interp == KeyframeInterpolation.BEZIER && this.isInside((float)frame.tick - frame.lx, frame.value + (double)frame.ly, mouseX, mouseY);
            boolean right = frame.interp == KeyframeInterpolation.BEZIER && this.isInside((float)frame.tick + frame.rx, frame.value + (double)frame.ry, mouseX, mouseY) && index != count - 1;
            boolean point = this.isInside(frame.tick, frame.value, mouseX, mouseY);
            if (left || right || point) {
                Selection which;
                int key = this.sheet.selected.indexOf(index);
                if (!shift && key == -1) {
                    this.clearSelection();
                }
                Selection selection = left ? Selection.LEFT_HANDLE : (which = right ? Selection.RIGHT_HANDLE : Selection.KEYFRAME);
                if (!shift || which == this.which) {
                    this.which = which;
                    if (shift && this.isMultipleSelected() && key != -1) {
                        this.sheet.selected.remove(key);
                        frame = this.getCurrent();
                    } else if (key == -1) {
                        this.sheet.selected.add(index);
                        frame = this.isMultipleSelected() ? this.getCurrent() : frame;
                    } else {
                        frame = this.getCurrent();
                    }
                    this.setKeyframe(frame);
                }
                if (frame != null) {
                    double d = left ? (double)((float)frame.tick - frame.lx) : (this.lastT = (double)(right ? (float)frame.tick + frame.rx : (float)frame.tick));
                    this.lastV = left ? frame.value + (double)frame.ly : (right ? frame.value + (double)frame.ry : frame.value);
                }
                return true;
            }
            prev = frame;
            ++index;
        }
        return false;
    }

    private boolean isInside(double tick, double value, int mouseX, int mouseY) {
        int x = this.toGraphX(tick);
        int y = this.toGraphY(value);
        double d = Math.pow(mouseX - x, 2.0) + Math.pow(mouseY - y, 2.0);
        return d < 16.0;
    }

    @Override
    protected void setupScrolling(GuiContext context, int mouseX, int mouseY) {
        super.setupScrolling(context, mouseX, mouseY);
        this.lastV = this.scaleY.getShift();
    }

    @Override
    protected void zoom(int scroll, int mouseX, int mouseY) {
        boolean none;
        boolean x = GuiScreen.func_146272_n();
        boolean y = GuiScreen.func_146271_m();
        boolean bl = none = !x && !y;
        if (x && !y || none) {
            this.scaleX.setShift(this.scaleX.from(mouseX));
            this.scaleX.zoom(Math.copySign(this.scaleX.getZoomFactor(), (double)scroll), this.minZoom, this.maxZoom);
            this.scaleX.setShift(2.0 * this.scaleX.getShift() - this.scaleX.from(mouseX));
        }
        if (y && !x || none) {
            this.scaleY.setShift(this.scaleY.from(mouseY));
            this.scaleY.zoom(Math.copySign(this.scaleY.getZoomFactor(), (double)scroll), this.minZoom, this.maxZoom);
            this.scaleY.setShift(2.0 * this.scaleY.getShift() - this.scaleY.from(mouseY));
        }
    }

    @Override
    protected void postSlideSort(GuiContext context) {
        this.sheet.sort();
        this.sliding = false;
    }

    @Override
    protected void resetMouseReleased(GuiContext context) {
        if (this.isGrabbing()) {
            Area area = new Area();
            KeyframeChannel channel = this.sheet.channel;
            area.setPoints(this.lastX, this.lastY, context.mouseX, context.mouseY, 3);
            int c = channel.getKeyframes().size();
            for (int i = 0; i < c; ++i) {
                Keyframe keyframe = channel.get(i);
                if (!area.isInside(this.toGraphX(keyframe.tick), this.toGraphY(keyframe.value)) || this.sheet.selected.contains(i)) continue;
                this.sheet.selected.add(i);
            }
            if (!this.sheet.selected.isEmpty()) {
                this.which = Selection.KEYFRAME;
                this.setKeyframe(this.getCurrent());
            }
        }
        super.resetMouseReleased(context);
    }

    @Override
    protected void drawGrid(GuiContext context) {
        super.drawGrid(context);
        int ty = (int)this.fromGraphY(this.area.ey());
        int by = (int)this.fromGraphY(this.area.y - 12);
        int min = Math.min(ty, by) - 1;
        int max = Math.max(ty, by) + 1;
        int mult = this.scaleY.getMult();
        min -= min % mult + mult;
        max -= max % mult - mult;
        int c = (max - min) / mult;
        for (int j = 0; j < c; ++j) {
            int y = this.toGraphY(min + j * mult);
            if (y > this.area.ey()) continue;
            Gui.func_73734_a((int)this.area.x, (int)y, (int)this.area.ex(), (int)(y + 1), (int)0x44FFFFFF);
            this.font.func_78276_b(String.valueOf(min + j * mult), this.area.x + 4, y + 4, 0xFFFFFF);
        }
    }

    @Override
    protected void drawGraph(GuiContext context, int mouseX, int mouseY) {
        if (this.sheet.channel == null || this.sheet.channel.isEmpty()) {
            return;
        }
        BufferBuilder vb = Tessellator.func_178181_a().func_178180_c();
        KeyframeChannel channel = this.sheet.channel;
        COLOR.set(this.sheet.color, false);
        float r = GuiGraphView.COLOR.r;
        float g = GuiGraphView.COLOR.g;
        float b = GuiGraphView.COLOR.b;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        vb.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        int index = 0;
        int count = channel.getKeyframes().size();
        Keyframe prev = null;
        for (Keyframe frame : channel.getKeyframes()) {
            if (prev != null) {
                int px = this.toGraphX(prev.tick);
                int fx = this.toGraphX(frame.tick);
                if (prev.interp == KeyframeInterpolation.LINEAR) {
                    vb.func_181662_b((double)px, (double)this.toGraphY(prev.value), 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
                    vb.func_181662_b((double)fx, (double)this.toGraphY(frame.value), 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
                } else {
                    float seg = 10.0f;
                    if (prev.interp == KeyframeInterpolation.BOUNCE || prev.interp == KeyframeInterpolation.ELASTIC) {
                        seg = 30.0f;
                    }
                    int i = 0;
                    while ((float)i < seg) {
                        vb.func_181662_b((double)((float)px + (float)(fx - px) * ((float)i / seg)), (double)this.toGraphY(prev.interpolate(frame, (float)i / seg)), 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
                        vb.func_181662_b((double)((float)px + (float)(fx - px) * ((float)(i + 1) / seg)), (double)this.toGraphY(prev.interpolate(frame, (float)(i + 1) / seg)), 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
                        ++i;
                    }
                }
                if (prev.interp == KeyframeInterpolation.BEZIER) {
                    vb.func_181662_b((double)this.toGraphX((float)frame.tick - frame.lx), (double)this.toGraphY(frame.value + (double)frame.ly), 0.0).func_181666_a(r, g, b, 0.6f).func_181675_d();
                    vb.func_181662_b((double)this.toGraphX(frame.tick), (double)this.toGraphY(frame.value), 0.0).func_181666_a(r, g, b, 0.6f).func_181675_d();
                }
            }
            if (prev == null) {
                vb.func_181662_b(0.0, (double)this.toGraphY(frame.value), 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
                vb.func_181662_b((double)this.toGraphX(frame.tick), (double)this.toGraphY(frame.value), 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
            }
            if (frame.interp == KeyframeInterpolation.BEZIER && index != count - 1) {
                vb.func_181662_b((double)this.toGraphX(frame.tick), (double)this.toGraphY(frame.value), 0.0).func_181666_a(r, g, b, 0.6f).func_181675_d();
                vb.func_181662_b((double)this.toGraphX((float)frame.tick + frame.rx), (double)this.toGraphY(frame.value + (double)frame.ry), 0.0).func_181666_a(r, g, b, 0.6f).func_181675_d();
            }
            prev = frame;
            ++index;
        }
        vb.func_181662_b((double)this.toGraphX(prev.tick), (double)this.toGraphY(prev.value), 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        vb.func_181662_b((double)this.area.ex(), (double)this.toGraphY(prev.value), 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        vb.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        index = 0;
        prev = null;
        for (Keyframe frame : channel.getKeyframes()) {
            this.drawRect(vb, this.toGraphX(frame.tick), this.toGraphY(frame.value), 3, 0xFFFFFF);
            if (frame.interp == KeyframeInterpolation.BEZIER && index != count - 1) {
                this.drawRect(vb, this.toGraphX((float)frame.tick + frame.rx), this.toGraphY(frame.value + (double)frame.ry), 3, 0xFFFFFF);
            }
            if (prev != null && prev.interp == KeyframeInterpolation.BEZIER) {
                this.drawRect(vb, this.toGraphX((float)frame.tick - frame.lx), this.toGraphY(frame.value + (double)frame.ly), 3, 0xFFFFFF);
            }
            prev = frame;
            ++index;
        }
        index = 0;
        prev = null;
        for (Keyframe frame : channel.getKeyframes()) {
            boolean has = this.sheet.selected.contains(index);
            this.drawRect(vb, this.toGraphX(frame.tick), this.toGraphY(frame.value), 2, has && this.which == Selection.KEYFRAME ? 33023 : 0);
            if (frame.interp == KeyframeInterpolation.BEZIER && index != count - 1) {
                this.drawRect(vb, this.toGraphX((float)frame.tick + frame.rx), this.toGraphY(frame.value + (double)frame.ry), 2, has && this.which == Selection.RIGHT_HANDLE ? 33023 : 0);
            }
            if (prev != null && prev.interp == KeyframeInterpolation.BEZIER) {
                this.drawRect(vb, this.toGraphX((float)frame.tick - frame.lx), this.toGraphY(frame.value + (double)frame.ly), 2, has && this.which == Selection.LEFT_HANDLE ? 33023 : 0);
            }
            prev = frame;
            ++index;
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    @Override
    protected void scrolling(int mouseX, int mouseY) {
        super.scrolling(mouseX, mouseY);
        this.scaleY.setShift((double)(mouseY - this.lastY) / this.scaleY.getZoom() + this.lastV);
    }

    @Override
    protected Keyframe moving(GuiContext context, int mouseX, int mouseY) {
        Keyframe frame = this.getCurrent();
        double x = this.fromGraphX(mouseX);
        double y = this.fromGraphY(mouseY);
        if (this.which == Selection.NOT_SELECTED) {
            this.moveNoKeyframe(context, frame, x, y);
        } else {
            if (this.isMultipleSelected()) {
                int dx = mouseX - this.lastX;
                int dy = mouseY - this.lastY;
                int xx = this.toGraphX(this.lastT);
                int yy = this.toGraphY(this.lastV);
                x = this.fromGraphX(xx + dx);
                y = this.fromGraphY(yy + dy);
            }
            if (GuiScreen.func_146272_n()) {
                x = this.lastT;
            }
            if (GuiScreen.func_146271_m()) {
                y = this.lastV;
            }
            if (this.which == Selection.LEFT_HANDLE) {
                x = -(x - (double)frame.tick);
                y -= frame.value;
            } else if (this.which == Selection.RIGHT_HANDLE) {
                x -= (double)frame.tick;
                y -= frame.value;
            }
            this.setTick(x, !GuiScreen.func_175283_s());
            this.setValue(y, !GuiScreen.func_175283_s());
        }
        return frame;
    }
}

