/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.keyframes;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mchorse.mclib.client.gui.framework.elements.keyframes.GuiKeyframeElement;
import mchorse.mclib.client.gui.framework.elements.keyframes.GuiSheet;
import mchorse.mclib.client.gui.framework.elements.keyframes.Selection;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.utils.keyframes.Keyframe;
import mchorse.mclib.utils.keyframes.KeyframeEasing;
import mchorse.mclib.utils.keyframes.KeyframeInterpolation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class GuiDopeSheet
extends GuiKeyframeElement {
    public static final int TOP_MARGIN = 15;
    public List<GuiSheet> sheets = new ArrayList<GuiSheet>();

    public GuiDopeSheet(Minecraft mc, Consumer<Keyframe> callback) {
        super(mc, callback);
    }

    @Override
    public void setTick(double tick, boolean opposite) {
        if (this.isMultipleSelected()) {
            if (this.which == Selection.KEYFRAME) {
                tick = (long)tick;
            }
            double dx = tick - this.which.getX(this.getCurrent());
            for (GuiSheet sheet : this.sheets) {
                sheet.setTick(dx, this.which, opposite);
            }
        } else {
            this.which.setX(this.getCurrent(), tick, opposite);
        }
        this.sliding = true;
    }

    @Override
    public void setValue(double value, boolean opposite) {
        if (this.isMultipleSelected()) {
            double dy = value - this.which.getY(this.getCurrent());
            for (GuiSheet sheet : this.sheets) {
                sheet.setValue(dy, this.which, opposite);
            }
        } else {
            this.which.setY(this.getCurrent(), value, opposite);
        }
    }

    @Override
    public void setInterpolation(KeyframeInterpolation interp) {
        for (GuiSheet sheet : this.sheets) {
            sheet.setInterpolation(interp);
        }
    }

    @Override
    public void setEasing(KeyframeEasing easing) {
        for (GuiSheet sheet : this.sheets) {
            sheet.setEasing(easing);
        }
    }

    @Override
    public void resetView() {
        int c = 0;
        this.scaleX.set(0.0, 2.0);
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (GuiSheet sheet : this.sheets) {
            for (Keyframe frame : sheet.channel.getKeyframes()) {
                min = Integer.min((int)frame.tick, min);
                max = Integer.max((int)frame.tick, max);
            }
            c = Math.max(c, sheet.channel.getKeyframes().size());
        }
        if (c <= 1) {
            if (c == 0) {
                min = 0;
            }
            max = this.duration;
        }
        if ((float)Math.abs(max - min) > 0.01f) {
            this.scaleX.viewOffset(min, max, this.area.w, 20.0);
        }
    }

    @Override
    public Keyframe getCurrent() {
        GuiSheet current = this.getCurrentSheet();
        return current == null ? null : current.getKeyframe();
    }

    @Override
    public List<GuiSheet> getSheets() {
        return this.sheets;
    }

    @Override
    public GuiSheet getSheet(int mouseY) {
        int sheetCount = this.sheets.size();
        int h = (this.area.h - 15) / sheetCount;
        for (int i = 0; i < sheetCount; ++i) {
            GuiSheet sheet = this.sheets.get(i);
            int y = this.area.y + h * i + 15;
            if (mouseY < y || mouseY >= y + h) continue;
            return sheet;
        }
        return null;
    }

    @Override
    public void selectAll() {
        for (GuiSheet sheet : this.sheets) {
            sheet.selectAll();
        }
        this.which = Selection.KEYFRAME;
        this.setKeyframe(this.getCurrent());
    }

    public GuiSheet getCurrentSheet() {
        for (GuiSheet sheet : this.sheets) {
            if (sheet.selected.isEmpty()) continue;
            return sheet;
        }
        return null;
    }

    @Override
    public int getSelectedCount() {
        int i = 0;
        for (GuiSheet sheet : this.sheets) {
            i += sheet.getSelectedCount();
        }
        return i;
    }

    @Override
    public void clearSelection() {
        this.which = Selection.NOT_SELECTED;
        for (GuiSheet sheet : this.sheets) {
            sheet.clearSelection();
        }
    }

    @Override
    public void addCurrent(int mouseX, int mouseY) {
        long tick;
        int sheetCount = this.sheets.size();
        int h = (this.area.h - 15) / sheetCount;
        int i = (mouseY - (this.area.ey() - h * sheetCount)) / h;
        if (i < 0 || i >= sheetCount) {
            return;
        }
        GuiSheet sheet = this.sheets.get(i);
        KeyframeEasing easing = KeyframeEasing.IN;
        KeyframeInterpolation interp = KeyframeInterpolation.LINEAR;
        Keyframe frame = this.getCurrent();
        long oldTick = tick = (long)this.fromGraphX(mouseX);
        if (frame != null) {
            easing = frame.easing;
            interp = frame.interp;
            oldTick = frame.tick;
        }
        sheet.selected.clear();
        sheet.selected.add(sheet.channel.insert(tick, sheet.channel.interpolate(tick)));
        frame = this.getCurrent();
        if (oldTick != tick) {
            frame.setEasing(easing);
            frame.setInterpolation(interp);
        }
        this.addedDoubleClick(frame, tick, mouseX, mouseY);
    }

    protected void addedDoubleClick(Keyframe frame, long tick, int mouseX, int mouseY) {
    }

    @Override
    public void removeCurrent() {
        Keyframe frame = this.getCurrent();
        if (frame == null) {
            return;
        }
        GuiSheet current = this.getCurrentSheet();
        current.channel.remove(current.selected.get(0));
        current.selected.clear();
        this.which = Selection.NOT_SELECTED;
    }

    @Override
    public void removeSelectedKeyframes() {
        for (GuiSheet sheet : this.sheets) {
            sheet.removeSelectedKeyframes();
        }
        this.setKeyframe(null);
        this.which = Selection.NOT_SELECTED;
    }

    @Override
    protected void duplicateKeyframe(GuiContext context, int mouseX, int mouseY) {
        long offset = (long)this.fromGraphX(mouseX);
        for (GuiSheet sheet : this.sheets) {
            sheet.duplicate(offset);
        }
        this.setKeyframe(this.getCurrent());
    }

    @Override
    protected boolean pickKeyframe(GuiContext context, int mouseX, int mouseY, boolean shift) {
        int sheetCount = this.sheets.size();
        int h = (this.area.h - 15) / sheetCount;
        int y = this.area.ey() - h * sheetCount;
        boolean alt = GuiScreen.func_175283_s();
        boolean finished = false;
        boolean isMultiSelect = this.isMultipleSelected();
        for (GuiSheet sheet : this.sheets) {
            int index = 0;
            int count = sheet.channel.getKeyframes().size();
            Keyframe prev = null;
            for (Keyframe frame : sheet.channel.getKeyframes()) {
                boolean left = sheet.handles && prev != null && prev.interp == KeyframeInterpolation.BEZIER && this.isInside(this.toGraphX((float)frame.tick - frame.lx), y + h / 2, mouseX, mouseY);
                boolean right = sheet.handles && frame.interp == KeyframeInterpolation.BEZIER && this.isInside(this.toGraphX((float)frame.tick + frame.rx), y + h / 2, mouseX, mouseY) && index != count - 1;
                boolean point = this.isInside(this.toGraphX(frame.tick), alt ? (double)mouseY : (double)(y + h / 2), mouseX, mouseY);
                if (left || right || point) {
                    Selection which;
                    int key = sheet.selected.indexOf(index);
                    if (!shift && key == -1 && !alt) {
                        this.clearSelection();
                    }
                    Selection selection = left ? Selection.LEFT_HANDLE : (which = right ? Selection.RIGHT_HANDLE : Selection.KEYFRAME);
                    if (!shift || which == this.which) {
                        this.which = which;
                        if (shift && isMultiSelect && key != -1) {
                            sheet.selected.remove(key);
                            frame = this.getCurrent();
                        } else if (key == -1) {
                            sheet.selected.add(index);
                            frame = isMultiSelect ? this.getCurrent() : frame;
                        } else {
                            frame = this.getCurrent();
                        }
                        this.setKeyframe(frame);
                    }
                    if (frame != null) {
                        double d = left ? (double)((float)frame.tick - frame.lx) : (this.lastT = (double)(right ? (float)frame.tick + frame.rx : (float)frame.tick));
                        double d2 = left ? frame.value + (double)frame.ly : (this.lastV = right ? frame.value + (double)frame.ry : frame.value);
                    }
                    if (alt) {
                        if (frame != null) {
                            finished = true;
                        }
                    } else {
                        return true;
                    }
                }
                prev = frame;
                ++index;
            }
            y += h;
        }
        return finished;
    }

    private boolean isInside(double x, double y, int mouseX, int mouseY) {
        double d = Math.pow((double)mouseX - x, 2.0) + Math.pow((double)mouseY - y, 2.0);
        return Math.sqrt(d) < 4.0;
    }

    @Override
    protected void postSlideSort(GuiContext context) {
        for (GuiSheet sheet : this.sheets) {
            if (sheet.selected.isEmpty()) continue;
            sheet.sort();
        }
        this.sliding = false;
    }

    @Override
    protected void resetMouseReleased(GuiContext context) {
        if (this.isGrabbing()) {
            Area area = new Area();
            area.setPoints(this.lastX, this.lastY, context.mouseX, context.mouseY, 3);
            int count = this.sheets.size();
            int h = (this.area.h - 15) / count;
            int y = this.area.ey() - h * count;
            int c = 0;
            for (GuiSheet sheet : this.sheets) {
                int i = 0;
                for (Keyframe keyframe : sheet.channel.getKeyframes()) {
                    if (area.isInside(this.toGraphX(keyframe.tick), y + h / 2) && !sheet.selected.contains(i)) {
                        sheet.selected.add(i);
                        ++c;
                    }
                    ++i;
                }
                y += h;
            }
            if (c > 0) {
                this.which = Selection.KEYFRAME;
                this.setKeyframe(this.getCurrent());
            }
        }
        super.resetMouseReleased(context);
    }

    @Override
    protected void drawGraph(GuiContext context, int mouseX, int mouseY) {
        int sheetCount = this.sheets.size();
        int h = (this.area.h - 15) / sheetCount;
        int y = this.area.ey() - h * sheetCount;
        BufferBuilder vb = Tessellator.func_178181_a().func_178180_c();
        for (GuiSheet sheet : this.sheets) {
            COLOR.set(sheet.color, false);
            vb.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            vb.func_181662_b((double)this.area.x, (double)(y + h / 2), 0.0).func_181666_a(GuiDopeSheet.COLOR.r, GuiDopeSheet.COLOR.g, GuiDopeSheet.COLOR.b, 0.65f).func_181675_d();
            vb.func_181662_b((double)this.area.ex(), (double)(y + h / 2), 0.0).func_181666_a(GuiDopeSheet.COLOR.r, GuiDopeSheet.COLOR.g, GuiDopeSheet.COLOR.b, 0.65f).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            vb.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            int index = 0;
            int count = sheet.channel.getKeyframes().size();
            Keyframe prev = null;
            for (Keyframe frame : sheet.channel.getKeyframes()) {
                this.drawRect(vb, this.toGraphX(frame.tick), y + h / 2, 3, sheet.hasSelected(index) ? 0xFFFFFF : sheet.color);
                if (frame.interp == KeyframeInterpolation.BEZIER && sheet.handles && index != count - 1) {
                    this.drawRect(vb, this.toGraphX((float)frame.tick + frame.rx), y + h / 2, 2, sheet.hasSelected(index) ? 0xFFFFFF : sheet.color);
                }
                if (prev != null && prev.interp == KeyframeInterpolation.BEZIER && sheet.handles) {
                    this.drawRect(vb, this.toGraphX((float)frame.tick - frame.lx), y + h / 2, 2, sheet.hasSelected(index) ? 0xFFFFFF : sheet.color);
                }
                prev = frame;
                ++index;
            }
            index = 0;
            prev = null;
            for (Keyframe frame : sheet.channel.getKeyframes()) {
                this.drawRect(vb, this.toGraphX(frame.tick), y + h / 2, 2, this.which == Selection.KEYFRAME && sheet.hasSelected(index) ? 33023 : 0);
                if (frame.interp == KeyframeInterpolation.BEZIER && sheet.handles && index != count - 1) {
                    this.drawRect(vb, this.toGraphX((float)frame.tick + frame.rx), y + h / 2, 1, this.which == Selection.RIGHT_HANDLE && sheet.hasSelected(index) ? 33023 : 0);
                }
                if (prev != null && prev.interp == KeyframeInterpolation.BEZIER && sheet.handles) {
                    this.drawRect(vb, this.toGraphX((float)frame.tick - frame.lx), y + h / 2, 1, this.which == Selection.LEFT_HANDLE && sheet.hasSelected(index) ? 33023 : 0);
                }
                prev = frame;
                ++index;
            }
            Tessellator.func_178181_a().func_78381_a();
            int lw = this.font.func_78256_a(sheet.title.get()) + 10;
            GuiDraw.drawHorizontalGradientRect(this.area.ex() - lw - 10, y, this.area.ex(), y + h, sheet.color, -1442840576 + sheet.color, 0.0f);
            this.font.func_175063_a(sheet.title.get(), (float)(this.area.ex() - lw + 5), (float)(y + (h - this.font.field_78288_b) / 2 + 1), 0xFFFFFF);
            GlStateManager.func_179090_x();
            y += h;
        }
    }

    @Override
    protected Keyframe moving(GuiContext context, int mouseX, int mouseY) {
        Keyframe frame = this.getCurrent();
        double x = this.fromGraphX(mouseX);
        if (this.which == Selection.NOT_SELECTED) {
            this.moveNoKeyframe(context, frame, x, 0.0);
        } else {
            if (this.isMultipleSelected()) {
                int dx = mouseX - this.lastX;
                int xx = this.toGraphX(this.lastT);
                x = this.fromGraphX(xx + dx);
            }
            if (this.which == Selection.LEFT_HANDLE) {
                x = (int)(-(x - (double)frame.tick));
            } else if (this.which == Selection.RIGHT_HANDLE) {
                x = (long)((int)x) - frame.tick;
            }
            this.setTick(x, !GuiScreen.func_175283_s());
        }
        return frame;
    }
}

