/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.buttons;

import java.util.function.Consumer;
import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiClickElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiContextMenu;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.framework.elements.utils.GuiInventoryElement;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.network.mclib.Dispatcher;
import mchorse.mclib.network.mclib.common.PacketDropItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.ResourceLocation;

public class GuiSlotElement
extends GuiClickElement<ItemStack> {
    public static final ResourceLocation SHIELD = new ResourceLocation("minecraft:textures/items/empty_armor_slot_shield.png");
    public static final ResourceLocation BOOTS = new ResourceLocation("minecraft:textures/items/empty_armor_slot_boots.png");
    public static final ResourceLocation LEGGINGS = new ResourceLocation("minecraft:textures/items/empty_armor_slot_leggings.png");
    public static final ResourceLocation CHESTPLATE = new ResourceLocation("minecraft:textures/items/empty_armor_slot_chestplate.png");
    public static final ResourceLocation HELMET = new ResourceLocation("minecraft:textures/items/empty_armor_slot_helmet.png");
    public GuiInventoryElement inventory;
    public final int slot;
    private ItemStack stack = ItemStack.field_190927_a;
    public boolean drawDisabled = true;
    public int lastSlot;

    public GuiSlotElement(Minecraft mc, int slot, Consumer<ItemStack> callback) {
        super(mc, callback);
        this.slot = slot;
        this.inventory = new GuiInventoryElement(mc, this);
        this.flex().wh(24, 24);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.lastSlot = -1;
        this.stack = stack.func_77946_l();
        if (this.inventory.hasParent()) {
            this.inventory.updateInventory();
        }
    }

    public void acceptStack(ItemStack stack, int slot) {
        this.lastSlot = slot;
        this.stack = stack.func_77946_l();
        if (this.callback != null) {
            this.callback.accept(stack);
        }
    }

    @Override
    public GuiContextMenu createContextMenu(GuiContext context) {
        if (this.contextMenu == null) {
            return this.createDefaultSlotContextMenu();
        }
        return super.createContextMenu(context);
    }

    public GuiSimpleContextMenu createDefaultSlotContextMenu() {
        GuiSimpleContextMenu menu = new GuiSimpleContextMenu(this.mc).action(Icons.COPY, IKey.lang("mclib.gui.item_slot.context.copy"), this::copyNBT);
        try {
            ItemStack stack = new ItemStack(JsonToNBT.func_180713_a((String)GuiScreen.func_146277_j()));
            if (!stack.func_190926_b()) {
                menu.action(Icons.PASTE, IKey.lang("mclib.gui.item_slot.context.paste"), () -> this.pasteItem(stack));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return menu.action(Icons.DOWNLOAD, IKey.lang("mclib.gui.item_slot.context.drop"), this::dropItem).action(Icons.CLOSE, IKey.lang("mclib.gui.item_slot.context.clear"), this::clearItem);
    }

    private void copyNBT() {
        if (!this.stack.func_190926_b()) {
            GuiScreen.func_146275_d((String)this.stack.serializeNBT().toString());
        }
    }

    private void pasteItem(ItemStack stack) {
        this.acceptStack(stack, -1);
    }

    private void dropItem() {
        if (!this.stack.func_190926_b()) {
            Dispatcher.sendToServer(new PacketDropItem(this.stack));
        }
    }

    private void clearItem() {
        this.acceptStack(ItemStack.field_190927_a, -1);
    }

    @Override
    protected void click(int mouseButton) {
        this.inventory.removeFromParent();
        GuiContext context = GuiBase.getCurrent();
        this.inventory.flex().relative(context.screen.root).xy(0.5f, 0.5f).anchor(0.5f, 0.5f);
        this.inventory.resize();
        this.inventory.updateInventory();
        context.screen.root.add((IGuiElement)this.inventory);
    }

    @Override
    protected ItemStack get() {
        return this.stack;
    }

    @Override
    protected void drawSkin(GuiContext context) {
        int border;
        int n = border = this.inventory.hasParent() ? -16777216 + (Integer)McLib.primaryColor.get() : -1;
        if (((Boolean)McLib.enableBorders.get()).booleanValue()) {
            Gui.func_73734_a((int)(this.area.x + 1), (int)this.area.y, (int)(this.area.ex() - 1), (int)this.area.ey(), (int)-16777216);
            Gui.func_73734_a((int)this.area.x, (int)(this.area.y + 1), (int)this.area.ex(), (int)(this.area.ey() - 1), (int)-16777216);
            Gui.func_73734_a((int)(this.area.x + 1), (int)(this.area.y + 1), (int)(this.area.ex() - 1), (int)(this.area.ey() - 1), (int)border);
            Gui.func_73734_a((int)(this.area.x + 2), (int)(this.area.y + 2), (int)(this.area.ex() - 2), (int)(this.area.ey() - 2), (int)-3750202);
        } else {
            Gui.func_73734_a((int)this.area.x, (int)this.area.y, (int)this.area.ex(), (int)this.area.ey(), (int)border);
            Gui.func_73734_a((int)(this.area.x + 1), (int)(this.area.y + 1), (int)(this.area.ex() - 1), (int)(this.area.ey() - 1), (int)-3750202);
        }
        int x = this.area.mx() - 8;
        int y = this.area.my() - 8;
        if (this.stack.func_190926_b() && this.slot != 0) {
            GlStateManager.func_179141_d();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.slot == 1) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(SHIELD);
            } else if (this.slot == 2) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(BOOTS);
            } else if (this.slot == 3) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(LEGGINGS);
            } else if (this.slot == 4) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(CHESTPLATE);
            } else if (this.slot == 5) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(HELMET);
            }
            Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        } else {
            RenderHelper.func_74520_c();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179126_j();
            GuiInventoryElement.drawItemStack(this.stack, x, y, null);
            if (this.area.isInside(context)) {
                context.tooltip.set(context, this);
            }
            GlStateManager.func_179097_i();
            RenderHelper.func_74518_a();
        }
        if (this.drawDisabled) {
            GuiDraw.drawLockedArea(this, (Boolean)McLib.enableBorders.get() != false ? 1 : 0);
        }
    }

    @Override
    public void drawTooltip(GuiContext context, Area area) {
        super.drawTooltip(context, area);
        GuiInventoryElement.drawItemTooltip(this.stack, this.mc.field_71439_g, this.font, context.mouseX, context.mouseY);
        GlStateManager.func_179140_f();
    }
}

