/*
 * Decompiled with CFR 0.152.
 */
package toraylife.mappetextras.modules.utils.render;

import java.util.List;
import mchorse.mappet.api.npcs.NpcState;
import mchorse.mappet.entities.EntityNpc;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class NpcPathRenderer {
    private static final int PATH_COLOR = 0xFFFFFF;
    private static final float PATH_ALPHA = 0.5f;
    private static final float PATH_WIDTH = 2.0f;

    public boolean shouldRenderDebugPath() {
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        return settings.field_74330_P && !settings.field_74319_N && Minecraft.func_71410_x().field_71439_g.func_184812_l_();
    }

    public void renderNpcPaths(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        float partialTicks = event.getPartialTicks();
        for (Entity entity : mc.field_71441_e.field_72996_f) {
            if (!(entity instanceof EntityNpc)) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179097_i();
            this.renderPathForNpc((EntityNpc)entity, player, partialTicks);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    private void renderPathForNpc(EntityNpc npc, EntityPlayerSP player, float partialTicks) {
        NpcState state = npc.getState();
        if (state == null) {
            return;
        }
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        if (entity == null) {
            return;
        }
        double x = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double y = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double z = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        this.drawPathLines(x, y, z, state.patrol);
        this.drawPatrolCirculateLine(x, y, z, state);
        this.drawPatrolCubes(x, y, z, state.patrol);
    }

    private void drawPatrolCubes(double x, double y, double z, List<BlockPos> patrol) {
        for (BlockPos pos : patrol) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
            GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
            RenderGlobal.func_189695_b((double)0.4f, (double)0.0, (double)0.4f, (double)0.6f, (double)0.2f, (double)0.6f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            GlStateManager.func_179121_F();
        }
    }

    private void drawPatrolCirculateLine(double x, double y, double z, NpcState state) {
        if (((Boolean)state.patrolCirculate.get()).booleanValue() && state.patrol.size() > 2) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            GL11.glLineWidth((float)2.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
            BlockPos pos1 = (BlockPos)state.patrol.get(0);
            BlockPos pos2 = (BlockPos)state.patrol.get(state.patrol.size() - 1);
            this.drawPos(buffer, pos1);
            this.drawPos(buffer, pos2);
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
    }

    private void drawPathLines(double x, double y, double z, List<BlockPos> patrol) {
        BlockPos tempPos = null;
        for (BlockPos pos : patrol) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
            if (tempPos != null) {
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
                GL11.glLineWidth((float)2.0f);
                this.drawPos(buffer, tempPos);
                this.drawPos(buffer, pos);
                tessellator.func_78381_a();
            }
            tempPos = pos;
            GlStateManager.func_179121_F();
        }
    }

    private void drawPos(BufferBuilder buffer, BlockPos pos) {
        buffer.func_181662_b((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.5f)).func_181666_a(1.6777215E7f, 1.6777215E7f, 1.6777215E7f, 0.5f).func_181675_d();
    }
}

