/*
 * Decompiled with CFR 0.152.
 */
package toraylife.mappetextras.modules.utils.network;

import io.netty.buffer.ByteBuf;
import mchorse.mappet.CommonProxy;
import mchorse.mappet.api.scripts.ScriptExecutionFork;
import mchorse.mappet.api.utils.IExecutable;
import mchorse.mclib.network.ServerMessageHandler;
import mchorse.mclib.utils.OpHelper;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import toraylife.mappetextras.MappetExtras;
import toraylife.mappetextras.modules.utils.dimensions.Dimension;

public class PacketRegistrationDimension
implements IMessage {
    public String id;
    public boolean unregister = false;

    public PacketRegistrationDimension() {
    }

    public PacketRegistrationDimension(Dimension data) {
        this.id = data.getId();
    }

    public PacketRegistrationDimension(String id) {
        this.id = id;
    }

    public PacketRegistrationDimension(String id, boolean unregister) {
        this.id = id;
        this.unregister = unregister;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.unregister = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.id);
        buf.writeBoolean(this.unregister);
    }

    public static class ServerHandler
    extends ServerMessageHandler<PacketRegistrationDimension> {
        public void run(EntityPlayerMP player, PacketRegistrationDimension message) {
            CommonProxy.eventHandler.addExecutable((IExecutable)new ScriptExecutionFork(null, a -> {
                Dimension dimension = (Dimension)MappetExtras.customDimensionManager.load(message.id);
                if (!OpHelper.isPlayerOp((EntityPlayerMP)player) || dimension == null) {
                    return;
                }
                try {
                    if (message.unregister) {
                        dimension.unregister();
                    } else {
                        dimension.register();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    player.func_146105_b((ITextComponent)new TextComponentString("\u00a7cError: " + e.getMessage()), false);
                }
            }, 5));
        }
    }
}

