/*
 * Decompiled with CFR 0.152.
 */
package toraylife.mappetextras.modules.utils.mixins.late.scriptPanel;

import javax.script.ScriptException;
import mchorse.mappet.client.gui.GuiMappetDashboard;
import mchorse.mappet.client.gui.panels.GuiMappetDashboardPanel;
import mchorse.mappet.client.gui.panels.GuiScriptPanel;
import mchorse.mappet.client.gui.scripts.GuiTextEditor;
import mchorse.mappet.client.gui.utils.text.GuiMultiTextElement;
import mchorse.mappet.client.gui.utils.text.undo.TextEditUndo;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.Direction;
import mchorse.mclib.utils.undo.IUndo;
import net.minecraft.client.Minecraft;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import toraylife.mappetextras.modules.utils.MPEIcons;
import toraylife.mappetextras.modules.utils.UtilsModule;
import toraylife.mappetextras.modules.utils.client.Beautifier;
import toraylife.mappetextras.modules.utils.client.BeautifierOptions;
import toraylife.mappetextras.modules.utils.client.gui.codeEditor.GuiTextEditorSearchable;
import toraylife.mappetextras.modules.utils.client.gui.codeEditor.SearchPanel;

@Mixin(value={GuiScriptPanel.class}, remap=false)
public abstract class MixinGuiScriptPanel
extends GuiMappetDashboardPanel {
    @Shadow
    public GuiTextEditor code;
    public GuiIconElement searchIcon;
    public GuiIconElement beautifierIcon;
    public SearchPanel search;

    public MixinGuiScriptPanel(Minecraft mc, GuiMappetDashboard dashboard) {
        super(mc, dashboard);
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>"}, remap=false)
    public void inject(Minecraft mc, GuiMappetDashboard dashboard, CallbackInfo ci) {
        this.search = new SearchPanel(mc, this.code);
        float verticalShift = (Boolean)UtilsModule.getInstance().codeSearchOnTop.get() != false ? 0.0f : 1.0f;
        this.search.flex().relative((GuiElement)this.code).xy(1.0f, verticalShift).anchor(1.0f, verticalShift).wh(160, 80);
        this.search.setVisible(false);
        this.editor.add((IGuiElement)this.search);
        this.code.keys().ignoreFocus().register(IKey.lang((String)"mappetextras.utils.codesearch.search_and_replace"), 33, this.search::toggleSearch).category(GuiMappetDashboardPanel.KEYS_CATEGORY).held(new int[]{29});
        this.code.keys().ignoreFocus().register(IKey.lang((String)"mappetextras.utils_module.beautify"), 38, () -> this.onBeautifierAction(this.code)).category(GuiMappetDashboardPanel.KEYS_CATEGORY).held(new int[]{29}).held(new int[]{56});
        this.searchIcon = new GuiIconElement(mc, MPEIcons.FOOD_PIPE, b -> this.search.toggleSearch());
        this.searchIcon.setVisible(this.data != null && this.allowed && this.code.isVisible());
        this.searchIcon.tooltip(IKey.lang((String)"mappetextras.utils.codesearch.search_and_replace"), Direction.LEFT);
        this.beautifierIcon = new GuiIconElement(mc, MPEIcons.CLOTHES_FAVOUR, b -> this.onBeautifierAction(this.code));
        this.beautifierIcon.setVisible(this.data != null && this.allowed && this.code.isVisible() && UtilsModule.getInstance().beautifier != null);
        this.beautifierIcon.setEnabled(UtilsModule.getInstance().beautifier.engine != null);
        this.beautifierIcon.disabledColor(-7864320);
        this.beautifierIcon.tooltip(IKey.lang((String)"mappetextras.utils_module.beautify"), Direction.LEFT);
        this.iconBar.add((IGuiElement)this.searchIcon);
        this.iconBar.add((IGuiElement)this.beautifierIcon);
    }

    @Inject(method={"updateButtons"}, at={@At(value="TAIL")}, remap=false)
    public void updateButtons(CallbackInfo ci) {
        if (this.searchIcon != null) {
            this.searchIcon.setVisible(this.data != null && this.allowed && this.code.isVisible());
        }
        if (this.beautifierIcon != null) {
            this.beautifierIcon.setVisible(this.data != null && this.allowed && this.code.isVisible() && UtilsModule.getInstance().beautifier != null);
            this.beautifierIcon.setEnabled(UtilsModule.getInstance().beautifier.engine != null);
            this.beautifierIcon.disabledColor(-7864320);
        }
    }

    private void onBeautifierAction(GuiTextEditor editor) {
        String formattedCode = "";
        if (UtilsModule.getInstance().beautifier == null) {
            return;
        }
        try {
            UtilsModule module = UtilsModule.getInstance();
            BeautifierOptions options = Beautifier.getOptions((Boolean)module.beautifierIndentEmptyLines.get(), (Boolean)module.beautifierUnindentChainedMethods.get(), (Boolean)module.beautifierBreakChainedMethods.get());
            formattedCode = UtilsModule.getInstance().beautifier.beautify(editor.getText(), options);
        }
        catch (NoSuchMethodException | ScriptException e) {
            e.printStackTrace();
        }
        if (formattedCode.isEmpty()) {
            return;
        }
        editor.selectAll();
        TextEditUndo undo = new TextEditUndo((GuiMultiTextElement)editor);
        editor.deleteSelection();
        editor.writeString(formattedCode);
        undo.ready().post(editor.getText(), editor.cursor, editor.selection);
        ((GuiTextEditorSearchable)editor).getUndo().pushUndo((IUndo)undo);
    }
}

