/*
 * Decompiled with CFR 0.152.
 */
package toraylife.mappetextras.modules.utils.dimensions;

import java.io.File;
import java.util.Collection;
import mchorse.mappet.api.utils.manager.BaseManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.DimensionType;
import toraylife.mappetextras.modules.utils.UtilsModule;
import toraylife.mappetextras.modules.utils.dimensions.Dimension;
import toraylife.mappetextras.modules.utils.dimensions.FlatDimensionProvider;
import toraylife.mappetextras.modules.utils.dimensions.VoidDimensionProvider;

public class CustomDimensionManager
extends BaseManager<Dimension> {
    public static DimensionType voidDimensionType;
    public static DimensionType flatDimensionType;

    public CustomDimensionManager(File folder) {
        super(folder);
        try {
            voidDimensionType = DimensionType.register((String)"Void", (String)"_mpe_void", (int)((Integer)UtilsModule.getInstance().voidDimensionId.get()), VoidDimensionProvider.class, (boolean)true);
            flatDimensionType = DimensionType.register((String)"Flat", (String)"_mpe_flat", (int)((Integer)UtilsModule.getInstance().flatDimensionId.get()), FlatDimensionProvider.class, (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register dimension types. Try change dimension type id's in config", e);
        }
    }

    protected Dimension createData(String id, NBTTagCompound tag) {
        Dimension dimension = new Dimension();
        if (tag != null) {
            dimension.deserializeNBT(tag);
        }
        return dimension;
    }

    public void registerDimensions() {
        Collection keys = this.getKeys();
        for (String key : keys) {
            Dimension dimension = (Dimension)this.load(key);
            if (dimension == null || !((Boolean)dimension.initializeOnStartup.get()).booleanValue()) continue;
            try {
                dimension.register();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

