/*
 * Decompiled with CFR 0.152.
 */
package toraylife.mappetextras.modules.utils.client.gui.panels;

import java.util.ArrayList;
import mchorse.mappet.api.utils.AbstractData;
import mchorse.mappet.api.utils.IContentType;
import mchorse.mappet.client.gui.GuiMappetDashboard;
import mchorse.mappet.client.gui.panels.GuiMappetDashboardPanel;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiCirculateElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldProviderSurface;
import toraylife.mappetextras.modules.utils.ContentType;
import toraylife.mappetextras.modules.utils.MPEIcons;
import toraylife.mappetextras.modules.utils.dimensions.Dimension;
import toraylife.mappetextras.modules.utils.dimensions.FlatDimensionProvider;
import toraylife.mappetextras.modules.utils.dimensions.VoidDimensionProvider;
import toraylife.mappetextras.modules.utils.network.PacketChangeDimension;
import toraylife.mappetextras.modules.utils.network.PacketRegistrationDimension;
import toraylife.mappetextras.network.Dispatcher;

public class DimensionsPanel
extends GuiMappetDashboardPanel<Dimension> {
    public GuiTrackpadElement dimensionId;
    public GuiToggleElement initializeOnStartup;
    public GuiCirculateElement worldProvider;
    public GuiElement settings;
    public GuiIconElement tpToDimension;
    public GuiIconElement tpToOverworld;
    public GuiIconElement registerDimension;
    public GuiIconElement unregisterDimension;

    public DimensionsPanel(Minecraft mc, GuiMappetDashboard dashboard) {
        super(mc, dashboard);
        this.namesList.setFileIcon(Icons.SPHERE);
        this.dimensionId = new GuiTrackpadElement(mc, t -> ((Dimension)this.data).dimensionId.set((Number)t.intValue()));
        this.initializeOnStartup = new GuiToggleElement(mc, IKey.lang((String)"mappetextras.gui.dimensions.initializeOnStartup"), b -> ((Dimension)this.data).initializeOnStartup.set((Object)b.isToggled()));
        this.worldProvider = new GuiCirculateElement(mc, this::setWorldProvider);
        for (String provider : this.getWorldProviders()) {
            this.worldProvider.addLabel(IKey.str((String)provider.substring(provider.lastIndexOf(".") + 1)));
        }
        this.settings = Elements.column((Minecraft)mc, (int)10, (int)10, (GuiElement[])new GuiElement[]{Elements.label((IKey)IKey.lang((String)"mappetextras.gui.dimensions.id")), this.dimensionId, this.initializeOnStartup, Elements.label((IKey)IKey.lang((String)"mappetextras.gui.dimensions.worldProvider")), this.worldProvider});
        this.settings.flex().relative(this.editor).wh(0.5f, 1.0f);
        this.editor.add((IGuiElement)this.settings);
        this.tpToDimension = new GuiIconElement(mc, Icons.SHIFT_FORWARD, icon -> Dispatcher.sendToServer(new PacketChangeDimension((Integer)((Dimension)this.data).dimensionId.get())));
        this.tpToDimension.tooltip(IKey.lang((String)"mappetextras.utils.dimensions.tpToDimension"));
        this.tpToOverworld = new GuiIconElement(mc, Icons.SHIFT_BACKWARD, icon -> Dispatcher.sendToServer(new PacketChangeDimension(0)));
        this.tpToOverworld.tooltip(IKey.lang((String)"mappetextras.utils.dimensions.tpToOverworld"));
        this.registerDimension = new GuiIconElement(mc, MPEIcons.PAINT_PENCIL, icon -> {
            this.save();
            Dispatcher.sendToServer(new PacketRegistrationDimension(((Dimension)this.data).getId()));
        });
        this.registerDimension.tooltip(IKey.lang((String)"mappetextras.utils.dimensions.registerDimension"));
        this.registerDimension.disabledColor(-7864320);
        this.unregisterDimension = new GuiIconElement(mc, MPEIcons.PAINT_ERASER, icon -> Dispatcher.sendToServer(new PacketRegistrationDimension(((Dimension)this.data).getId(), true)));
        this.unregisterDimension.tooltip(IKey.lang((String)"mappetextras.utils.dimensions.unregisterDimension"));
        this.iconBar.add(new IGuiElement[]{this.tpToDimension, this.tpToOverworld, this.registerDimension, this.unregisterDimension});
        this.fill(this.data);
    }

    public void fill(Dimension data, boolean allowed) {
        super.fill((AbstractData)data, allowed);
        this.settings.setVisible(data != null);
        this.tpToDimension.setVisible(data != null);
        this.tpToOverworld.setVisible(data != null);
        this.registerDimension.setVisible(data != null);
        this.unregisterDimension.setVisible(data != null);
        if (data == null) {
            return;
        }
        this.dimensionId.setValue((double)((Integer)data.dimensionId.get()).intValue());
        this.initializeOnStartup.toggled(((Boolean)data.initializeOnStartup.get()).booleanValue());
        this.worldProvider.setValue(this.getWorldProviders().indexOf(data.worldProvider.getClass().getName()));
    }

    public void setWorldProvider(GuiCirculateElement guiCirculateElement) {
        try {
            String name = this.getWorldProviders().get(guiCirculateElement.getValue());
            ((Dimension)this.data).worldProvider = (WorldProvider)Class.forName(name).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public IContentType getType() {
        return ContentType.DIMENSION;
    }

    public String getTitle() {
        return "mappetextras.gui.panels.dimensions";
    }

    public ArrayList<String> getWorldProviders() {
        ArrayList<String> worldProviders = new ArrayList<String>();
        worldProviders.add(WorldProviderSurface.class.getName());
        worldProviders.add(WorldProviderHell.class.getName());
        worldProviders.add(WorldProviderEnd.class.getName());
        worldProviders.add(FlatDimensionProvider.class.getName());
        worldProviders.add(VoidDimensionProvider.class.getName());
        return worldProviders;
    }
}

