/*
 * Decompiled with CFR 0.152.
 */
package toraylife.mappetextras.modules.utils.client.gui.codeEditor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mchorse.mappet.client.gui.scripts.GuiTextEditor;
import mchorse.mappet.client.gui.utils.text.GuiMultiTextElement;
import mchorse.mappet.client.gui.utils.text.undo.TextEditUndo;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icon;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.undo.IUndo;
import net.minecraft.client.Minecraft;
import toraylife.mappetextras.modules.utils.MPEIcons;
import toraylife.mappetextras.modules.utils.UtilsModule;
import toraylife.mappetextras.modules.utils.client.gui.codeEditor.GuiTextEditorSearchable;

public class SearchPanel
extends GuiElement {
    public GuiTextElement search;
    public GuiIconElement searchIcon;
    public GuiTextElement replace;
    public GuiIconElement replaceIcon;
    public GuiIconElement closeIcon;
    public GuiIconElement regexIcon;
    public GuiIconElement ignoreCaseIcon;
    public GuiIconElement replaceAllIcon;
    public String searchString = "";
    public String replaceString = "";
    public GuiTextEditor code;
    public boolean regex = false;
    public boolean replaceAll = false;
    public boolean ignoreCase = false;
    public final int COLOR_ON = -16711936;
    public final int COLOR_OFF = -7829368;

    public SearchPanel(Minecraft mc, GuiTextEditor code) {
        super(mc);
        this.code = code;
        this.closeIcon = new GuiIconElement(mc, Icons.CLOSE, b -> this.toggleSearch());
        this.closeIcon.tooltip(IKey.lang((String)"mappetextras.utils.codesearch.close"));
        this.regexIcon = new GuiIconElement(mc, MPEIcons.EMOJI_STUCKOUTTONGUE, b -> {
            this.toggleIcon((GuiIconElement)b, MPEIcons.EMOJI_COOL, MPEIcons.EMOJI_STUCKOUTTONGUE);
            this.regex = b.iconColor == -16711936;
        }).iconColor(-7829368).hoverColor(-7829368).hovered(Icons.GRAPH);
        this.regexIcon.tooltip(IKey.lang((String)"mappetextras.utils.codesearch.regex"));
        this.ignoreCaseIcon = new GuiIconElement(mc, MPEIcons.KEY_CAPSLOCK, b -> {
            this.toggleIcon((GuiIconElement)b, MPEIcons.KEY_CAPSLOCK, MPEIcons.KEY_CAPSLOCK);
            this.ignoreCase = b.iconColor == -16711936;
        }).iconColor(-7829368).hoverColor(-7829368);
        this.ignoreCaseIcon.tooltip(IKey.lang((String)"mappetextras.utils.codesearch.ignore_case"));
        this.replaceAllIcon = new GuiIconElement(mc, Icons.ALL_DIRECTIONS, b -> {
            this.toggleIcon((GuiIconElement)b, Icons.ALL_DIRECTIONS, Icons.ALL_DIRECTIONS);
            this.replaceAll = b.iconColor == -16711936;
        }).iconColor(-7829368).hoverColor(-7829368);
        this.replaceAllIcon.tooltip(IKey.lang((String)"mappetextras.utils.codesearch.replace_all"));
        GuiElement rowIcons = Elements.row((Minecraft)mc, (int)5, (GuiElement[])new GuiElement[]{Elements.row((Minecraft)mc, (int)5, (GuiElement[])new GuiElement[]{this.regexIcon, this.ignoreCaseIcon, this.replaceAllIcon}), this.closeIcon});
        this.search = new GuiTextElement(mc, s -> {
            this.searchString = s;
        });
        this.searchIcon = new GuiIconElement(mc, Icons.SEARCH, b -> this.search(this.code));
        this.searchIcon.tooltip(IKey.lang((String)"mappetextras.utils.codesearch.search"));
        GuiElement rowSearch = Elements.row((Minecraft)mc, (int)2, (GuiElement[])new GuiElement[]{this.search, this.searchIcon});
        rowSearch.flex().relative((GuiElement)this).x(5).y(0.33f, 5).w(1.0f, -10).h(0.33f, -10);
        this.replace = new GuiTextElement(mc, s -> {
            this.replaceString = s;
        });
        this.replaceIcon = new GuiIconElement(mc, Icons.REVERSE, b -> this.replace(this.code));
        this.replaceIcon.tooltip(IKey.lang((String)"mappetextras.utils.codesearch.replace"));
        GuiElement rowReplace = Elements.row((Minecraft)mc, (int)2, (GuiElement[])new GuiElement[]{this.replace, this.replaceIcon});
        rowReplace.flex().relative((GuiElement)this).x(5).y(0.66f, 5).w(1.0f, -10).h(0.33f, -10);
        GuiElement column = Elements.column((Minecraft)mc, (int)5, (int)5, (GuiElement[])new GuiElement[]{rowIcons, rowSearch, rowReplace});
        column.flex().relative((GuiElement)this).wh(1.0f, 1.0f);
        this.add((IGuiElement)column);
    }

    public void draw(GuiContext context) {
        this.area.draw(((Integer)UtilsModule.getInstance().codeSearchBackgroundColor.get()).intValue());
        super.draw(context);
        if (!this.search.field.func_146206_l() && this.search.field.func_146179_b().isEmpty()) {
            this.font.func_175063_a(IKey.lang((String)"mappetextras.utils.codesearch.search").get(), (float)(this.search.area.x + 5), (float)(this.search.area.y + 6), 0x888888);
        }
        if (!this.replace.field.func_146206_l() && this.replace.field.func_146179_b().isEmpty()) {
            this.font.func_175063_a(IKey.lang((String)"mappetextras.utils.codesearch.replace").get(), (float)(this.replace.area.x + 5), (float)(this.replace.area.y + 6), 0x888888);
        }
    }

    public void search(GuiTextEditor code) {
        String codeText = code.getText();
        int caseSensitive = this.ignoreCase ? 2 : 0;
        Pattern pattern = Pattern.compile(this.searchString, caseSensitive + (this.regex ? 8 : 16));
        ((GuiTextEditorSearchable)code).setPattern(pattern);
    }

    public void replace(GuiTextEditor code) {
        String codeText = code.getText();
        int caseSensitive = this.ignoreCase ? 2 : 0;
        Pattern pattern = Pattern.compile(this.searchString, caseSensitive + (this.regex ? 8 : 16));
        Matcher matcher = pattern.matcher(codeText);
        this.code.selectAll();
        TextEditUndo undo = new TextEditUndo((GuiMultiTextElement)this.code);
        this.code.deleteSelection();
        code.writeString(this.replaceAll ? matcher.replaceAll(this.replaceString) : matcher.replaceFirst(this.replaceString));
        undo.ready().post(code.getText(), this.code.cursor, this.code.selection);
        ((GuiTextEditorSearchable)this.code).getUndo().pushUndo((IUndo)undo);
    }

    public void toggleSearch() {
        this.setVisible(!this.isVisible());
        ((GuiTextEditorSearchable)this.code).setSearching(this.isVisible());
    }

    public void toggleIcon(GuiIconElement icon, Icon iconOn, Icon iconOff) {
        icon.iconColor(icon.iconColor == -16711936 ? -7829368 : -16711936);
        icon.hoverColor(icon.hoverColor == -16711936 ? -7829368 : -16711936);
        icon.icon(icon.icon == iconOff ? iconOn : iconOff);
    }
}

