/*
 * Decompiled with CFR 0.152.
 */
package toraylife.mappetextras.modules.scripting.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import mchorse.chameleon.animation.ActionConfig;
import mchorse.chameleon.animation.Animator;
import mchorse.chameleon.metamorph.ChameleonMorph;
import mchorse.mclib.network.ClientMessageHandler;
import mchorse.metamorph.api.models.IMorphProvider;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.capabilities.morphing.Morphing;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import toraylife.mappetextras.modules.main.utils.ReflectionUtils;

public class PacketPlayAnimation
implements IMessage {
    String animation;
    String uuid;

    public PacketPlayAnimation(String animation, String uuid) {
        this.animation = animation;
        this.uuid = uuid;
    }

    public PacketPlayAnimation() {
    }

    public void fromBytes(ByteBuf buf) {
        this.animation = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.uuid = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.animation);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.uuid);
    }

    public static class ClientHandler
    extends ClientMessageHandler<PacketPlayAnimation> {
        @SideOnly(value=Side.CLIENT)
        public void run(EntityPlayerSP player, PacketPlayAnimation message) {
            player.field_70170_p.func_72910_y().stream().filter(entity -> entity.func_110124_au().equals(UUID.fromString(message.uuid))).forEach(entity -> {
                AbstractMorph morph = this.getMorph((Entity)entity);
                if (!(morph instanceof ChameleonMorph)) {
                    return;
                }
                ChameleonMorph chameleonMorph = (ChameleonMorph)morph;
                Animator animator = (Animator)ReflectionUtils.getAndInvokeMethod(ChameleonMorph.class, "getAnimator", chameleonMorph);
                ActionConfig config = chameleonMorph.actions.getConfig(message.animation);
                animator.addAction(animator.createAction(animator.animation, config, false));
            });
        }

        public AbstractMorph getMorph(Entity entity) {
            if (entity instanceof IMorphProvider) {
                return ((IMorphProvider)entity).getMorph();
            }
            if (entity instanceof EntityPlayer) {
                return Morphing.get((EntityPlayer)((EntityPlayer)entity)).getCurrentMorph();
            }
            return null;
        }
    }
}

