/*
 * Decompiled with CFR 0.152.
 */
package toraylife.mappetextras.modules.scripting.mixins.late;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import mchorse.blockbuster.common.tileentity.TileEntityModel;
import mchorse.mappet.api.scripts.code.ScriptWorld;
import mchorse.mappet.api.scripts.code.blocks.ScriptTileEntity;
import mchorse.mappet.api.scripts.user.blocks.IScriptTileEntity;
import mchorse.mappet.api.scripts.user.data.ScriptVector;
import mchorse.mappet.tile.TileConditionModel;
import mchorse.mappet.tile.TileEmitter;
import mchorse.mappet.tile.TileTrigger;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.io.FileUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import toraylife.mappetextras.modules.main.mixins.utils.MixinTargetName;
import toraylife.mappetextras.modules.scripting.scripts.code.blocks.ScriptConditionModelTileEntity;
import toraylife.mappetextras.modules.scripting.scripts.code.blocks.ScriptEmitterTileEntity;
import toraylife.mappetextras.modules.scripting.scripts.code.blocks.ScriptModelTileEntity;
import toraylife.mappetextras.modules.scripting.scripts.code.blocks.ScriptTriggerTileEntity;

@Mixin(value={ScriptWorld.class}, remap=false)
@MixinTargetName(value="mchorse.mappet.api.scripts.user.IScriptWorld")
public abstract class MixinScriptWorld {
    @Shadow
    private World world;
    @Shadow
    private BlockPos.MutableBlockPos pos;

    @Shadow
    public abstract int getDimensionId();

    public String getBiome(int x, int y, int z) {
        return this.world.func_180494_b(new BlockPos(x, y, z)).func_185359_l();
    }

    public String getBiome(ScriptVector pos) {
        return this.getBiome((int)pos.x, (int)pos.y, (int)pos.z);
    }

    @Inject(method={"getTileEntity"}, at={@At(value="RETURN", opcode=1)}, remap=false, cancellable=true)
    public void getTileEntity(int x, int y, int z, CallbackInfoReturnable<IScriptTileEntity> cir) {
        HashMap<Class, Class> tiles = new HashMap<Class, Class>();
        tiles.put(TileTrigger.class, ScriptTriggerTileEntity.class);
        tiles.put(TileEmitter.class, ScriptEmitterTileEntity.class);
        tiles.put(TileConditionModel.class, ScriptConditionModelTileEntity.class);
        tiles.put(TileEntityModel.class, ScriptModelTileEntity.class);
        TileEntity tileEntity = this.world.func_175625_s((BlockPos)this.pos.func_181079_c(x, y, z));
        Class<?> tileEntityClass = tileEntity.getClass();
        Class scriptTileEntityClass = (Class)tiles.get(tileEntityClass);
        try {
            if (scriptTileEntityClass != null) {
                Constructor constructor = scriptTileEntityClass.getConstructor(tileEntityClass);
                IScriptTileEntity scriptTileEntity = (IScriptTileEntity)constructor.newInstance(tileEntity);
                cir.setReturnValue((Object)scriptTileEntity);
            } else {
                cir.setReturnValue((Object)new ScriptTileEntity(tileEntity));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getLight(int x, int y, int z) {
        return this.world.func_175699_k(new BlockPos(x, y, z));
    }

    public int getLight(ScriptVector vector) {
        return this.world.func_175699_k(new BlockPos(vector.x, vector.y, vector.z));
    }

    public int getLight(int x, int y, int z, boolean checkNeighbors) {
        return this.world.func_175721_c(new BlockPos(x, y, z), checkNeighbors);
    }

    public int getLight(ScriptVector vector, boolean checkNeighbors) {
        return this.world.func_175721_c(new BlockPos(vector.x, vector.y, vector.z), checkNeighbors);
    }

    public boolean isChunkLoaded(int x, int z) {
        if (this.world instanceof WorldServer) {
            return ((WorldServer)this.world).func_72863_F().func_73149_a(x >> 4, z >> 4);
        }
        return this.world.func_72863_F().func_186026_b(x >> 4, z >> 4) != null;
    }

    public void loadChunk(int x, int z) {
        if (this.world instanceof WorldServer) {
            ((WorldServer)this.world).func_72863_F().func_186028_c(x, z);
        }
        this.world.func_72863_F().func_186025_d(x, z);
    }

    public void delete() throws IllegalAccessException, IOException {
        int dimensionId = this.getDimensionId();
        if (dimensionId == 0 || dimensionId == -1 || dimensionId == 1) {
            throw new IllegalAccessException("Cannot delete the vanilla dimension!");
        }
        String subfolder = DimensionManager.getProvider((int)dimensionId).getSaveFolder();
        File folder = new File(DimensionManager.getCurrentSaveRootDirectory(), subfolder == null ? "" : subfolder);
        FileUtils.deleteDirectory((File)folder);
        DimensionManager.unregisterDimension((int)dimensionId);
    }
}

