/*
 * Decompiled with CFR 0.152.
 */
package toraylife.mappetextras.modules.scripting.mixins.late;

import mchorse.mappet.api.scripts.user.data.ScriptVector;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import toraylife.mappetextras.modules.main.mixins.utils.MixinTargetName;

@Mixin(value={ScriptVector.class}, remap=false)
@MixinTargetName(value="mchorse.mappet.api.scripts.user.data.ScriptVector")
public abstract class MixinScriptVector {
    @Shadow
    public double x;
    @Shadow
    public double y;
    @Shadow
    public double z;

    public double dotProduct(ScriptVector vector) {
        return this.x * vector.x + this.y * vector.y + this.z * vector.z;
    }

    public ScriptVector crossProduct(ScriptVector vector) {
        return new ScriptVector(this.y * vector.z - this.z * vector.y, this.z * vector.x - this.x * vector.z, this.x * vector.y - this.y * vector.x);
    }

    public ScriptVector toRotations(ScriptVector vector) {
        ScriptVector subtractVector = new ScriptVector(this.x, this.y, this.z).subtract(vector);
        double hypotenuse = Math.sqrt(Math.pow(subtractVector.x, 2.0) + Math.pow(subtractVector.z, 2.0));
        double pitch = Math.atan2(hypotenuse, subtractVector.y) * 180.0 / Math.PI;
        double yaw = -Math.atan2(subtractVector.x, subtractVector.z) * 180.0 / Math.PI;
        return new ScriptVector(pitch, yaw, 0.0);
    }

    public double getAngle(ScriptVector vector) {
        return Math.acos(this.dotProduct(vector));
    }

    public ScriptVector rotate(double pitch, double yaw) {
        ScriptVector normalizeVector = new ScriptVector(this.x, this.y, this.z).normalize();
        double radiansPitch = Math.toRadians(-pitch);
        double radiansYaw = Math.toRadians(-yaw);
        double x = normalizeVector.x;
        double y = normalizeVector.y * Math.cos(radiansPitch) - normalizeVector.z * Math.sin(radiansPitch);
        double z = normalizeVector.y * Math.sin(radiansPitch) + normalizeVector.z * Math.cos(radiansPitch);
        return new ScriptVector(x * Math.cos(radiansYaw) + z * Math.sin(radiansYaw), y, x * -Math.sin(radiansYaw) + z * Math.cos(radiansYaw));
    }

    public ScriptVector interpolation(ScriptVector vector, double coefficient) {
        if (coefficient < 0.0 || coefficient > 1.0) {
            return null;
        }
        return new ScriptVector(this.x + (vector.x - this.x) * coefficient, this.y + (vector.y - this.y) * coefficient, this.z + (vector.z - this.z) * coefficient);
    }

    public ScriptVector vectorMultiply(ScriptVector vector) {
        return new ScriptVector(this.x * vector.x, this.y * vector.y, this.z * vector.z);
    }

    public ScriptVector divide(ScriptVector vector) {
        return new ScriptVector(this.x / vector.x, this.y / vector.y, this.z / vector.z);
    }

    public ScriptVector copy() {
        return new ScriptVector(this.x, this.y, this.z);
    }

    public boolean equals(ScriptVector vector) {
        return this.x == vector.x && this.y == vector.y && this.z == vector.z;
    }

    public boolean equals(double x, double y, double z) {
        return this.x == x && this.y == y && this.z == z;
    }

    public double distance(ScriptVector vector) {
        double dx = this.x - vector.x;
        double dy = this.y - vector.y;
        double dz = this.z - vector.z;
        return Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0) + Math.pow(dz, 2.0));
    }

    public double distance(double x, double y, double z) {
        double dx = this.x - x;
        double dy = this.y - y;
        double dz = this.z - z;
        return Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0) + Math.pow(dz, 2.0));
    }

    public ScriptVector getVectorForRotation(double pitch, double yaw) {
        double f = Math.cos(-yaw * 0.017453292 - Math.PI);
        double f1 = Math.sin(-yaw * 0.017453292 - Math.PI);
        double f2 = -Math.cos(-pitch * 0.017453292);
        double f3 = Math.sin(-pitch * 0.017453292);
        return new ScriptVector(f1 * f2, f3, f * f2);
    }
}

