/*
 * Decompiled with CFR 0.152.
 */
package toraylife.mappetextras.modules.scripting.mixins.late;

import java.nio.file.Paths;
import java.util.Set;
import java.util.UUID;
import mchorse.mappet.api.scripts.code.ScriptFactory;
import mchorse.mappet.api.scripts.code.ScriptServer;
import mchorse.mappet.api.scripts.code.ScriptWorld;
import mchorse.mappet.api.scripts.code.blocks.ScriptTileEntity;
import mchorse.mappet.api.scripts.code.items.ScriptInventory;
import mchorse.mappet.api.scripts.user.IScriptServer;
import mchorse.mappet.api.scripts.user.IScriptWorld;
import mchorse.mappet.api.scripts.user.blocks.IScriptTileEntity;
import mchorse.mappet.api.scripts.user.items.IScriptInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import org.spongepowered.asm.mixin.Mixin;
import toraylife.mappetextras.capabilities.minecraftHUD.MinecraftHUD;
import toraylife.mappetextras.modules.main.mixins.utils.MixinTargetName;
import toraylife.mappetextras.modules.scripting.scripts.code.ScriptFile;
import toraylife.mappetextras.modules.scripting.scripts.code.ScriptMath;
import toraylife.mappetextras.modules.scripting.scripts.code.conditions.ScriptConditionFactory;
import toraylife.mappetextras.modules.scripting.scripts.code.triggers.ScriptTriggerFactory;
import toraylife.mappetextras.modules.scripting.scripts.user.IScriptFile;
import toraylife.mappetextras.modules.scripting.scripts.user.IScriptMath;
import toraylife.mappetextras.modules.scripting.utils.Constants;

@Mixin(value={ScriptFactory.class}, remap=false)
@MixinTargetName(value="mchorse.mappet.api.scripts.user.IScriptFactory")
public abstract class MixinScriptFactory {
    public ScriptTriggerFactory getTriggerFactory() {
        return new ScriptTriggerFactory();
    }

    public ScriptConditionFactory getConditionFactory() {
        return new ScriptConditionFactory();
    }

    public IScriptFile getWorldDir() {
        return new ScriptFile(DimensionManager.getCurrentSaveRootDirectory().toPath());
    }

    public IScriptFile getMinecraftDir() {
        return new ScriptFile(Paths.get(".", new String[0]));
    }

    public IScriptFile createPath(String path) {
        return new ScriptFile(Paths.get(path, new String[0]));
    }

    public IScriptWorld getMappetWorld(World minecraftWorld) {
        return new ScriptWorld(minecraftWorld);
    }

    public IScriptServer getMappetServer(MinecraftServer minecraftServer) {
        return new ScriptServer(minecraftServer);
    }

    public IScriptTileEntity getMappetTileEntity(TileEntity minecraftTileEntity) {
        return new ScriptTileEntity(minecraftTileEntity);
    }

    public IScriptInventory getMappetInventory(IInventory minecraftInventory) {
        return new ScriptInventory(minecraftInventory);
    }

    public String getClassName(Object value) {
        String classes = value.getClass().toString();
        int beginIndex = classes.lastIndexOf(".") + 1;
        return classes.substring(beginIndex);
    }

    public IScriptMath getMath() {
        return new ScriptMath();
    }

    public String createUniqueId() {
        return UUID.randomUUID().toString();
    }

    public Constants getConstants() {
        return new Constants();
    }

    public Set<String> getAllMinecraftHUDs() {
        return new MinecraftHUD().HUDs.keySet();
    }
}

