/*
 * Decompiled with CFR 0.152.
 */
package toraylife.mappetextras.modules.scripting.mixins.late;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.ScriptException;
import mchorse.mappet.CommonProxy;
import mchorse.mappet.api.scripts.code.entities.ScriptEntity;
import mchorse.mappet.api.scripts.code.entities.ScriptPlayer;
import mchorse.mappet.api.utils.IExecutable;
import mchorse.mappet.utils.RunnableExecutionFork;
import mchorse.mclib.utils.Interpolation;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ITeleporter;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import toraylife.mappetextras.modules.main.mixins.utils.MixinTargetName;
import toraylife.mappetextras.modules.scripting.network.PacketPlayAnimation;
import toraylife.mappetextras.network.Dispatcher;

@Mixin(value={ScriptEntity.class}, remap=false)
@MixinTargetName(value="mchorse.mappet.api.scripts.user.entities.IScriptEntity")
public abstract class MixinScriptEntity<T extends Entity> {
    @Shadow
    protected T entity;

    @Shadow
    public abstract void setRotations(float var1, float var2, float var3);

    @Shadow
    public abstract AbstractMorph getMorph();

    public int getAge() {
        return ((Entity)this.entity).field_70173_aa;
    }

    public void setGlowing(boolean glowing) {
        this.entity.func_184195_f(glowing);
    }

    public boolean isGlowing() {
        return this.entity.func_184202_aL();
    }

    public boolean isSpectated(ScriptPlayer player) {
        return this.entity.func_174827_a(player.getMinecraftPlayer());
    }

    public void rotateTo(String interpolation, int durationTicks, float pitch, float yaw, float yawHead) {
        Interpolation interp = Interpolation.valueOf((String)interpolation.toUpperCase());
        float startPitch = ((Entity)this.entity).field_70125_A;
        float startYaw = ((Entity)this.entity).field_70177_z;
        float startYawHead = this.entity.func_70079_am();
        for (int i = 0; i < durationTicks; ++i) {
            float progress = (float)i / (float)durationTicks;
            float interpPitch = interp.interpolate(startPitch, pitch, progress);
            float interpYaw = interp.interpolate(startYaw, yaw, progress);
            float interpYawHead = interp.interpolate(startYawHead, yawHead, progress);
            CommonProxy.eventHandler.addExecutable((IExecutable)new RunnableExecutionFork(i, () -> this.setRotations(interpPitch, interpYaw, interpYawHead)));
        }
    }

    public void jump() {
        ((EntityLiving)this.entity).func_70683_ar().func_75660_a();
    }

    public boolean isChild() {
        return ((EntityLivingBase)this.entity).func_70631_g_();
    }

    public boolean isDead() {
        return ((Entity)this.entity).field_70128_L;
    }

    public boolean isSilent() {
        return this.entity.func_174814_R();
    }

    public void setSilent(boolean silent) {
        this.entity.func_174810_b(silent);
    }

    public boolean isAttackable() {
        return ((EntityLivingBase)this.entity).func_190631_cK();
    }

    public boolean isAlive() {
        return this.entity.func_70089_S();
    }

    public boolean isUndead() {
        return ((EntityLivingBase)this.entity).func_70662_br();
    }

    public float getFallDistance() {
        return ((Entity)this.entity).field_70143_R;
    }

    public float getAIMoveSpeed() {
        return ((EntityLivingBase)this.entity).func_70689_ay();
    }

    public void setAIMoveSpeed(float speed) {
        ((EntityLivingBase)this.entity).func_70659_e(speed);
    }

    public void setNoClip(boolean clip) {
        ((Entity)this.entity).field_70145_X = clip;
    }

    public boolean getNoClip() {
        return ((Entity)this.entity).field_70145_X;
    }

    public void damage(float health, String damageType) {
        if (this.entity instanceof EntityLivingBase) {
            return;
        }
        this.entity.func_70097_a(new DamageSource(damageType.toUpperCase()), health);
    }

    public void setSprinting(boolean sprinting) {
        this.entity.func_70031_b(sprinting);
    }

    public void setSneaking(boolean sneaking) {
        this.entity.func_70095_a(sneaking);
    }

    public String getFacing() {
        return this.entity.func_174811_aO().func_176610_l();
    }

    public boolean isWalking() {
        return ((Entity)this.entity).field_70141_P - ((Entity)this.entity).field_70140_Q != 0.0f;
    }

    public int getEntityWorldId() {
        return this.entity.func_145782_y();
    }

    @Overwrite
    public void setDimension(int dimension) throws ScriptException {
        if (((Entity)this.entity).field_71093_bK != dimension) {
            if (DimensionManager.isDimensionRegistered((int)dimension)) {
                MinecraftServer minecraftServer = this.entity.func_184102_h();
                WorldServer worldServer = minecraftServer.func_71218_a(dimension);
                Teleporter teleporter = new Teleporter(worldServer){

                    public void func_180266_a(Entity entityIn, float rotationYaw) {
                    }

                    public boolean func_180620_b(Entity entityIn, float rotationYaw) {
                        return false;
                    }
                };
                if (this.entity instanceof EntityPlayerMP) {
                    EntityPlayerMP player = (EntityPlayerMP)this.entity;
                    minecraftServer.func_184103_al().transferPlayerToDimension(player, dimension, teleporter);
                } else {
                    this.entity.changeDimension(dimension, (ITeleporter)teleporter);
                }
            } else {
                List values = ((Stream)DimensionManager.getRegisteredDimensions().values().stream().parallel()).flatMapToInt(e -> Arrays.stream(e.toIntArray())).boxed().collect(Collectors.toList());
                throw new ScriptException("Registered dimensions: " + Arrays.toString(values.toArray()));
            }
        }
    }

    public void playAnimation(String animation) {
        PacketPlayAnimation packet = new PacketPlayAnimation(animation, this.entity.func_110124_au().toString());
        Dispatcher.sendToTracked(this.entity, packet);
        if (this.entity instanceof EntityPlayerMP) {
            Dispatcher.sendTo(packet, (EntityPlayerMP)this.entity);
        }
    }
}

