/*
 * Decompiled with CFR 0.152.
 */
package toraylife.mappetextras.modules.main.documentation;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mchorse.mappet.client.gui.scripts.GuiDocumentationOverlayPanel;
import mchorse.mappet.client.gui.scripts.utils.documentation.DocClass;
import mchorse.mappet.client.gui.scripts.utils.documentation.DocEntry;
import mchorse.mappet.client.gui.scripts.utils.documentation.DocMethod;
import mchorse.mappet.client.gui.utils.overlays.GuiOverlay;
import mchorse.mappet.client.gui.utils.overlays.GuiOverlayPanel;
import mchorse.mappet.client.gui.utils.text.GuiText;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import toraylife.mappetextras.modules.utils.MPEIcons;

public class ClassLinkManager {
    private static final Pattern CLASS_PATTERN = Pattern.compile("\u00a76(.+?)(\u00a7r|$)");
    private static final Pattern CLASS_METHOD_PATTERN = Pattern.compile("\u00a76(.+?)\u00a7r\\.\u00a77(.+?)\\(.*?\\)\u00a7r");
    private final Minecraft mc;

    public ClassLinkManager(Minecraft mc) {
        this.mc = mc;
    }

    public Set<String> parseLinks(String text) {
        HashSet<String> links = new HashSet<String>();
        this.findMatches(text, CLASS_PATTERN, links, false);
        this.findMatches(text, CLASS_METHOD_PATTERN, links, true);
        return links;
    }

    private void findMatches(String text, Pattern pattern, Set<String> matches, boolean methodsFlag) {
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            matches.add(methodsFlag ? matcher.group(1) + "." + matcher.group(2) : matcher.group(1));
        }
    }

    public Set<DocEntry> getEntries(Set<String> links) {
        HashSet<DocEntry> entries = new HashSet<DocEntry>();
        for (String link : links) {
            DocEntry entry = this.findEntry(link);
            if (entry == null) continue;
            entries.add(entry);
        }
        return entries;
    }

    private DocEntry findEntry(String link) {
        String[] parts = link.split("\\.");
        String className = parts[0];
        String methodName = parts.length > 1 ? parts[1] : "";
        for (DocClass docClass : GuiDocumentationOverlayPanel.docs.classes) {
            if (!docClass.getName().equals(className)) continue;
            if (methodName.isEmpty()) {
                return docClass;
            }
            for (DocMethod method : docClass.methods) {
                if (!method.name.equals(methodName)) continue;
                return method;
            }
        }
        return null;
    }

    private GuiSimpleContextMenu createContextMenu(Set<DocEntry> entries) {
        GuiSimpleContextMenu menu = new GuiSimpleContextMenu(this.mc);
        for (DocEntry entry : entries) {
            String key = (entry instanceof DocMethod ? entry.parent.getName() + "." : "") + entry.getName();
            menu.action(MPEIcons.OTHER_GLOSARY, IKey.format((String)"mappet.gui.scripts.context.docs", (Object[])new Object[]{key}), () -> this.openOverlay(entry), 0xFFAA00);
        }
        return menu;
    }

    private void openOverlay(DocEntry entry) {
        GuiDocumentationOverlayPanel overlay = new GuiDocumentationOverlayPanel(this.mc, entry);
        GuiOverlay.addOverlay((GuiContext)GuiBase.getCurrent(), (GuiOverlayPanel)overlay, (float)0.9f, (float)0.9f);
    }

    public void addLinks(GuiText text, Set<DocEntry> searched) {
        GuiSimpleContextMenu contextMenu = this.createContextMenu(searched);
        text.context(() -> contextMenu);
    }
}

