/*
 * Decompiled with CFR 0.152.
 */
package toraylife.mappetextras.modules.main;

import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import toraylife.mappetextras.MappetExtras;
import toraylife.mappetextras.modules.main.MainModule;
import toraylife.mappetextras.modules.main.client.gui.VersionChangelogScreen;

@SideOnly(value=Side.CLIENT)
public class VersionChecker
extends Thread {
    public ForgeVersion.CheckResult getVersionCheckResult() {
        FMLCommonHandler.instance().findContainerFor((Object)MappetExtras.instance);
        ModContainer modContainer = (ModContainer)Loader.instance().getIndexedModList().get("mappetextras");
        return ForgeVersion.getResult((ModContainer)modContainer);
    }

    public ITextComponent getUpdateMessage() {
        final ForgeVersion.CheckResult result = this.getVersionCheckResult();
        TextComponentString message = new TextComponentString("");
        String messageKey = "mappetextras.main_module.update";
        switch (result.status) {
            case UP_TO_DATE: {
                IKey lang = IKey.format((String)(messageKey + ".up_to_date"), (Object[])new Object[]{"MappetExtras"});
                message.func_150258_a(lang.get());
                break;
            }
            case OUTDATED: {
                String newVersion = result.target != null ? result.target.toString() : "";
                IKey lang = IKey.format((String)(messageKey + ".outdated"), (Object[])new Object[]{"MappetExtras", newVersion, "1.4.3-nz"});
                message.func_150258_a(lang.get());
                TextComponentString viewChangelogString = new TextComponentString(IKey.lang((String)(messageKey + ".outdated_view")).get());
                viewChangelogString.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, ""){

                    public ClickEvent.Action func_150669_a() {
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)new VersionChangelogScreen(result));
                        return super.func_150669_a();
                    }
                });
                TextComponentString tooltip = new TextComponentString(IKey.lang((String)(messageKey + ".outdated_tooltip")).get());
                viewChangelogString.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)tooltip));
                message.func_150257_a((ITextComponent)viewChangelogString);
                break;
            }
            default: {
                IKey lang = IKey.format((String)(messageKey + ".failed"), (Object[])new Object[]{"MappetExtras"});
                message.func_150258_a(lang.get());
            }
        }
        return message;
    }

    public static void sendMessage(EntityPlayer player, boolean ignoreSettings) {
        if (!ignoreSettings && !((Boolean)MainModule.getInstance().showVersionUpdateMessage.get()).booleanValue()) {
            return;
        }
        VersionChecker checker = new VersionChecker();
        ForgeVersion.CheckResult versionCheckResult = checker.getVersionCheckResult();
        if (!ignoreSettings && ((Boolean)MainModule.getInstance().showUpdateOnlyIfOutdated.get()).booleanValue() && versionCheckResult.status != ForgeVersion.Status.OUTDATED) {
            return;
        }
        ITextComponent message = checker.getUpdateMessage();
        player.func_145747_a(message);
    }

    @Override
    public void run() {
        EntityPlayerSP player;
        while ((player = Minecraft.func_71410_x().field_71439_g) == null) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException exception) {
                exception.printStackTrace();
            }
        }
        VersionChecker.sendMessage((EntityPlayer)player, false);
    }
}

