/*
 * Decompiled with CFR 0.152.
 */
package toraylife.mappetextras.modules.client.providers;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import toraylife.mappetextras.modules.client.ClientData;
import toraylife.mappetextras.modules.client.providers.IClientDataProvider;

public class SettingProvider
implements IClientDataProvider {
    boolean dev = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    String[] keys = new String[]{"keyBindAdvancements", "keyBindAttack", "keyBindBack", "keyBindChat", "keyBindCommand", "keyBindDrop", "keyBindForward", "keyBindFullscreen", "keyBindInventory", "keyBindJump", "keyBindLeft", "keyBindLoadToolbar", "keyBindPickBlock", "keyBindPlayerList", "keyBindRight", "keyBindSaveToolbar", "keyBindScreenshot", "keyBindsHotbar", "keyBindSmoothCamera", "keyBindSneak", "keyBindSpectatorOutlines", "keyBindSprint", "keyBindSwapHands", "keyBindTogglePerspective", "keyBindUseItem", "thirdPersonView", "advancedItemTooltips", "ambientOcclusion", "anaglyph", "attackIndicator", "autoJump", "chatColours", "chatHeightUnfocused", "chatLinks", "chatLinksPromp", "chatOpacity", "chatScale", "chatVisibility", "chatWidth", "clouds", "debugCamEnable", "difficulty", "enableVsync", "enableWeakAttacks", "entityShadows", "fancyGraphics", "fboEnable", "forceUnicodeFont", "fovSetting", "fullScreen", "gammaSetting", "guiScale", "heldItemTooltips", "hideGUI", "hideServerAddress", "incompatibleResourcePacks", "invertMouse", "language", "lastServer", "limitFramerate", "mainHand", "mipmapLevels", "mouseSensitivity", "narrator", "overrideHeight", "overrideWidth", "particleSetting", "pauseOnLostFocus", "realmsNotifications", "reducedDebugInfo", "renderDistanceChunks", "resourcePacks", "saturation", "showDebugInfo", "showDebugProfilerChart", "showLagometer", "showSubtitles", "smoothCamera", "snooperEnabled", "touchscreen", "tutorialStep", "useNativeTransport", "useVbo", "viewBobbing"};
    String[] fields = new String[]{"field_194146_ao", "field_74312_F", "field_74368_y", "field_74310_D", "field_74323_J", "field_74316_C", "field_74351_w", "field_152395_am", "field_151445_Q", "field_74314_A", "field_74370_x", "field_193630_aq", "field_74322_I", "field_74321_H", "field_74366_z", "field_193629_ap", "field_151447_Z", "field_151456_ac", "field_151458_ab", "field_74311_E", "field_178883_an", "field_151444_V", "field_186718_X", "field_151457_aa", "field_74313_G", "field_74320_O", "field_82882_x", "field_74348_k", "field_74337_g", "field_186716_M", "field_189989_R", "field_74344_o", "field_96693_G", "field_74359_p", "field_74358_q", "field_74357_r", "field_96691_E", "field_74343_n", "field_96692_F", "field_74345_l", "field_74325_U", "field_74318_M", "field_74352_v", "field_189422_N", "field_181151_V", "field_74347_j", "field_151448_g", "field_151455_aw", "field_74334_X", "field_74353_u", "field_74333_Y", "field_74335_Z", "field_92117_D", "field_74319_N", "field_80005_w", "field_183018_l", "field_74338_d", "field_74363_ab", "field_74332_R", "field_74350_i", "field_186715_A", "field_151442_I", "field_74341_c", "field_192571_R", "field_92119_C", "field_92118_B", "field_74362_aa", "field_82881_y", "field_183509_X", "field_178879_v", "field_151451_c", "field_151453_l", "field_151452_as", "field_74330_P", "field_74329_Q", "field_181657_aC", "field_186717_N", "field_74326_T", "field_74355_t", "field_85185_A", "field_193631_S", "field_181150_U", "field_178881_t", "field_74336_f"};

    @Override
    public NBTTagCompound getData(NBTTagCompound data) {
        Object value;
        String key = data.func_74779_i("key");
        SettingType type = key.startsWith("keyBind") ? SettingType.KEYBIND : SettingType.NORMAL;
        GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
        if (type == SettingType.KEYBIND) {
            String output = key.replace("keyBind", "");
            output = Character.toLowerCase(output.charAt(0)) + output.substring(1);
            value = gameSettings.field_74324_K[this.getKeyBindIndex(gameSettings, "key." + output)].func_151463_i();
        } else {
            Map<String, Object> settingsMap = this.createMap(gameSettings);
            value = settingsMap.get(key);
        }
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.func_74778_a(ClientData.SETTING.toString(), value.toString());
        return nbtTagCompound;
    }

    @Override
    public void setData(NBTTagCompound data) throws Throwable {
        String key = data.func_74779_i("key");
        Object value = this.converter(data.func_74779_i("value"));
        SettingType type = key.startsWith("keyBind") ? SettingType.KEYBIND : SettingType.NORMAL;
        GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
        if (type == SettingType.KEYBIND) {
            String output = key.replace("keyBind", "");
            output = Character.toLowerCase(output.charAt(0)) + output.substring(1);
            gameSettings.func_151440_a(gameSettings.field_74324_K[this.getKeyBindIndex(gameSettings, "key." + output)], ((Integer)value).intValue());
        } else {
            if (!this.dev) {
                int indexField = SettingProvider.indexOf(this.keys, key);
                key = this.fields[indexField];
            }
            Map<String, MethodHandle> setters = SettingProvider.getSetters(gameSettings.getClass());
            setters.get(key).invoke(gameSettings, value);
        }
        gameSettings.func_74303_b();
        gameSettings.func_74300_a();
    }

    public static int indexOf(String[] array, String search) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(search)) continue;
            return i;
        }
        return -1;
    }

    private int getKeyBindIndex(GameSettings gameSettings, String key) {
        int index = -1;
        KeyBinding[] array = gameSettings.field_74324_K;
        for (int i = 0; i < array.length; ++i) {
            KeyBinding setting = array[i];
            if (!setting.func_151464_g().equals(key)) continue;
            index = i;
            break;
        }
        return index;
    }

    private static Map<String, MethodHandle> getSetters(Class<?> type) throws Exception {
        HashMap<String, MethodHandle> setters = new HashMap<String, MethodHandle>();
        while (type != null) {
            for (Field field : type.getDeclaredFields()) {
                field.setAccessible(true);
                setters.put(field.getName(), MethodHandles.lookup().unreflectSetter(field));
            }
            type = type.getSuperclass();
        }
        return setters;
    }

    public Map<String, Object> createMap(GameSettings gameSettings) {
        HashMap<String, Object> settingsMap = new HashMap<String, Object>();
        settingsMap.put("thirdPersonView", gameSettings.field_74320_O);
        settingsMap.put("advancedItemTooltips", gameSettings.field_82882_x);
        settingsMap.put("ambientOcclusion", gameSettings.field_74348_k);
        settingsMap.put("anaglyph", gameSettings.field_74337_g);
        settingsMap.put("attackIndicator", gameSettings.field_186716_M);
        settingsMap.put("autoJump", gameSettings.field_189989_R);
        settingsMap.put("chatColours", gameSettings.field_74344_o);
        settingsMap.put("chatHeightUnfocused", Float.valueOf(gameSettings.field_96693_G));
        settingsMap.put("chatLinks", gameSettings.field_74359_p);
        settingsMap.put("chatLinksPrompt", gameSettings.field_74358_q);
        settingsMap.put("chatOpacity", Float.valueOf(gameSettings.field_74357_r));
        settingsMap.put("chatScale", Float.valueOf(gameSettings.field_96691_E));
        settingsMap.put("chatVisibility", gameSettings.field_74343_n);
        settingsMap.put("chatWidth", Float.valueOf(gameSettings.field_96692_F));
        settingsMap.put("clouds", gameSettings.field_74345_l);
        settingsMap.put("debugCamEnable", gameSettings.field_74325_U);
        settingsMap.put("difficulty", gameSettings.field_74318_M);
        settingsMap.put("enableVsync", gameSettings.field_74352_v);
        settingsMap.put("enableWeakAttacks", gameSettings.field_189422_N);
        settingsMap.put("entityShadows", gameSettings.field_181151_V);
        settingsMap.put("fancyGraphics", gameSettings.field_74347_j);
        settingsMap.put("fboEnable", gameSettings.field_151448_g);
        settingsMap.put("forceUnicodeFont", gameSettings.field_151455_aw);
        settingsMap.put("fovSetting", Float.valueOf(gameSettings.field_74334_X));
        settingsMap.put("fullScreen", gameSettings.field_74353_u);
        settingsMap.put("gammaSetting", Float.valueOf(gameSettings.field_74333_Y));
        settingsMap.put("guiScale", gameSettings.field_74335_Z);
        settingsMap.put("heldItemTooltips", gameSettings.field_92117_D);
        settingsMap.put("hideGUI", gameSettings.field_74319_N);
        settingsMap.put("hideServerAddress", gameSettings.field_80005_w);
        settingsMap.put("incompatibleResourcePacks", gameSettings.field_183018_l);
        settingsMap.put("invertMouse", gameSettings.field_74338_d);
        settingsMap.put("language", gameSettings.field_74363_ab);
        settingsMap.put("lastServer", gameSettings.field_74332_R);
        settingsMap.put("limitFramerate", gameSettings.field_74350_i);
        settingsMap.put("mainHand", gameSettings.field_186715_A);
        settingsMap.put("mipmapLevels", gameSettings.field_151442_I);
        settingsMap.put("mouseSensitivity", Float.valueOf(gameSettings.field_74341_c));
        settingsMap.put("narrator", gameSettings.field_192571_R);
        settingsMap.put("overrideHeight", gameSettings.field_92119_C);
        settingsMap.put("overrideWidth", gameSettings.field_92118_B);
        settingsMap.put("particleSetting", gameSettings.field_74362_aa);
        settingsMap.put("pauseOnLostFocus", gameSettings.field_82881_y);
        settingsMap.put("realmsNotifications", gameSettings.field_183509_X);
        settingsMap.put("reducedDebugInfo", gameSettings.field_178879_v);
        settingsMap.put("renderDistanceChunks", gameSettings.field_151451_c);
        settingsMap.put("resourcePacks", gameSettings.field_151453_l);
        settingsMap.put("saturation", Float.valueOf(gameSettings.field_151452_as));
        settingsMap.put("showDebugInfo", gameSettings.field_74330_P);
        settingsMap.put("showDebugProfilerChart", gameSettings.field_74329_Q);
        settingsMap.put("showLagometer", gameSettings.field_181657_aC);
        settingsMap.put("showSubtitles", gameSettings.field_186717_N);
        settingsMap.put("smoothCamera", gameSettings.field_74326_T);
        settingsMap.put("snooperEnabled", gameSettings.field_74355_t);
        settingsMap.put("touchscreen", gameSettings.field_85185_A);
        settingsMap.put("tutorialStep", gameSettings.field_193631_S);
        settingsMap.put("useNativeTransport", gameSettings.field_181150_U);
        settingsMap.put("useVbo", gameSettings.field_178881_t);
        settingsMap.put("viewBobbing", gameSettings.field_74336_f);
        return settingsMap;
    }

    private Object converter(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    return Double.parseDouble(value);
                }
                catch (NumberFormatException numberFormatException3) {
                    try {
                        return Boolean.parseBoolean(value);
                    }
                    catch (NumberFormatException numberFormatException4) {
                        return value;
                    }
                }
            }
        }
    }

    public static enum SettingType {
        NORMAL,
        KEYBIND;

    }
}

