/*
 * Decompiled with CFR 0.152.
 */
package toraylife.mappetextras.modules.client.network;

import io.netty.buffer.ByteBuf;
import mchorse.mclib.network.ServerMessageHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import toraylife.mappetextras.CommonProxy;
import toraylife.mappetextras.modules.client.AccessType;

public class PacketEvent
implements IMessage {
    NBTTagCompound data;
    AccessType accessType;

    public PacketEvent() {
    }

    public PacketEvent(AccessType accessType, NBTTagCompound data) {
        this.accessType = accessType;
        this.data = data;
    }

    public void fromBytes(ByteBuf buf) {
        this.accessType = AccessType.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.accessType.toString());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
    }

    public static class ServerHandler
    extends ServerMessageHandler<PacketEvent> {
        public void run(EntityPlayerMP entityPlayerMP, PacketEvent packet) {
            NBTTagCompound data = packet.data;
            AccessType accessType = packet.accessType;
            switch (accessType) {
                case OPEN: {
                    CommonProxy.eventTriggerHandler.onPlayerOpenGui(data.func_74779_i("gui"), (EntityPlayer)entityPlayerMP);
                    break;
                }
                case CLOSE: {
                    CommonProxy.eventTriggerHandler.onPlayerCloseGui(data.func_74779_i("gui"), (EntityPlayer)entityPlayerMP);
                    break;
                }
                case MOUSE: {
                    CommonProxy.eventTriggerHandler.onMouseEvent(data, entityPlayerMP);
                    break;
                }
                case KEYBOARD: {
                    CommonProxy.eventTriggerHandler.onKeyboardEvent(data, entityPlayerMP);
                }
            }
        }
    }
}

