/*
 * Decompiled with CFR 0.152.
 */
package toraylife.mappetextras.modules.client.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import mchorse.mclib.network.ClientMessageHandler;
import mchorse.mclib.network.ServerMessageHandler;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import toraylife.mappetextras.modules.client.AccessType;
import toraylife.mappetextras.modules.client.ClientData;
import toraylife.mappetextras.modules.client.providers.ClipboardProvider;
import toraylife.mappetextras.modules.client.providers.IClientDataProvider;
import toraylife.mappetextras.modules.client.providers.MousePositionProvider;
import toraylife.mappetextras.modules.client.providers.PerspectiveProvider;
import toraylife.mappetextras.modules.client.providers.RenderWithEntityProvider;
import toraylife.mappetextras.modules.client.providers.ResolutionProvider;
import toraylife.mappetextras.modules.client.providers.SettingProvider;
import toraylife.mappetextras.modules.client.providers.WebLinkProvider;
import toraylife.mappetextras.network.Dispatcher;

public class PacketClientData
implements IMessage {
    public static final Map<UUID, Consumer<Object>> \u0441allBack = new HashMap<UUID, Consumer<Object>>();
    ClientData type;
    AccessType access;
    NBTTagCompound nbtTagCompound;
    NBTTagCompound nbtData;
    String uniqueId;

    public PacketClientData() {
    }

    public PacketClientData(ClientData type, AccessType access, UUID uniqueId) {
        this.type = type;
        this.access = access;
        this.nbtTagCompound = new NBTTagCompound();
        this.nbtData = new NBTTagCompound();
        this.uniqueId = uniqueId.toString();
    }

    public PacketClientData(NBTTagCompound nbtData, ClientData type, AccessType access, UUID uniqueId) {
        this.type = type;
        this.access = access;
        this.nbtTagCompound = new NBTTagCompound();
        this.nbtData = nbtData;
        this.uniqueId = uniqueId.toString();
    }

    public PacketClientData(ClientData type, AccessType access, NBTTagCompound nbtTagCompound) {
        this.type = type;
        this.access = access;
        this.nbtTagCompound = nbtTagCompound;
        this.nbtData = new NBTTagCompound();
        this.uniqueId = "";
    }

    public PacketClientData(ClientData type, AccessType access, NBTTagCompound nbtTagCompound, UUID uniqueId) {
        this.type = type;
        this.access = access;
        this.nbtTagCompound = nbtTagCompound;
        this.nbtData = new NBTTagCompound();
        this.uniqueId = uniqueId.toString();
    }

    public void fromBytes(ByteBuf buf) {
        this.type = ClientData.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.access = AccessType.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.nbtTagCompound = ByteBufUtils.readTag((ByteBuf)buf);
        this.nbtData = ByteBufUtils.readTag((ByteBuf)buf);
        this.uniqueId = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.type.toString());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.access.toString());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbtTagCompound);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbtData);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.uniqueId);
    }

    public static class ServerHandler
    extends ServerMessageHandler<PacketClientData> {
        public void run(EntityPlayerMP entityPlayerMP, PacketClientData packet) {
            NBTTagCompound value = packet.nbtTagCompound;
            UUID uniqueId = UUID.fromString(packet.uniqueId);
            \u0441allBack.get(uniqueId).accept(packet.type.process(value));
            \u0441allBack.remove(uniqueId);
        }
    }

    public static class ClientHandler
    extends ClientMessageHandler<PacketClientData> {
        @SideOnly(value=Side.CLIENT)
        public void run(EntityPlayerSP player, PacketClientData message) {
            ClientData typeEnum = message.type;
            AccessType typeAccess = message.access;
            NBTTagCompound value = message.nbtTagCompound;
            NBTTagCompound nbtData = message.nbtData;
            String uniqueId = message.uniqueId;
            IClientDataProvider provider = ClientHandler.createProvider(typeEnum);
            switch (typeAccess) {
                case GET: {
                    NBTTagCompound data = provider.getData();
                    Dispatcher.sendToServer(new PacketClientData(typeEnum, typeAccess, data, UUID.fromString(uniqueId)));
                }
                case SET: {
                    try {
                        provider.setData(value);
                        break;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
                case USE: {
                    break;
                }
                case GET_WITH_DATA: {
                    NBTTagCompound dataWithResponse;
                    try {
                        dataWithResponse = provider.getData(nbtData);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        throw new RuntimeException(e);
                    }
                    Dispatcher.sendToServer(new PacketClientData(typeEnum, typeAccess, dataWithResponse, UUID.fromString(uniqueId)));
                }
            }
        }

        public static IClientDataProvider createProvider(ClientData typeEnum) {
            switch (typeEnum) {
                case PESPECTIVE: {
                    return new PerspectiveProvider();
                }
                case CLIPBOARD: {
                    return new ClipboardProvider();
                }
                case MOUSEPOSITION: {
                    return new MousePositionProvider();
                }
                case SETTING: {
                    return new SettingProvider();
                }
                case RESOLUTION: {
                    return new ResolutionProvider();
                }
                case WEB_LINK: {
                    return new WebLinkProvider();
                }
                case RENDER_WITH_ENTITY: {
                    return new RenderWithEntityProvider();
                }
            }
            throw new IllegalArgumentException("Invalid typeEnum");
        }
    }
}

