/*
 * Decompiled with CFR 0.152.
 */
package toraylife.mappetextras.modules.client.network;

import io.netty.buffer.ByteBuf;
import mchorse.mclib.network.ClientMessageHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import toraylife.mappetextras.capabilities.CapabilitiesType;
import toraylife.mappetextras.capabilities.camera.Camera;
import toraylife.mappetextras.capabilities.mainHand.MainHand;
import toraylife.mappetextras.capabilities.minecraftHUD.MinecraftHUD;
import toraylife.mappetextras.capabilities.offHand.OffHand;
import toraylife.mappetextras.capabilities.shake.Shake;

public class PacketCapability
implements IMessage {
    NBTTagCompound profile;
    CapabilitiesType type;

    public PacketCapability() {
    }

    public PacketCapability(NBTTagCompound profile, CapabilitiesType type) {
        this.profile = profile;
        this.type = type;
    }

    public void fromBytes(ByteBuf buf) {
        this.profile = ByteBufUtils.readTag((ByteBuf)buf);
        this.type = CapabilitiesType.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.profile);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.type.toString());
    }

    public static class ClientHandler
    extends ClientMessageHandler<PacketCapability> {
        @SideOnly(value=Side.CLIENT)
        public void run(EntityPlayerSP player, PacketCapability message) {
            CapabilitiesType type = message.type;
            switch (type) {
                case ARM_RENDER: {
                    int hand = message.profile.func_74762_e("hand");
                    if (hand == 0) {
                        MainHand.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).deserializeNBT(message.profile);
                        break;
                    }
                    OffHand.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).deserializeNBT(message.profile);
                    break;
                }
                case CAMERA: {
                    Camera.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).deserializeNBT(message.profile);
                    break;
                }
                case MINECRAFT_HUD: {
                    MinecraftHUD.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).deserializeNBT(message.profile);
                    break;
                }
                case SHAKE: {
                    Shake.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).deserializeNBT(message.profile);
                }
            }
        }
    }
}

