/*
 * Decompiled with CFR 0.152.
 */
package toraylife.mappetextras.modules.client.mixins.late;

import java.util.UUID;
import java.util.function.Consumer;
import mchorse.mappet.api.scripts.code.entities.ScriptPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import toraylife.mappetextras.modules.client.AccessType;
import toraylife.mappetextras.modules.client.ClientData;
import toraylife.mappetextras.modules.client.network.PacketClientData;
import toraylife.mappetextras.modules.client.scripts.code.minecraft.MinecraftArmRender;
import toraylife.mappetextras.modules.client.scripts.code.minecraft.MinecraftCamera;
import toraylife.mappetextras.modules.client.scripts.code.minecraft.MinecraftHUD;
import toraylife.mappetextras.modules.client.scripts.user.minecraft.IMinecraftArmRender;
import toraylife.mappetextras.modules.client.scripts.user.minecraft.IMinecraftCamera;
import toraylife.mappetextras.modules.main.mixins.utils.MixinTargetName;
import toraylife.mappetextras.network.Dispatcher;

@Mixin(value={ScriptPlayer.class}, remap=false)
@MixinTargetName(value="mchorse.mappet.api.scripts.user.entities.IScriptPlayer")
public abstract class MixinScriptPlayer {
    @Shadow
    public abstract EntityPlayerMP getMinecraftPlayer();

    public void setPerspective(Integer perspective) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.func_74768_a(ClientData.PESPECTIVE.toString(), perspective.intValue());
        Dispatcher.sendTo(new PacketClientData(ClientData.PESPECTIVE, AccessType.SET, nbtTagCompound), this.getMinecraftPlayer());
    }

    public void getPerspective(Consumer<Object> callBack) {
        UUID uniqueId = UUID.randomUUID();
        PacketClientData.\u0441allBack.put(uniqueId, callBack);
        Dispatcher.sendTo(new PacketClientData(ClientData.PESPECTIVE, AccessType.GET, uniqueId), this.getMinecraftPlayer());
    }

    public void setClipboard(String text) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.func_74778_a(ClientData.CLIPBOARD.toString(), text);
        Dispatcher.sendTo(new PacketClientData(ClientData.CLIPBOARD, AccessType.SET, nbtTagCompound), this.getMinecraftPlayer());
    }

    public void openWebLink(String address) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.func_74778_a(ClientData.WEB_LINK.toString(), address);
        Dispatcher.sendTo(new PacketClientData(ClientData.WEB_LINK, AccessType.SET, nbtTagCompound), this.getMinecraftPlayer());
    }

    public void getClipboard(Consumer<Object> callback) {
        UUID uniqueId = UUID.randomUUID();
        PacketClientData.\u0441allBack.put(uniqueId, callback);
        Dispatcher.sendTo(new PacketClientData(ClientData.CLIPBOARD, AccessType.GET, uniqueId), this.getMinecraftPlayer());
    }

    public void setMousePosition(int x, int y, boolean isInsideWindow) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        NBTTagCompound object = new NBTTagCompound();
        nbtTagCompound.func_74782_a(ClientData.MOUSEPOSITION.toString(), (NBTBase)object);
        object.func_74768_a("x", x);
        object.func_74768_a("y", y);
        nbtTagCompound.func_74757_a("isInsideWindow", isInsideWindow);
        Dispatcher.sendTo(new PacketClientData(ClientData.MOUSEPOSITION, AccessType.SET, nbtTagCompound), this.getMinecraftPlayer());
    }

    public void getMousePosition(Consumer<Object> callback, boolean isInsideWindow) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74757_a("isInsideWindow", isInsideWindow);
        UUID uniqueId = UUID.randomUUID();
        PacketClientData.\u0441allBack.put(uniqueId, callback);
        Dispatcher.sendTo(new PacketClientData(data, ClientData.MOUSEPOSITION, AccessType.GET_WITH_DATA, uniqueId), this.getMinecraftPlayer());
    }

    public void setSetting(String key, Object value) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.func_74778_a("key", key);
        nbtTagCompound.func_74778_a("value", value.toString());
        Dispatcher.sendTo(new PacketClientData(ClientData.SETTING, AccessType.SET, nbtTagCompound), this.getMinecraftPlayer());
    }

    public void getSetting(String key, Consumer<Object> callback) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("key", key);
        UUID uniqueId = UUID.randomUUID();
        PacketClientData.\u0441allBack.put(uniqueId, callback);
        Dispatcher.sendTo(new PacketClientData(data, ClientData.SETTING, AccessType.GET_WITH_DATA, uniqueId), this.getMinecraftPlayer());
    }

    public void getResolution(Consumer<Object> callback) {
        UUID uniqueId = UUID.randomUUID();
        PacketClientData.\u0441allBack.put(uniqueId, callback);
        Dispatcher.sendTo(new PacketClientData(ClientData.RESOLUTION, AccessType.GET, uniqueId), this.getMinecraftPlayer());
    }

    public IMinecraftArmRender getArmRender(int hand) {
        return new MinecraftArmRender(this.getMinecraftPlayer(), hand);
    }

    public MinecraftHUD getMinecraftHUD(String hud) {
        return new MinecraftHUD(this.getMinecraftPlayer(), hud.toUpperCase());
    }

    public void resetAllMinecraftHUDs() {
        String[] huds;
        for (String hud : huds = new String[]{"HELMET", "PORTAL", "CROSSHAIRS", "BOSSHEALTH", "BOSSINFO", "ARMOR", "HEALTH", "AIR", "EXPERIENCE", "TEXT", "HEALTHMOUNT", "JUMPBAR", "CHAT", "PLAYER_LIST", "DEBUG", "POTION_ICONS", "SUBTITLES", "FPS_GRAPH", "VIGNETTE"}) {
            MinecraftHUD minecraftHUD = this.getMinecraftHUD(hud);
            minecraftHUD.setPosition(0.0, 0.0);
            minecraftHUD.setRotate(0.0, 0.0, 0.0, 0.0);
        }
    }

    public IMinecraftCamera getCamera() {
        return new MinecraftCamera(this.getMinecraftPlayer());
    }
}

