/*
 * Decompiled with CFR 0.152.
 */
package toraylife.mappetextras.events;

import java.util.Calendar;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import toraylife.mappetextras.MappetExtras;
import toraylife.mappetextras.modules.utils.items.ItemNpcPicker;
import toraylife.mappetextras.modules.utils.items.ItemNpcSoulstoneEmpty;
import toraylife.mappetextras.modules.utils.items.ItemNpcSoulstoneFilled;

public class RegisterHandler {
    public static final Calendar calendar = Calendar.getInstance();

    @SubscribeEvent
    public void onItemsRegister(RegistryEvent.Register<Item> event) {
        MappetExtras.npcPicker = ((Item)new ItemNpcPicker().setRegistryName(new ResourceLocation("mappetextras", "npc_picker"))).func_77655_b("mappetextras.npc_picker");
        event.getRegistry().register((IForgeRegistryEntry)MappetExtras.npcPicker);
        MappetExtras.npcSoulstoneEmpty = ((Item)new ItemNpcSoulstoneEmpty().setRegistryName(new ResourceLocation("mappetextras", "npc_soulstone_empty"))).func_77655_b("mappetextras.npc_soulstone");
        event.getRegistry().register((IForgeRegistryEntry)MappetExtras.npcSoulstoneEmpty);
        MappetExtras.npcSoulstoneFilled = ((Item)new ItemNpcSoulstoneFilled().setRegistryName(new ResourceLocation("mappetextras", "npc_soulstone_filled"))).func_77655_b("mappetextras.npc_soulstone");
        event.getRegistry().register((IForgeRegistryEntry)MappetExtras.npcSoulstoneFilled);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onModelRegistry(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)MappetExtras.npcPicker, (int)0, (ModelResourceLocation)this.getNpcToolTexture("npc_picker"));
        ModelLoader.setCustomModelResourceLocation((Item)MappetExtras.npcSoulstoneEmpty, (int)0, (ModelResourceLocation)this.getNpcToolTexture("npc_soulstone_empty"));
        ModelLoader.setCustomModelResourceLocation((Item)MappetExtras.npcSoulstoneFilled, (int)0, (ModelResourceLocation)this.getNpcToolTexture("npc_soulstone_filled"));
    }

    public ModelResourceLocation getNpcToolTexture(String toolname) {
        String postfix = "";
        if (this.isWinter()) {
            postfix = "_winter";
        }
        if (this.isChristmas()) {
            postfix = "_christmas";
        } else if (this.isEaster()) {
            postfix = "_easter";
        } else if (this.isAprilFoolsDay()) {
            postfix = "_april";
        } else if (this.isHalloween()) {
            postfix = "_halloween";
        }
        if (this.isMappetBirthday()) {
            postfix = "_mchorse";
        } else if (this.isLlamaBirthday()) {
            postfix = "_llama";
        } else if (this.isDemonBirthday()) {
            postfix = "_demon";
        } else if (this.isDyamoBirthday()) {
            postfix = "_dyamo";
        }
        return new ModelResourceLocation("mappetextras:" + toolname + "/" + toolname + postfix, "inventory");
    }

    public boolean isChristmas() {
        return calendar.get(2) == 11 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
    }

    public boolean isAprilFoolsDay() {
        return calendar.get(2) == 3 && calendar.get(5) <= 2;
    }

    public boolean isWinter() {
        int month = calendar.get(2);
        return month == 11 || month == 0 || month == 1;
    }

    public boolean isEaster() {
        Calendar easterDate = this.getEasterDate(calendar.get(1));
        return calendar.get(2) == easterDate.get(2) && calendar.get(5) == easterDate.get(5);
    }

    public boolean isHalloween() {
        return calendar.get(2) == 9 && calendar.get(5) >= 24;
    }

    public boolean isLlamaBirthday() {
        return calendar.get(2) == 11 && calendar.get(5) == 1;
    }

    public boolean isDemonBirthday() {
        return calendar.get(2) == 4 && calendar.get(5) == 28;
    }

    public boolean isDyamoBirthday() {
        return calendar.get(2) == 3 && calendar.get(5) == 21;
    }

    public boolean isMappetBirthday() {
        return calendar.get(2) == 8 && calendar.get(5) >= 13 && calendar.get(5) <= 15;
    }

    public Calendar getEasterDate(int year) {
        int a = year % 19;
        int b = year / 100;
        int c = year % 100;
        int d = b / 4;
        int e = b % 4;
        int f = (b + 8) / 25;
        int g = (b - f + 1) / 3;
        int h = (19 * a + b - d - g + 15) % 30;
        int i = c / 4;
        int k = c % 4;
        int l = (32 + 2 * e + 2 * i - h - k) % 7;
        int month = (h + l + 114) / 31;
        int day = (h + l + 114) % 31;
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, day + 1);
        return calendar;
    }
}

