/*
 * Decompiled with CFR 0.152.
 */
package toraylife.mappetextras.events;

import mchorse.mappet.CommonProxy;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.triggers.Trigger;
import mchorse.mappet.api.utils.DataContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemPotion;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import toraylife.mappetextras.modules.main.triggers.TriggerAccessor;

public class EventTriggerHandler {
    @SubscribeEvent
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (Mappet.settings == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Trigger trigger = ((TriggerAccessor)Mappet.settings).getPlayerTick();
        EntityPlayer player = event.player;
        if (this.shouldCancelTrigger(trigger) || player.field_70170_p.field_72995_K) {
            return;
        }
        trigger.trigger(new DataContext((Entity)player));
    }

    @SubscribeEvent
    public void onPlayerWalkingEvent(TickEvent.PlayerTickEvent event) {
        if (Mappet.settings == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Trigger trigger = ((TriggerAccessor)Mappet.settings).getPlayerWalking();
        EntityPlayer player = event.player;
        if (this.shouldCancelTrigger(trigger) || player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.field_70141_P - player.field_70140_Q == 0.0f) {
            return;
        }
        DataContext context = new DataContext((Entity)player);
        context.set("onGround", player.field_70122_E ? 1.0 : 0.0);
        trigger.trigger(context);
    }

    @SubscribeEvent
    public void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        if (Mappet.settings == null) {
            return;
        }
        Trigger trigger = ((TriggerAccessor)Mappet.settings).getEntityJumping();
        EntityLivingBase entity = event.getEntityLiving();
        if (this.shouldCancelTrigger(trigger) || entity.field_70170_p.field_72995_K) {
            return;
        }
        CommonProxy.eventHandler.trigger((Event)event, trigger, new DataContext((Entity)entity));
    }

    @SubscribeEvent
    public void onLivingFallEvent(LivingFallEvent event) {
        if (Mappet.settings == null) {
            return;
        }
        Trigger trigger = ((TriggerAccessor)Mappet.settings).getEntityFalling();
        EntityLivingBase entity = event.getEntityLiving();
        if (this.shouldCancelTrigger(trigger) || entity.field_70170_p.field_72995_K) {
            return;
        }
        DataContext context = new DataContext((Entity)entity);
        context.set("distance", (double)event.getDistance());
        context.set("damageMultiplier", (double)event.getDamageMultiplier());
        CommonProxy.eventHandler.trigger((Event)event, trigger, context);
    }

    public void onPlayerOpenGui(String gui, EntityPlayer player) {
        if (Mappet.settings == null) {
            return;
        }
        Trigger trigger = ((TriggerAccessor)Mappet.settings).getPlayerOpenGui();
        if (this.shouldCancelTrigger(trigger) || player.field_70170_p.field_72995_K) {
            return;
        }
        DataContext context = new DataContext((Entity)player);
        context.set("gui", gui);
        trigger.trigger(context);
    }

    public void onPlayerCloseGui(String gui, EntityPlayer player) {
        if (Mappet.settings == null) {
            return;
        }
        Trigger trigger = ((TriggerAccessor)Mappet.settings).getPlayerCloseGui();
        if (this.shouldCancelTrigger(trigger) || player.field_70170_p.field_72995_K) {
            return;
        }
        DataContext context = new DataContext((Entity)player);
        context.set("gui", gui);
        trigger.trigger(context);
    }

    public void onMouseEvent(NBTTagCompound data, EntityPlayerMP player) {
        if (Mappet.settings == null) {
            return;
        }
        Trigger trigger = ((TriggerAccessor)Mappet.settings).getPlayerMouse();
        if (this.shouldCancelTrigger(trigger) || player.field_70170_p.field_72995_K) {
            return;
        }
        DataContext context = new DataContext((Entity)player);
        context.set("button", (double)data.func_74762_e("button"));
        context.getValues().put("buttonState", data.func_74767_n("buttonState"));
        trigger.trigger(context);
    }

    public void onKeyboardEvent(NBTTagCompound data, EntityPlayerMP player) {
        if (Mappet.settings == null) {
            return;
        }
        Trigger trigger = ((TriggerAccessor)Mappet.settings).getPlayerKeyBoard();
        if (this.shouldCancelTrigger(trigger) || player.field_70170_p.field_72995_K) {
            return;
        }
        DataContext context = new DataContext((Entity)player);
        context.set("keyCode", (double)data.func_74762_e("keyCode"));
        trigger.trigger(context);
    }

    @SubscribeEvent
    public void onPlayerEatEvent(TickEvent.PlayerTickEvent event) {
        boolean isEat;
        if (Mappet.settings == null) {
            return;
        }
        Trigger trigger = ((TriggerAccessor)Mappet.settings).getPlayerEat();
        EntityPlayer player = event.player;
        if (this.shouldCancelTrigger(trigger) || player.field_70170_p.field_72995_K) {
            return;
        }
        boolean bl = isEat = player.func_184605_cv() > 0 && player.func_184607_cu().func_77973_b() instanceof ItemFood;
        if (!isEat) {
            return;
        }
        DataContext context = new DataContext((Entity)player);
        trigger.trigger(context);
    }

    @SubscribeEvent
    public void onPlayerDrinkEvent(TickEvent.PlayerTickEvent event) {
        boolean isDrink;
        if (Mappet.settings == null) {
            return;
        }
        Trigger trigger = ((TriggerAccessor)Mappet.settings).getPlayerDrink();
        EntityPlayer player = event.player;
        if (this.shouldCancelTrigger(trigger) || player.field_70170_p.field_72995_K) {
            return;
        }
        boolean bl = isDrink = player.func_184605_cv() > 0 && player.func_184607_cu().func_77973_b() instanceof ItemPotion;
        if (!isDrink) {
            return;
        }
        trigger.trigger(new DataContext((Entity)player));
    }

    @SubscribeEvent
    public void onDimensionChangeEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (Mappet.settings == null) {
            return;
        }
        Trigger trigger = ((TriggerAccessor)Mappet.settings).getPlayerDimensionChange();
        EntityPlayer player = event.player;
        if (this.shouldCancelTrigger(trigger) || player.field_70170_p.field_72995_K) {
            return;
        }
        DataContext context = new DataContext((Entity)player);
        context.set("fromDim", (double)event.fromDim);
        context.set("toDim", (double)event.toDim);
        trigger.trigger(context);
    }

    public boolean shouldCancelTrigger(Trigger trigger) {
        return trigger == null || trigger.isEmpty();
    }
}

