/*
 * Decompiled with CFR 0.152.
 */
package toraylife.mappetextras.events;

import mchorse.mappet.api.scripts.user.data.ScriptVector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import toraylife.mappetextras.capabilities.CapabilitiesType;
import toraylife.mappetextras.capabilities.camera.Camera;
import toraylife.mappetextras.capabilities.camera.CameraProvider;
import toraylife.mappetextras.capabilities.mainHand.MainHand;
import toraylife.mappetextras.capabilities.mainHand.MainHandProvider;
import toraylife.mappetextras.capabilities.minecraftHUD.MinecraftHUD;
import toraylife.mappetextras.capabilities.minecraftHUD.MinecraftHUDProvider;
import toraylife.mappetextras.capabilities.offHand.OffHand;
import toraylife.mappetextras.capabilities.offHand.OffHandProvider;
import toraylife.mappetextras.capabilities.shake.Shake;
import toraylife.mappetextras.capabilities.shake.ShakeProvider;
import toraylife.mappetextras.modules.client.AccessType;
import toraylife.mappetextras.modules.client.network.PacketCapability;
import toraylife.mappetextras.modules.client.network.PacketEvent;
import toraylife.mappetextras.modules.main.VersionChecker;
import toraylife.mappetextras.modules.scripting.utils.ScriptVectorAngle;
import toraylife.mappetextras.modules.utils.render.NpcPathRenderer;
import toraylife.mappetextras.network.Dispatcher;

public class EventHandler {
    private static final NpcPathRenderer npcPathRenderer = new NpcPathRenderer();
    public static final ResourceLocation MAINHAND = new ResourceLocation("mappetextras", "mainHand");
    public static final ResourceLocation OFFHAND = new ResourceLocation("mappetextras", "offHand");
    public static final ResourceLocation MINECRAFTHUD = new ResourceLocation("mappetextras", "minecraftHUD");
    public static final ResourceLocation SHAKE = new ResourceLocation("mappetextras", "shake");
    public static final ResourceLocation CAMERA = new ResourceLocation("mappetextras", "camera");
    public static boolean isReversed = false;
    public static float animationProgress = 0.0f;

    @SubscribeEvent
    public void onPlayerJoinEvent(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        VersionChecker versionChecker = new VersionChecker();
        versionChecker.start();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (!npcPathRenderer.shouldRenderDebugPath()) {
            return;
        }
        npcPathRenderer.renderNpcPaths(event);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerOpenGuiEvent(GuiOpenEvent event) {
        if (event.getGui() != null) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("gui", this.processText(event.getGui().toString()));
            Dispatcher.sendToServer(new PacketEvent(AccessType.OPEN, data));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onPlayerCloseGuiEvent(GuiScreen guiScreen) {
        if (guiScreen != null) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("gui", this.processText(guiScreen.toString()));
            Dispatcher.sendToServer(new PacketEvent(AccessType.CLOSE, data));
        }
    }

    public String processText(String text) {
        int lastDot = text.lastIndexOf(46);
        int indexOfAt = (text = text.substring(lastDot + 1)).indexOf(64);
        if (indexOfAt != -1) {
            text = text.substring(0, indexOfAt);
        }
        if ((text = text.trim()).toLowerCase().startsWith("gui")) {
            text = text.substring(3);
        }
        if (!text.isEmpty()) {
            text = Character.toLowerCase(text.charAt(0)) + text.substring(1);
        }
        return text;
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(MAINHAND, (ICapabilityProvider)new MainHandProvider());
            event.addCapability(OFFHAND, (ICapabilityProvider)new OffHandProvider());
            event.addCapability(MINECRAFTHUD, (ICapabilityProvider)new MinecraftHUDProvider());
            event.addCapability(SHAKE, (ICapabilityProvider)new ShakeProvider());
            event.addCapability(CAMERA, (ICapabilityProvider)new CameraProvider());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderHandEvent(RenderSpecificHandEvent event) {
        MainHand mainHand = MainHand.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        OffHand offHand = OffHand.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        ScriptVector mPos = mainHand.getPosition();
        ScriptVectorAngle mRotate = mainHand.getRotate();
        ScriptVector oPos = offHand.getPosition();
        ScriptVectorAngle oRotate = offHand.getRotate();
        if (event.getHand() == EnumHand.MAIN_HAND) {
            if (!mainHand.isRender()) {
                event.setCanceled(true);
                return;
            }
            if (mPos.x == 0.0 && mPos.y == 0.0 && mPos.z == 0.0 && mRotate.angle == 0.0 && mRotate.x == 0.0 && mRotate.y == 0.0 && mRotate.z == 0.0) {
                return;
            }
            this.handleRotation(mainHand);
        }
        if (event.getHand() == EnumHand.OFF_HAND) {
            if (!offHand.isRender()) {
                event.setCanceled(true);
                return;
            }
            if (oPos.x == 0.0 && oPos.y == 0.0 && oPos.z == 0.0 && oRotate.angle == 0.0 && oRotate.x == 0.0 && oRotate.y == 0.0 && oRotate.z == 0.0) {
                return;
            }
            this.handleRotation(offHand);
        }
    }

    private void handleRotation(OffHand offHand) {
        ScriptVectorAngle rotate = offHand.getRotate();
        ScriptVector pos = offHand.getPosition();
        GL11.glRotated((double)rotate.angle, (double)rotate.x, (double)rotate.y, (double)rotate.z);
        GL11.glTranslated((double)pos.x, (double)pos.y, (double)pos.z);
    }

    private void handleRotation(MainHand mainHand) {
        ScriptVectorAngle rotate = mainHand.getRotate();
        ScriptVector pos = mainHand.getPosition();
        GL11.glRotated((double)rotate.angle, (double)rotate.x, (double)rotate.y, (double)rotate.z);
        GL11.glTranslated((double)pos.x, (double)pos.y, (double)pos.z);
    }

    @SubscribeEvent
    public void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        MainHand mainHand = MainHand.get(player);
        OffHand offHand = OffHand.get(player);
        MinecraftHUD minecraftHUD = MinecraftHUD.get(player);
        Shake shake = Shake.get(player);
        Camera camera = Camera.get(player);
        Dispatcher.sendTo(new PacketCapability(mainHand.serializeNBT(), CapabilitiesType.ARM_RENDER), (EntityPlayerMP)player);
        Dispatcher.sendTo(new PacketCapability(offHand.serializeNBT(), CapabilitiesType.ARM_RENDER), (EntityPlayerMP)player);
        Dispatcher.sendTo(new PacketCapability(minecraftHUD.serializeNBT(), CapabilitiesType.MINECRAFT_HUD), (EntityPlayerMP)player);
        Dispatcher.sendTo(new PacketCapability(shake.serializeNBT(), CapabilitiesType.SHAKE), (EntityPlayerMP)player);
        Dispatcher.sendTo(new PacketCapability(camera.serializeNBT(), CapabilitiesType.CAMERA), (EntityPlayerMP)player);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderGuiPre(RenderGameOverlayEvent.Pre event) {
        MinecraftHUD minecraftHUD = MinecraftHUD.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        minecraftHUD.setName(event.getType().name());
        boolean render = minecraftHUD.isRender();
        ScriptVector scale = minecraftHUD.getScale();
        ScriptVector pos = minecraftHUD.getPosition();
        ScriptVectorAngle rotate = minecraftHUD.getRotate();
        event.setCanceled(!render);
        if (render && event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR && event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            GL11.glPushMatrix();
            GL11.glRotated((double)rotate.angle, (double)rotate.x, (double)rotate.y, (double)rotate.z);
            GL11.glScaled((double)scale.x, (double)scale.y, (double)scale.z);
            GL11.glTranslated((double)pos.x, (double)pos.y, (double)pos.z);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderGuiPost(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR && event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onCameraRender(EntityViewRenderEvent.CameraSetup event) {
        Shake shake = Shake.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (shake.isActive()) {
            this.tickRender(shake);
            float ticks = animationProgress;
            float s = 1.0f - (float)shake.getZoom() * ticks / 10.0f;
            GlStateManager.func_179114_b((float)((ticks - (float)shake.getRotate().angle) * (float)shake.getRotation()), (float)((float)shake.getRotate().x), (float)((float)shake.getRotate().y), (float)((float)shake.getRotate().z));
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)s);
        }
    }

    public void tickRender(Shake shake) {
        if (isReversed) {
            if ((animationProgress = Math.max(animationProgress - (float)shake.getSpeed().x, 0.0f)) == 0.0f) {
                isReversed = false;
            }
        } else if ((animationProgress = Math.min(animationProgress + (float)shake.getSpeed().y, 1.0f)) == 1.0f) {
            isReversed = true;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPreRenderGame(EntityViewRenderEvent.CameraSetup event) {
        Camera camera = Camera.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (camera.isEnabled()) {
            event.setPitch(camera.getPitch());
            event.setYaw(camera.getYaw());
            event.setRoll(camera.getRoll());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void mouseEvent(MouseEvent event) {
        NBTTagCompound data = new NBTTagCompound();
        if (event.getButton() == -1) {
            return;
        }
        data.func_74768_a("button", event.getButton());
        data.func_74757_a("buttonState", event.isButtonstate());
        Dispatcher.sendToServer(new PacketEvent(AccessType.MOUSE, data));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void keyInputEvent(InputEvent.KeyInputEvent event) {
        NBTTagCompound data = new NBTTagCompound();
        if (!Keyboard.getEventKeyState()) {
            return;
        }
        data.func_74768_a("keyCode", Keyboard.getEventKey());
        Dispatcher.sendToServer(new PacketEvent(AccessType.KEYBOARD, data));
    }
}

