/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.List;
import mchorse.mappet.client.gui.scripts.themes.GuiThemeEditorOverlayPanel;
import mchorse.mappet.client.gui.scripts.themes.Themes;
import mchorse.mappet.client.gui.scripts.utils.SyntaxStyle;
import mchorse.mappet.client.gui.utils.overlays.GuiOverlay;
import mchorse.mappet.client.gui.utils.overlays.GuiOverlayPanel;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.config.gui.GuiConfigPanel;
import mchorse.mclib.config.values.IConfigGuiProvider;
import mchorse.mclib.config.values.Value;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ValueSyntaxStyle
extends Value
implements IConfigGuiProvider {
    private SyntaxStyle style = new SyntaxStyle();
    private String file = "monokai.json";

    public ValueSyntaxStyle(String id) {
        super(id);
        this.clientSide();
    }

    public SyntaxStyle get() {
        return this.style;
    }

    public String getFile() {
        return this.file;
    }

    public void set(String file, SyntaxStyle style) {
        this.file = file;
        this.style = new SyntaxStyle(style.toNBT());
        this.saveLater();
    }

    @SideOnly(value=Side.CLIENT)
    public List<GuiElement> getFields(Minecraft mc, GuiConfigPanel config) {
        GuiButtonElement button = new GuiButtonElement(mc, IKey.lang((String)"mappet.gui.syntax_theme.edit"), t -> GuiOverlay.addOverlay(GuiBase.getCurrent(), (GuiOverlayPanel)new GuiThemeEditorOverlayPanel(mc), 0.6f, 0.95f));
        return Arrays.asList(button.tooltip(IKey.lang((String)this.getCommentKey())));
    }

    public void valueFromJSON(JsonElement element) {
        String file = element.getAsString();
        SyntaxStyle style = Themes.readTheme(Themes.themeFile(file));
        if (style != null) {
            this.style = style;
            this.file = file;
        }
    }

    public JsonElement valueToJSON() {
        return new JsonPrimitive(this.file);
    }

    public void copy(Value value) {
        if (value instanceof ValueSyntaxStyle) {
            ValueSyntaxStyle config = (ValueSyntaxStyle)value;
            this.file = config.file;
            this.style = new SyntaxStyle(config.style.toNBT());
        }
    }
}

