/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.utils;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import mchorse.blockbuster.common.tileentity.TileEntityModel;
import mchorse.blockbuster.network.common.PacketModifyModelBlock;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.blocks.PacketEditConditionModel;
import mchorse.mappet.network.common.blocks.PacketEditRegion;
import mchorse.mappet.tile.TileConditionModel;
import mchorse.mappet.tile.TileRegion;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ScriptUtils {
    private static ScriptEngineManager manager;

    public static List<ScriptEngine> getAllEngines() {
        return ScriptUtils.getManager().getEngineFactories().stream().filter(factory -> !factory.getExtensions().contains("scala")).map(factory -> {
            try {
                return factory.getScriptEngine();
            }
            catch (Exception | NoClassDefFoundError ignored) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static ScriptEngine getEngineByExtension(String extension) {
        extension = extension.replace(".", "");
        ScriptEngine engine = ScriptUtils.getManager().getEngineByExtension(extension);
        if (extension.equals("py")) {
            try {
                Field fieldInterpreter = Class.forName("org.python.jsr223.PyScriptEngine").getDeclaredField("interp");
                fieldInterpreter.setAccessible(true);
                Object interpreter = fieldInterpreter.get(engine);
                Field fieldcFlags = Class.forName("org.python.util.PythonInterpreter").getDeclaredField("cflags");
                fieldcFlags.setAccessible(true);
                Object cFlags = fieldcFlags.get(interpreter);
                Class.forName("org.python.core.CompilerFlags").getDeclaredField("source_is_utf8").setBoolean(cFlags, true);
                return engine;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return engine;
    }

    public static void initiateScriptEngines() {
        List<ScriptEngine> engineList = ScriptUtils.getAllEngines();
        for (ScriptEngine engine : engineList) {
            try {
                if (engine.eval(Objects.equals(engine.getFactory().getLanguageName(), "python") ? "True" : "true").equals(Boolean.TRUE)) continue;
                throw new Exception("Something went wrong with " + engine.getFactory().getEngineName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static ScriptEngineManager getManager() {
        try {
            if (manager == null) {
                manager = new ScriptEngineManager();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return manager;
    }

    public static ScriptEngine sanitize(ScriptEngine engine) {
        Bindings bindings = engine.getBindings(100);
        bindings.remove("load");
        bindings.remove("loadWithNewGlobal");
        bindings.remove("exit");
        bindings.remove("quit");
        return engine;
    }

    public static String getScriptContent(ScriptObjectMirror script) {
        String fullScript = script.toString();
        String scriptContent = "";
        Pattern pattern = Pattern.compile("\\{(.*)\\}", 32);
        Matcher matcher = pattern.matcher(fullScript);
        if (matcher.find()) {
            scriptContent = matcher.group(1).trim();
        }
        String[] lines = scriptContent.split("\\n");
        int commonSpaces = Integer.MAX_VALUE;
        for (int i = 1; i < lines.length; ++i) {
            int spaceCount;
            for (spaceCount = 0; lines[i].length() > spaceCount && lines[i].charAt(spaceCount) == ' '; ++spaceCount) {
            }
            commonSpaces = Math.min(commonSpaces, spaceCount);
        }
        StringBuilder adjustedScript = new StringBuilder(lines[0].trim() + "\n");
        for (int i = 1; i < lines.length; ++i) {
            adjustedScript.append(lines[i].substring(commonSpaces)).append("\n");
        }
        scriptContent = adjustedScript.toString().trim();
        return scriptContent;
    }

    public static <T> void sendTileUpdatePacket(T tile) {
        block5: {
            try {
                if (tile instanceof TileEntityModel) {
                    TileEntityModel bbModelBlock = (TileEntityModel)tile;
                    PacketModifyModelBlock message = new PacketModifyModelBlock(bbModelBlock.func_174877_v(), bbModelBlock, true);
                    Dispatcher.DISPATCHER.get().sendToAll((IMessage)message);
                    break block5;
                }
                if (tile instanceof TileConditionModel) {
                    TileConditionModel conditionModelBlock = (TileConditionModel)((Object)tile);
                    NBTTagCompound tag = new NBTTagCompound();
                    PacketEditConditionModel message = new PacketEditConditionModel(conditionModelBlock.func_174877_v(), conditionModelBlock.toNBT(tag));
                    Dispatcher.DISPATCHER.get().sendToAll((IMessage)message);
                    break block5;
                }
                if (tile instanceof TileRegion) {
                    TileRegion region = (TileRegion)((Object)tile);
                    NBTTagCompound tag = new NBTTagCompound();
                    PacketEditRegion message = new PacketEditRegion(region.func_174877_v(), region.region.serializeNBT());
                    Dispatcher.DISPATCHER.get().sendToAll((IMessage)message);
                    break block5;
                }
                throw new IllegalArgumentException("Invalid tile type");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static <T extends Block, U extends TileEntity, V> V place(World mcWorld, BlockPos pos, T blockType, Class<U> tileEntityType, PostPlace<U> postPlace, Supplier<V> returnVal) {
        TileEntity tileEntity;
        if (mcWorld.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a) {
            mcWorld.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 6);
        }
        mcWorld.func_180501_a(pos, blockType.func_176223_P(), 6);
        if (mcWorld.func_180495_p(pos).func_177230_c() == blockType && (tileEntity = (TileEntity)tileEntityType.cast(mcWorld.func_175625_s(pos))) != null) {
            postPlace.apply(tileEntity);
            tileEntity.func_70296_d();
        }
        return returnVal.get();
    }

    public static interface PostPlace<T extends TileEntity> {
        public void apply(T var1);
    }
}

